/*
 * Decompiled with CFR 0.152.
 */
package cronapi.chatbot;

import com.ibm.watson.developer_cloud.assistant.v1.model.MessageResponse;
import cronapi.chatbot.ChatBotConfiguration;
import cronapi.chatbot.ChatBotException;
import cronapi.chatbot.elements.Carousel;
import cronapi.chatbot.elements.Location;
import cronapi.chatbot.elements.QuickReply;
import cronapi.chatbot.elements.TypeUrl;
import java.io.IOException;
import java.util.List;

public interface Messenger {
    public String getPlatform();

    default public void sendWatsonMessage(String conversationId, MessageResponse messageResponse) {
        List outputTextList = messageResponse.getOutput().getText();
        for (int i = 0; i < outputTextList.size(); ++i) {
            String outputText = (String)outputTextList.get(i);
            if (i == outputTextList.size() - 1 && (messageResponse.getContext().containsKey((Object)"location") || messageResponse.getContext().containsKey((Object)"carousel") || messageResponse.getContext().containsKey((Object)"quick_reply"))) {
                try {
                    if (messageResponse.getContext().containsKey((Object)"location")) {
                        String locationJson = ChatBotConfiguration.OBJECT_MAPPER.writeValueAsString(messageResponse.getContext().get((Object)"location"));
                        Location location = (Location)ChatBotConfiguration.OBJECT_MAPPER.readValue(locationJson, Location.class);
                        this.sendLocation(conversationId, location);
                    }
                    if (messageResponse.getContext().containsKey((Object)"carousel")) {
                        String carousel = ChatBotConfiguration.OBJECT_MAPPER.writeValueAsString(messageResponse.getContext().get((Object)"carousel"));
                        List carouselList = (List)ChatBotConfiguration.OBJECT_MAPPER.readValue(carousel, ChatBotConfiguration.TYPE_LIST_CAROUSEL);
                        this.sendCarousel(conversationId, carouselList);
                    }
                    if (messageResponse.getContext().containsKey((Object)"quick_reply")) {
                        String quickReply = ChatBotConfiguration.OBJECT_MAPPER.writeValueAsString(messageResponse.getContext().get((Object)"quick_reply"));
                        List quickReplyList = (List)ChatBotConfiguration.OBJECT_MAPPER.readValue(quickReply, ChatBotConfiguration.TYPE_LIST_QUICKREPLY);
                        if (quickReplyList.isEmpty()) {
                            this.sendTextMessage(conversationId, outputText);
                            continue;
                        }
                        this.sendQuickReply(conversationId, outputText, quickReplyList);
                        continue;
                    }
                    this.sendTextMessage(conversationId, outputText);
                    continue;
                }
                catch (IOException e) {
                    throw new ChatBotException(e);
                }
            }
            this.sendTextMessage(conversationId, outputText);
        }
    }

    public void sendLocation(String var1, Location var2);

    public void sendCarousel(String var1, List<Carousel> var2);

    public void sendQuickReply(String var1, String var2, List<QuickReply> var3);

    public void sendTextMessage(String var1, String var2);

    public String getUrlFromLocation(Location var1, TypeUrl var2);
}

