/*
 * Decompiled with CFR 0.152.
 */
package cronapi.chatbot.telegram;

import com.google.gson.Gson;
import cronapi.chatbot.ChatBotException;
import cronapi.chatbot.Messenger;
import cronapi.chatbot.elements.Carousel;
import cronapi.chatbot.elements.Location;
import cronapi.chatbot.elements.QuickReply;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.telegram.telegrambots.api.methods.BotApiMethod;
import org.telegram.telegrambots.api.methods.send.SendLocation;
import org.telegram.telegrambots.api.methods.send.SendMessage;
import org.telegram.telegrambots.api.methods.send.SendPhoto;
import org.telegram.telegrambots.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.api.objects.replykeyboard.buttons.InlineKeyboardButton;
import org.telegram.telegrambots.bots.DefaultAbsSender;
import org.telegram.telegrambots.bots.DefaultBotOptions;
import org.telegram.telegrambots.exceptions.TelegramApiException;

@Component
public class TelegramMessenger
extends DefaultAbsSender
implements Messenger {
    private final String token;
    private final String url;

    @Autowired
    public TelegramMessenger(@Value(value="${chatbot.telegram.token}") String token, @Value(value="${chatbot.telegram.url}") String url) {
        super(new DefaultBotOptions());
        this.token = token;
        this.url = url;
        this.setWebhook();
    }

    private void setWebhook() {
        try (CloseableHttpClient httpclient = HttpClientBuilder.create().build();){
            String requestUrl = this.getOptions().getBaseUrl() + this.token + "/" + "setwebhook";
            HttpPost httppost = new HttpPost(requestUrl);
            httppost.setConfig(this.getOptions().getRequestConfig());
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addTextBody("url", this.url);
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);){
                HttpEntity ht = response.getEntity();
                BufferedHttpEntity buf = new BufferedHttpEntity(ht);
                String responseContent = EntityUtils.toString((HttpEntity)buf, (Charset)StandardCharsets.UTF_8);
                JSONObject jsonObject = new JSONObject(responseContent);
                if (!jsonObject.getBoolean("ok")) {
                    throw new ChatBotException("Error setting webhook");
                }
            }
        }
        catch (JSONException e) {
            throw new ChatBotException("Error deserializing setWebhook method response", e);
        }
        catch (IOException e) {
            throw new ChatBotException("Error executing setWebook method", e);
        }
    }

    private InlineKeyboardMarkup quickReplyToInlineKeyboardMarkup(List<QuickReply> quickReplyList) {
        ArrayList<InlineKeyboardButton> inlineKeyboardRow = new ArrayList<InlineKeyboardButton>();
        for (QuickReply quickReply : quickReplyList) {
            InlineKeyboardButton inlineKeyboardButton = new InlineKeyboardButton();
            inlineKeyboardButton.setText(quickReply.getText());
            Object data = quickReply.getData();
            String url = quickReply.getUrl();
            if (data != null) {
                if (data instanceof String) {
                    inlineKeyboardButton.setCallbackData(data.toString());
                } else {
                    inlineKeyboardButton.setCallbackData(new Gson().toJson(data));
                }
            } else if (url != null) {
                inlineKeyboardButton.setUrl(url);
            }
            inlineKeyboardRow.add(inlineKeyboardButton);
        }
        InlineKeyboardMarkup replyMarkup = new InlineKeyboardMarkup();
        ArrayList<ArrayList<InlineKeyboardButton>> inlineKeyboard = new ArrayList<ArrayList<InlineKeyboardButton>>();
        inlineKeyboard.add(inlineKeyboardRow);
        replyMarkup.setKeyboard(inlineKeyboard);
        return replyMarkup;
    }

    @Override
    public String getPlatform() {
        return "Telegram";
    }

    @Override
    public void sendLocation(String conversationId, Location location) {
        try {
            SendLocation sendLocation = new SendLocation();
            sendLocation.setLatitude(location.getLatitude());
            sendLocation.setLongitude(location.getLongitude());
            sendLocation.setChatId(conversationId);
            this.execute((BotApiMethod)sendLocation);
        }
        catch (TelegramApiException e) {
            throw new ChatBotException(e);
        }
    }

    @Override
    public void sendCarousel(String conversationId, List<Carousel> carouselList) {
        try {
            for (Carousel carousel : carouselList) {
                SendPhoto sendPhoto = new SendPhoto();
                sendPhoto.setChatId(conversationId);
                sendPhoto.setCaption(carousel.getMessage());
                sendPhoto.setPhoto(carousel.getImage());
                List<QuickReply> quickReplyList = carousel.getQuickReply();
                if (quickReplyList != null) {
                    sendPhoto.setReplyMarkup((ReplyKeyboard)this.quickReplyToInlineKeyboardMarkup(quickReplyList));
                }
                this.sendPhoto(sendPhoto);
            }
        }
        catch (TelegramApiException e) {
            throw new ChatBotException(e);
        }
    }

    @Override
    public void sendQuickReply(String conversationId, String text, List<QuickReply> quickReply) {
        try {
            SendMessage sendMessage = new SendMessage();
            sendMessage.setText(text);
            sendMessage.setChatId(conversationId);
            sendMessage.setReplyMarkup((ReplyKeyboard)this.quickReplyToInlineKeyboardMarkup(quickReply));
            this.execute((BotApiMethod)sendMessage);
        }
        catch (TelegramApiException e) {
            throw new ChatBotException(e);
        }
    }

    @Override
    public void sendTextMessage(String conversationId, String text) {
        if (StringUtils.isEmpty((String)text)) {
            return;
        }
        try {
            SendMessage sendMessage = new SendMessage();
            sendMessage.setText(text);
            sendMessage.setChatId(conversationId);
            this.execute((BotApiMethod)sendMessage);
        }
        catch (TelegramApiException e) {
            throw new ChatBotException(e);
        }
    }

    public String getBotToken() {
        return this.token;
    }
}

