/*
 * Decompiled with CFR 0.152.
 */
package cronapi.chatbot.facebook;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.github.messenger4j.exception.MessengerApiException;
import com.github.messenger4j.exception.MessengerIOException;
import com.github.messenger4j.send.MessagePayload;
import com.github.messenger4j.send.MessagingType;
import com.github.messenger4j.send.Payload;
import com.github.messenger4j.send.message.Message;
import com.github.messenger4j.send.message.TemplateMessage;
import com.github.messenger4j.send.message.TextMessage;
import com.github.messenger4j.send.message.quickreply.TextQuickReply;
import com.github.messenger4j.send.message.template.GenericTemplate;
import com.github.messenger4j.send.message.template.Template;
import com.github.messenger4j.send.message.template.button.PostbackButton;
import com.github.messenger4j.send.message.template.button.UrlButton;
import com.github.messenger4j.send.message.template.common.DefaultAction;
import com.github.messenger4j.send.message.template.common.Element;
import cronapi.chatbot.ChatBotException;
import cronapi.chatbot.Messenger;
import cronapi.chatbot.elements.Carousel;
import cronapi.chatbot.elements.Location;
import cronapi.chatbot.elements.QuickReply;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FacebookMessenger
implements Messenger {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final com.github.messenger4j.Messenger messenger;

    @Autowired
    public FacebookMessenger(com.github.messenger4j.Messenger messenger) {
        this.messenger = messenger;
    }

    @Override
    public String getPlatform() {
        return "Facebook";
    }

    @Override
    public void sendLocation(String conversationId, Location location) {
        ArrayList<Element> elements = new ArrayList<Element>();
        String title = location.getTitle();
        if (title == null) {
            title = "Localiza\u00c3\u00a7\u00c3\u00a3o";
        }
        String latitude = location.getLatitude().toString();
        String longitude = location.getLongitude().toString();
        String image = "https://maps.googleapis.com/maps/api/staticmap?size=764x400&center=" + latitude + "," + longitude + "&zoom=25&markers=" + latitude + "," + longitude;
        String item = "http://maps.apple.com/maps?q=" + latitude + "," + longitude + "&z=16";
        try {
            elements.add(Element.create((String)title, Optional.empty(), Optional.of(new URL(image)), Optional.of(DefaultAction.create((URL)new URL(item))), Optional.empty()));
            GenericTemplate genericTemplate = GenericTemplate.create(elements);
            TemplateMessage templateMessage = TemplateMessage.create((Template)genericTemplate);
            this.messenger.send((Payload)MessagePayload.create((String)conversationId, (MessagingType)MessagingType.RESPONSE, (Message)templateMessage));
        }
        catch (MessengerApiException | MessengerIOException | MalformedURLException e) {
            throw new ChatBotException(e);
        }
    }

    @Override
    public void sendCarousel(String conversationId, List<Carousel> carouselList) {
        try {
            ArrayList<Element> elements = new ArrayList<Element>();
            for (Carousel carousel : carouselList) {
                ArrayList<Object> buttons = new ArrayList<Object>();
                for (QuickReply quickReply : carousel.getQuickReply()) {
                    if (quickReply.getUrl() != null) {
                        buttons.add(UrlButton.create((String)quickReply.getText(), (URL)new URL(quickReply.getUrl())));
                    } else {
                        Object data = quickReply.getData();
                        String payload = data instanceof String ? data.toString() : OBJECT_MAPPER.writeValueAsString(data);
                        buttons.add(PostbackButton.create((String)quickReply.getText(), (String)payload));
                    }
                    if (buttons.size() != 3) continue;
                    break;
                }
                elements.add(Element.create((String)carousel.getMessage(), Optional.empty(), Optional.of(new URL(carousel.getImage())), Optional.empty(), Optional.of(buttons)));
                if (elements.size() != 10) continue;
                break;
            }
            GenericTemplate genericTemplate = GenericTemplate.create(elements);
            TemplateMessage templateMessage = TemplateMessage.create((Template)genericTemplate);
            this.messenger.send((Payload)MessagePayload.create((String)conversationId, (MessagingType)MessagingType.RESPONSE, (Message)templateMessage));
        }
        catch (JsonProcessingException | MessengerApiException | MessengerIOException | MalformedURLException e) {
            throw new ChatBotException(e);
        }
    }

    @Override
    public void sendQuickReply(String conversationId, String text, List<QuickReply> quickReplyList) {
        try {
            ArrayList<TextQuickReply> facebookQuickReplyList = new ArrayList<TextQuickReply>();
            for (QuickReply quickReply : quickReplyList) {
                Object data = quickReply.getData();
                String payload = data instanceof String ? data.toString() : OBJECT_MAPPER.writeValueAsString(data);
                facebookQuickReplyList.add(TextQuickReply.create((String)quickReply.getText(), (String)payload));
            }
            TextMessage message = TextMessage.create((String)text, Optional.of(facebookQuickReplyList), Optional.empty());
            this.messenger.send((Payload)MessagePayload.create((String)conversationId, (MessagingType)MessagingType.RESPONSE, (Message)message));
        }
        catch (JsonProcessingException | MessengerApiException | MessengerIOException e) {
            throw new ChatBotException(e);
        }
    }

    @Override
    public void sendTextMessage(String conversationId, String text) {
        if (StringUtils.isEmpty((String)text)) {
            return;
        }
        try {
            TextMessage textMessage = TextMessage.create((String)text);
            MessagePayload messagePayload = MessagePayload.create((String)conversationId, (MessagingType)MessagingType.RESPONSE, (Message)textMessage);
            this.messenger.send((Payload)messagePayload);
        }
        catch (MessengerApiException | MessengerIOException e) {
            throw new ChatBotException(e);
        }
    }

    static {
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        OBJECT_MAPPER.setVisibility(OBJECT_MAPPER.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        OBJECT_MAPPER.setPropertyNamingStrategy(PropertyNamingStrategy.SnakeCaseStrategy.SNAKE_CASE);
    }
}

