/*
 * Decompiled with CFR 0.152.
 */
package cronapi.blockchaininfo;

import com.google.gson.JsonObject;
import cronapi.CronapiMetaData;
import info.blockchain.api.APIException;
import info.blockchain.api.blockexplorer.BlockExplorer;
import info.blockchain.api.blockexplorer.entity.Address;
import info.blockchain.api.blockexplorer.entity.Input;
import info.blockchain.api.blockexplorer.entity.Transaction;
import info.blockchain.api.exchangerates.Currency;
import info.blockchain.api.exchangerates.ExchangeRates;
import info.blockchain.api.receive.Receive;
import info.blockchain.api.receive.ReceiveResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Map;
import java.util.concurrent.Callable;

@CronapiMetaData(categoryName="Bitcoin-info Blockchain Operations", categoryTags={"Blockchain", "Bitcoin", "Crypto"})
public final class BitcoinInfoBlockchainOperations {
    @CronapiMetaData(name="{{listTransactionInputValues}}", description="{{listTransactionInputValuesDescription}}")
    public static JsonObject listTransactionInputValues(String hash) throws APIException, IOException {
        BlockExplorer blockExplorer = new BlockExplorer();
        Transaction tx = blockExplorer.getTransaction(hash);
        JsonObject inputList = new JsonObject();
        for (Input i : tx.getInputs()) {
            inputList.addProperty("txnumber", (Number)i.getPreviousOutput().getValue());
        }
        return inputList;
    }

    @CronapiMetaData(name="{{readFinalBalance}}", description="{{readFinalBalanceDescription}}")
    public static Long readFinalBalance(String hash) throws APIException, IOException {
        BlockExplorer blockExplorer = new BlockExplorer();
        Address address = blockExplorer.getAddress(hash);
        return address.getFinalBalance();
    }

    @CronapiMetaData(name="{{currencyToBtc}}", description="{{currencyToBtcDescription}}")
    public static BigDecimal convertToBtc(BigDecimal value, String currency) throws APIException, IOException {
        ExchangeRates exchange = new ExchangeRates();
        BigDecimal CurrencyToBTC = exchange.toBTC(currency, value);
        return CurrencyToBTC;
    }

    @CronapiMetaData(name="{{getBTCPrice}}", description="{{getBTCPriceDescription}}")
    public static BigDecimal getPrice(String currency) throws APIException, IOException {
        ExchangeRates exchange = new ExchangeRates();
        Map ticker = exchange.getTicker();
        BigDecimal BTCPrice = ((Currency)ticker.get(currency)).getSell();
        return BTCPrice;
    }

    @CronapiMetaData(name="{{receivePayments}}", description="{{receivePaymentsDescription}}")
    public static Callable receivePayments(String apiCode, String xPub, String callbackURL) throws APIException, IOException {
        Receive receive = new Receive(apiCode);
        ReceiveResponse response = receive.receive(xPub, callbackURL);
        return (Callable)response;
    }
}

