/*
 * Decompiled with CFR 0.152.
 */
package cronapi.chatbot.facebook;

import com.github.messenger4j.Messenger;
import com.github.messenger4j.exception.MessengerVerificationException;
import com.github.messenger4j.webhook.event.PostbackEvent;
import com.github.messenger4j.webhook.event.QuickReplyMessageEvent;
import com.github.messenger4j.webhook.event.TextMessageEvent;
import cronapi.chatbot.assistant.WatsonAssistant;
import cronapi.chatbot.facebook.FacebookMessenger;
import java.time.Instant;
import java.util.Optional;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cronapi/chatbot/facebook"})
public class FacebookMessengerWebhook {
    private final Logger LOGGER = Logger.getLogger(FacebookMessengerWebhook.class.getName());
    private final Messenger messenger;
    private final FacebookMessenger facebookMessenger;
    private final WatsonAssistant assistant;

    @Autowired
    public FacebookMessengerWebhook(Messenger messenger, FacebookMessenger facebookMessenger, WatsonAssistant assistant) {
        this.messenger = messenger;
        this.facebookMessenger = facebookMessenger;
        this.assistant = assistant;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ResponseEntity<String> verifyWebhook(@RequestParam(value="hub.mode") String mode, @RequestParam(value="hub.verify_token") String verifyToken, @RequestParam(value="hub.challenge") String challenge) {
        this.LOGGER.fine(() -> String.format("Received Facebook verification request - mode: %s | verifyToken: %s | challenge: %s", mode, verifyToken, challenge));
        try {
            this.messenger.verifyWebhook(mode, verifyToken);
            return ResponseEntity.ok((Object)challenge);
        }
        catch (MessengerVerificationException e) {
            this.LOGGER.warning(() -> String.format("Facebook verification failed: %s", e.getMessage()));
            return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body((Object)e.getMessage());
        }
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<Void> handleCallback(@RequestBody String payload, @RequestHeader(value="X-Hub-Signature") String signature) {
        this.LOGGER.fine(() -> String.format("Received Facebook callback - payload: %s | signature: %s", payload, signature));
        try {
            this.messenger.onReceiveEvents(payload, Optional.of(signature), event -> {
                if (event.isQuickReplyMessageEvent()) {
                    this.handleQuickReplyMessageEvent(event.asQuickReplyMessageEvent());
                } else if (event.isPostbackEvent()) {
                    this.handlePostbackEvent(event.asPostbackEvent());
                } else if (event.isTextMessageEvent()) {
                    this.handleTextMessageEvent(event.asTextMessageEvent());
                }
            });
            this.LOGGER.fine(() -> "Processed Facebook callback payload successfully");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).build();
        }
        catch (MessengerVerificationException e) {
            this.LOGGER.warning(() -> String.format("Processing of Facebook callback payload failed: %s", e.getMessage()));
            return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).build();
        }
    }

    private void handlePostbackEvent(PostbackEvent event) {
        this.LOGGER.fine(() -> String.format("Received PostbackEvent: %s", event));
        String senderId = event.senderId();
        Instant timestamp = event.timestamp();
        this.LOGGER.info(() -> String.format("Received Facebook post back from user '%s' at '%s'", senderId, timestamp));
        if (event.payload().isPresent()) {
            this.assistant.handleTextMessage(event.senderId(), (String)event.payload().get(), this.facebookMessenger);
        }
    }

    private void handleQuickReplyMessageEvent(QuickReplyMessageEvent event) {
        this.LOGGER.fine(() -> String.format("Received QuickReplyMessageEvent: %s", event));
        String messageId = event.messageId();
        String messageText = event.text();
        String senderId = event.senderId();
        Instant timestamp = event.timestamp();
        this.LOGGER.info(() -> String.format("Received Facebook quick reply '%s' with text '%s' from user '%s' at '%s'", messageId, messageText, senderId, timestamp));
        this.assistant.handleTextMessage(event.senderId(), event.payload(), this.facebookMessenger);
    }

    private void handleTextMessageEvent(TextMessageEvent event) {
        this.LOGGER.fine(() -> String.format("Received TextMessageEvent: %s", event));
        String messageId = event.messageId();
        String messageText = event.text();
        String senderId = event.senderId();
        Instant timestamp = event.timestamp();
        this.LOGGER.info(() -> String.format("Received Facebook message '%s' with text '%s' from user '%s' at '%s'", messageId, messageText, senderId, timestamp));
        this.assistant.handleTextMessage(event.senderId(), event.text(), this.facebookMessenger);
    }
}

