/*
 * Decompiled with CFR 0.152.
 */
package xyz.jetdrone.vertx.lambda.knative;

import io.netty.handler.codec.http.HttpHeaderValues;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.EncodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import xyz.jetdrone.vertx.lambda.Lambda;

public final class Bootstrap
extends AbstractVerticle {
    private static final int DEFAULT_INITIAL_BODY_BUFFER_SIZE = 1024;
    private static final String PORT_ENV_VAR = "PORT";
    private static final Logger log = LoggerFactory.getLogger(Bootstrap.class);

    public static void main(String[] args) {
        try {
            VertxOptions vertxOptions = new VertxOptions();
            JsonObject config = new JsonObject();
            DeploymentOptions deploymentOptions = new DeploymentOptions().setConfig(config);
            if (System.getenv(PORT_ENV_VAR) != null) {
                config.put("port", Integer.valueOf(Integer.parseInt(System.getenv(PORT_ENV_VAR), 10)));
            }
            boolean dryRun = Boolean.parseBoolean(System.getenv("DRYRUN"));
            config.put("dryRun", Boolean.valueOf(dryRun));
            Vertx vertx = Vertx.vertx((VertxOptions)vertxOptions);
            vertx.deployVerticle((Verticle)new Bootstrap(), deploymentOptions, deploy -> {
                if (deploy.failed()) {
                    System.err.println(deploy.cause().getMessage());
                    try {
                        vertx.close();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    System.exit(1);
                }
            });
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void start() {
        JsonObject config = this.context.config();
        EventBus eb = this.vertx.eventBus();
        String defaultFn = System.getenv("_HANDLER");
        if (!config.getBoolean("dryRun", Boolean.valueOf(false)).booleanValue()) {
            for (Lambda fn : ServiceLoader.load(Lambda.class)) {
                fn.init(this.vertx);
                eb.localConsumer(fn.alias(), (Handler)fn);
            }
        }
        this.vertx.createHttpServer().requestHandler(request -> {
            long contentLength = this.parseContentLengthHeader((HttpServerRequest)request);
            BHandler handler = new BHandler((HttpServerRequest)request, contentLength, (body, files) -> {
                Buffer event;
                if (request.headers() != null && "application/json".equals(request.headers().get(HttpHeaders.CONTENT_TYPE))) {
                    try {
                        event = new JsonObject(body);
                    }
                    catch (DecodeException e) {
                        this.fail((HttpServerRequest)request, e);
                        return;
                    }
                } else {
                    event = body;
                }
                String path = request.path();
                eb.send("/".equals(path) ? defaultFn : path, (Object)event, new DeliveryOptions().setHeaders(request.headers()), msg -> {
                    if (msg.failed()) {
                        this.fail((HttpServerRequest)request, msg.cause());
                    } else {
                        MultiMap fnHeaders = ((Message)msg.result()).headers();
                        Object fnResult = ((Message)msg.result()).body();
                        if (fnResult == null) {
                            request.response().setStatusCode(204);
                        } else {
                            if (fnResult instanceof JsonObject) {
                                try {
                                    request.response().putHeader("Content-Type", "application/json");
                                    request.response().headers().setAll(fnHeaders);
                                    request.response().end(((JsonObject)fnResult).toBuffer());
                                }
                                catch (EncodeException e) {
                                    this.fail((HttpServerRequest)request, e);
                                }
                                return;
                            }
                            if (fnResult instanceof Buffer) {
                                request.response().headers().setAll(fnHeaders);
                                request.response().end((Buffer)fnResult);
                                return;
                            }
                            if (fnResult instanceof String) {
                                request.response().headers().setAll(fnHeaders);
                                request.response().end((String)fnResult);
                                return;
                            }
                            this.fail((HttpServerRequest)request, "Response is not Buffer of JSON");
                        }
                    }
                });
            });
            request.handler((Handler)handler);
            request.endHandler(v -> handler.end());
        }).listen(config.getInteger("port", Integer.valueOf(8080)).intValue(), listen -> {
            if (listen.failed()) {
                listen.cause().printStackTrace();
                try {
                    this.vertx.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                System.exit(1);
            }
        });
    }

    private long parseContentLengthHeader(HttpServerRequest request) {
        String contentLength = request.getHeader(HttpHeaders.CONTENT_LENGTH);
        if (contentLength == null || contentLength.isEmpty()) {
            return -1L;
        }
        try {
            long parsedContentLength = Long.parseLong(contentLength);
            return parsedContentLength < 0L ? -1L : parsedContentLength;
        }
        catch (NumberFormatException ex) {
            return -1L;
        }
    }

    private void fail(HttpServerRequest request, String errType, String errMsg, String errTrace) {
        System.err.println("ERR: " + errMsg);
        JsonObject error = new JsonObject().put("errorType", errType).put("errorMessage", errMsg);
        if (errTrace != null) {
            JsonArray trace = new JsonArray();
            error.put("trace", trace);
            for (String line : errTrace.split("\r?\n")) {
                trace.add(line);
            }
        }
        request.response().setStatusCode(500).putHeader("Content-Type", "application/json").end(error.toBuffer());
    }

    private void fail(HttpServerRequest request, String errMsg) {
        this.fail(request, "RuntimeError", errMsg, null);
    }

    private void fail(HttpServerRequest request, Throwable throwable) {
        try (StringWriter sw = new StringWriter();){
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            this.fail(request, throwable.getClass().getSimpleName(), throwable.getMessage(), sw.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                this.vertx.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            System.exit(1);
        }
    }

    private class BHandler
    implements Handler<Buffer> {
        private static final int MAX_PREALLOCATED_BODY_BUFFER_BYTES = 65535;
        private Buffer body;
        private Set<String> fileUploads;
        private HttpServerRequest request;
        boolean failed;
        AtomicInteger uploadCount = new AtomicInteger();
        AtomicBoolean cleanup = new AtomicBoolean(false);
        boolean ended;
        long uploadSize = 0L;
        final boolean isMultipart;
        final boolean isUrlEncoded;
        final BiConsumer<Buffer, Set<String>> ready;

        public BHandler(HttpServerRequest request, long contentLength, BiConsumer<Buffer, Set<String>> ready) {
            this.request = request;
            this.ready = ready;
            String contentType = request.getHeader(HttpHeaders.CONTENT_TYPE);
            if (contentType == null) {
                this.isMultipart = false;
                this.isUrlEncoded = false;
            } else {
                String lowerCaseContentType = contentType.toLowerCase();
                this.isMultipart = lowerCaseContentType.startsWith(HttpHeaderValues.MULTIPART_FORM_DATA.toString());
                this.isUrlEncoded = lowerCaseContentType.startsWith(HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.toString());
            }
            this.initBodyBuffer(contentLength);
            if (this.isMultipart || this.isUrlEncoded) {
                request.setExpectMultipart(true);
                this.fileUploads = new HashSet<String>();
                request.uploadHandler(upload -> {
                    this.uploadCount.incrementAndGet();
                    String uploadedFileName = new File(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString()).getPath();
                    upload.streamToFileSystem(uploadedFileName);
                    this.fileUploads.add(uploadedFileName);
                    upload.exceptionHandler(t -> {
                        this.deleteFileUploads(this.fileUploads);
                        Bootstrap.this.fail(request, t);
                    });
                    upload.endHandler(v -> this.uploadEnded());
                });
            }
            request.exceptionHandler(t -> {
                this.deleteFileUploads(this.fileUploads);
                Bootstrap.this.fail(request, t);
            });
        }

        private void initBodyBuffer(long contentLength) {
            int initialBodyBufferSize = contentLength < 0L ? 1024 : (contentLength > 65535L ? 65535 : (int)contentLength);
            this.body = Buffer.buffer((int)initialBodyBufferSize);
        }

        public void handle(Buffer buff) {
            if (this.failed) {
                return;
            }
            this.uploadSize += (long)buff.length();
            if (!this.isMultipart) {
                this.body.appendBuffer(buff);
            }
        }

        void uploadEnded() {
            int count = this.uploadCount.decrementAndGet();
            if (this.ended && count == 0) {
                this.doEnd();
            }
        }

        void end() {
            this.ended = true;
            if (this.uploadCount.get() == 0) {
                this.doEnd();
            }
        }

        void doEnd() {
            if (this.failed) {
                this.deleteFileUploads(this.fileUploads);
                return;
            }
            this.request.response().endHandler(v -> this.deleteFileUploads(this.fileUploads));
            this.request.response().exceptionHandler(v -> this.deleteFileUploads(this.fileUploads));
            this.ready.accept(this.body, this.fileUploads);
        }

        private void deleteFileUploads(Set<String> fileUploads) {
            if (this.cleanup.compareAndSet(false, true) && fileUploads != null) {
                FileSystem fileSystem = Bootstrap.this.vertx.fileSystem();
                for (String uploadedFileName : fileUploads) {
                    fileSystem.exists(uploadedFileName, existResult -> {
                        if (existResult.failed()) {
                            log.warn((Object)("Could not detect if uploaded file exists, not deleting: " + uploadedFileName), existResult.cause());
                        } else if (((Boolean)existResult.result()).booleanValue()) {
                            fileSystem.delete(uploadedFileName, deleteResult -> {
                                if (deleteResult.failed()) {
                                    log.warn((Object)("Delete of uploaded file failed: " + uploadedFileName), deleteResult.cause());
                                }
                            });
                        }
                    });
                }
            }
        }
    }
}

