/*
 * Decompiled with CFR 0.152.
 */
package xyz.jetdrone.vertx.lambda.aws.event;

import io.vertx.core.json.JsonObject;
import java.util.Map;
import xyz.jetdrone.vertx.lambda.aws.event.S3Entity;
import xyz.jetdrone.vertx.lambda.aws.event.S3EventRecord;
import xyz.jetdrone.vertx.lambda.aws.event.S3RequestParameters;
import xyz.jetdrone.vertx.lambda.aws.event.S3UserIdentity;

public class S3EventRecordConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, S3EventRecord obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "awsRegion": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAwsRegion((String)member.getValue());
                    break;
                }
                case "eventName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setEventName((String)member.getValue());
                    break;
                }
                case "eventSource": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setEventSource((String)member.getValue());
                    break;
                }
                case "eventVersion": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setEventVersion((String)member.getValue());
                    break;
                }
                case "requestParameters": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setRequestParameters(new S3RequestParameters((JsonObject)member.getValue()));
                    break;
                }
                case "responseElements": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setResponseElements(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "s3": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setS3(new S3Entity((JsonObject)member.getValue()));
                    break;
                }
                case "userIdentity": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setUserIdentity(new S3UserIdentity((JsonObject)member.getValue()));
                }
            }
        }
    }

    public static void toJson(S3EventRecord obj, JsonObject json) {
        S3EventRecordConverter.toJson(obj, json.getMap());
    }

    public static void toJson(S3EventRecord obj, Map<String, Object> json) {
        if (obj.getAwsRegion() != null) {
            json.put("awsRegion", obj.getAwsRegion());
        }
        if (obj.getEventName() != null) {
            json.put("eventName", obj.getEventName());
        }
        if (obj.getEventSource() != null) {
            json.put("eventSource", obj.getEventSource());
        }
        if (obj.getEventVersion() != null) {
            json.put("eventVersion", obj.getEventVersion());
        }
        if (obj.getRequestParameters() != null) {
            json.put("requestParameters", obj.getRequestParameters().toJson());
        }
        if (obj.getResponseElements() != null) {
            json.put("responseElements", obj.getResponseElements());
        }
        if (obj.getS3() != null) {
            json.put("s3", obj.getS3().toJson());
        }
        if (obj.getUserIdentity() != null) {
            json.put("userIdentity", obj.getUserIdentity().toJson());
        }
    }
}

