/*
 * Decompiled with CFR 0.152.
 */
package xyz.jetdrone.vertx.lambda.aws.event;

import io.vertx.core.json.JsonObject;
import java.util.Map;
import xyz.jetdrone.vertx.lambda.aws.event.S3Bucket;
import xyz.jetdrone.vertx.lambda.aws.event.S3Entity;
import xyz.jetdrone.vertx.lambda.aws.event.S3Object;

public class S3EntityConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, S3Entity obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "bucket": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setBucket(new S3Bucket((JsonObject)member.getValue()));
                    break;
                }
                case "configurationId": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setConfigurationId((String)member.getValue());
                    break;
                }
                case "object": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setObject(new S3Object((JsonObject)member.getValue()));
                    break;
                }
                case "s3SchemaVersion": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setS3SchemaVersion((String)member.getValue());
                }
            }
        }
    }

    public static void toJson(S3Entity obj, JsonObject json) {
        S3EntityConverter.toJson(obj, json.getMap());
    }

    public static void toJson(S3Entity obj, Map<String, Object> json) {
        if (obj.getBucket() != null) {
            json.put("bucket", obj.getBucket().toJson());
        }
        if (obj.getConfigurationId() != null) {
            json.put("configurationId", obj.getConfigurationId());
        }
        if (obj.getObject() != null) {
            json.put("object", obj.getObject().toJson());
        }
        if (obj.getS3SchemaVersion() != null) {
            json.put("s3SchemaVersion", obj.getS3SchemaVersion());
        }
    }
}

