/*
 * Decompiled with CFR 0.152.
 */
package xyz.jetdrone.vertx.lambda.aws.event;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import java.util.Map;
import xyz.jetdrone.vertx.lambda.aws.event.S3Bucket;
import xyz.jetdrone.vertx.lambda.aws.event.S3EntityConverter;
import xyz.jetdrone.vertx.lambda.aws.event.S3Object;

@DataObject(generateConverter=true)
public class S3Entity {
    private S3Bucket bucket;
    private String configurationId;
    private S3Object object;
    private String s3SchemaVersion;

    public S3Entity() {
    }

    public S3Entity(JsonObject json) {
        S3EntityConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        S3EntityConverter.toJson(this, json);
        return json;
    }

    public S3Bucket getBucket() {
        return this.bucket;
    }

    public S3Entity setBucket(S3Bucket bucket) {
        this.bucket = bucket;
        return this;
    }

    public String getConfigurationId() {
        return this.configurationId;
    }

    public S3Entity setConfigurationId(String configurationId) {
        this.configurationId = configurationId;
        return this;
    }

    public S3Object getObject() {
        return this.object;
    }

    public S3Entity setObject(S3Object object) {
        this.object = object;
        return this;
    }

    public String getS3SchemaVersion() {
        return this.s3SchemaVersion;
    }

    public S3Entity setS3SchemaVersion(String s3SchemaVersion) {
        this.s3SchemaVersion = s3SchemaVersion;
        return this;
    }

    public String toString() {
        return this.toJson().encodePrettily();
    }
}

