/*
 * Decompiled with CFR 0.152.
 */
package xyz.jetdrone.vertx.lambda.aws.event;

import io.vertx.core.json.JsonObject;
import java.util.Map;
import xyz.jetdrone.vertx.lambda.aws.event.S3Bucket;
import xyz.jetdrone.vertx.lambda.aws.event.S3UserIdentity;

public class S3BucketConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, S3Bucket obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "arn": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setArn((String)member.getValue());
                    break;
                }
                case "name": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setName((String)member.getValue());
                    break;
                }
                case "ownerIdentity": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setOwnerIdentity(new S3UserIdentity((JsonObject)member.getValue()));
                }
            }
        }
    }

    public static void toJson(S3Bucket obj, JsonObject json) {
        S3BucketConverter.toJson(obj, json.getMap());
    }

    public static void toJson(S3Bucket obj, Map<String, Object> json) {
        if (obj.getArn() != null) {
            json.put("arn", obj.getArn());
        }
        if (obj.getName() != null) {
            json.put("name", obj.getName());
        }
        if (obj.getOwnerIdentity() != null) {
            json.put("ownerIdentity", obj.getOwnerIdentity().toJson());
        }
    }
}

