/*
 * Decompiled with CFR 0.152.
 */
package xyz.jetdrone.vertx.lambda.aws.event;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import java.util.Base64;
import java.util.Map;
import xyz.jetdrone.vertx.lambda.aws.event.KinesisRecord;
import xyz.jetdrone.vertx.lambda.aws.event.SecondsEpochTime;

public class KinesisRecordConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, KinesisRecord obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "approximateArrivalTimestamp": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setApproximateArrivalTimestamp(new SecondsEpochTime((JsonObject)member.getValue()));
                    break;
                }
                case "data": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setData(Buffer.buffer((byte[])Base64.getDecoder().decode((String)member.getValue())));
                    break;
                }
                case "encryptionType": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setEncryptionType((String)member.getValue());
                    break;
                }
                case "kinesisSchemaVersion": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setKinesisSchemaVersion((String)member.getValue());
                    break;
                }
                case "partitionKey": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPartitionKey((String)member.getValue());
                    break;
                }
                case "sequenceNumber": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setSequenceNumber((String)member.getValue());
                }
            }
        }
    }

    public static void toJson(KinesisRecord obj, JsonObject json) {
        KinesisRecordConverter.toJson(obj, json.getMap());
    }

    public static void toJson(KinesisRecord obj, Map<String, Object> json) {
        if (obj.getApproximateArrivalTimestamp() != null) {
            json.put("approximateArrivalTimestamp", obj.getApproximateArrivalTimestamp().toJson());
        }
        if (obj.getData() != null) {
            json.put("data", Base64.getEncoder().encodeToString(obj.getData().getBytes()));
        }
        if (obj.getEncryptionType() != null) {
            json.put("encryptionType", obj.getEncryptionType());
        }
        if (obj.getKinesisSchemaVersion() != null) {
            json.put("kinesisSchemaVersion", obj.getKinesisSchemaVersion());
        }
        if (obj.getPartitionKey() != null) {
            json.put("partitionKey", obj.getPartitionKey());
        }
        if (obj.getSequenceNumber() != null) {
            json.put("sequenceNumber", obj.getSequenceNumber());
        }
    }
}

