/*
 * Decompiled with CFR 0.152.
 */
package xyz.jetdrone.vertx.lambda.aws.event;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import java.util.Base64;
import java.util.Map;
import xyz.jetdrone.vertx.lambda.aws.event.KinesisFirehoseEventRecord;
import xyz.jetdrone.vertx.lambda.aws.event.MilliSecondsEpochTime;

public class KinesisFirehoseEventRecordConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, KinesisFirehoseEventRecord obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "approximateArrivalTimestamp": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setApproximateArrivalTimestamp(new MilliSecondsEpochTime((JsonObject)member.getValue()));
                    break;
                }
                case "data": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setData(Buffer.buffer((byte[])Base64.getDecoder().decode((String)member.getValue())));
                    break;
                }
                case "recordId": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setRecordId((String)member.getValue());
                }
            }
        }
    }

    public static void toJson(KinesisFirehoseEventRecord obj, JsonObject json) {
        KinesisFirehoseEventRecordConverter.toJson(obj, json.getMap());
    }

    public static void toJson(KinesisFirehoseEventRecord obj, Map<String, Object> json) {
        if (obj.getApproximateArrivalTimestamp() != null) {
            json.put("approximateArrivalTimestamp", obj.getApproximateArrivalTimestamp().toJson());
        }
        if (obj.getData() != null) {
            json.put("data", Base64.getEncoder().encodeToString(obj.getData().getBytes()));
        }
        if (obj.getRecordId() != null) {
            json.put("recordId", obj.getRecordId());
        }
    }
}

