/*
 * Decompiled with CFR 0.152.
 */
package xyz.jetdrone.vertx.lambda.aws;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.EncodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ServiceLoader;
import xyz.jetdrone.vertx.lambda.Lambda;

public final class Bootstrap
extends AbstractVerticle {
    private static final String LAMBDA_VERSION_DATE = "2018-06-01";
    private static final String LAMBDA_INIT_ERROR = "/2018-06-01/runtime/init/error";
    private static final String LAMBDA_INVOCATION = "/2018-06-01/runtime/invocation/";
    private static final String LAMBDA_INVOCATION_NEXT = "/2018-06-01/runtime/invocation/next";
    private static final String RESPONSE = "/response";
    private static final String ERROR = "/error";
    private static final ServiceLoader<Lambda> SERVICE_LOADER = ServiceLoader.load(Lambda.class);
    private final String host;
    private final int port;
    private WebClient client;
    private String fn;

    public static void main(String[] args) {
        Vertx vertx = Vertx.vertx((VertxOptions)new VertxOptions().setEventLoopPoolSize(1));
        try {
            Bootstrap.main(vertx);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            vertx.close();
            System.exit(1);
        }
    }

    public static void main(Vertx vertx) {
        String runtimeApi;
        String host = runtimeApi = System.getenv("AWS_LAMBDA_RUNTIME_API");
        int port = 80;
        if (runtimeApi == null) {
            throw new IllegalStateException("Missing ENV_VAR [AWS_LAMBDA_RUNTIME_API]");
        }
        int sep = runtimeApi.indexOf(58);
        if (sep != -1) {
            host = runtimeApi.substring(0, sep);
            port = Integer.parseInt(runtimeApi.substring(sep + 1));
        }
        vertx.deployVerticle((Verticle)new Bootstrap(host, port), deploy -> {
            if (deploy.failed()) {
                System.err.println(deploy.cause().getMessage());
                try {
                    vertx.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                System.exit(1);
            }
        });
    }

    private Bootstrap(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void start() {
        EventBus eb = this.vertx.eventBus();
        for (Lambda fn : SERVICE_LOADER) {
            fn.init(this.vertx);
            eb.localConsumer(fn.getClass().getName(), (Handler)fn);
        }
        this.client = WebClient.create((Vertx)this.vertx, (WebClientOptions)new WebClientOptions().setDefaultPort(this.port).setDefaultHost(this.host));
        this.fn = System.getenv("_HANDLER");
        if (this.fn == null) {
            this.fail(LAMBDA_INIT_ERROR, "Could not find handler [" + this.fn + "]");
        } else {
            this.processEvents();
        }
    }

    private void processEvents() {
        EventBus eb = this.vertx.eventBus();
        this.client.get(LAMBDA_INVOCATION_NEXT).send(getAbs -> {
            if (getAbs.succeeded()) {
                Object event;
                HttpResponse response = (HttpResponse)getAbs.result();
                switch (response.statusCode()) {
                    case 200: {
                        break;
                    }
                    case 404: {
                        this.exit(0);
                    }
                    default: {
                        System.err.println("ERR: HTTP status code <" + response.statusCode() + ">");
                        this.exit(1);
                    }
                }
                String requestId = response.getHeader("Lambda-Runtime-Aws-Request-Id");
                if (response.headers() != null && "application/json".equals(response.headers().get(HttpHeaders.CONTENT_TYPE))) {
                    try {
                        event = new JsonObject((Buffer)response.body());
                    }
                    catch (DecodeException e) {
                        this.fail(LAMBDA_INVOCATION + requestId + ERROR, e);
                        return;
                    }
                } else {
                    event = response.body();
                }
                eb.send(this.fn, event, new DeliveryOptions().setHeaders(response.headers()), msg -> {
                    if (msg.failed()) {
                        this.fail(LAMBDA_INVOCATION + requestId + ERROR, msg.cause());
                    } else {
                        String invocationUrl = LAMBDA_INVOCATION + requestId + RESPONSE;
                        MultiMap fnHeaders = ((Message)msg.result()).headers();
                        Object fnResult = ((Message)msg.result()).body();
                        if (fnResult instanceof JsonObject) {
                            try {
                                this.success(invocationUrl, (JsonObject)fnResult, fnHeaders, (Handler<AsyncResult<Void>>)((Handler)this::next));
                            }
                            catch (EncodeException e) {
                                this.fail(LAMBDA_INVOCATION + requestId + ERROR, e);
                            }
                            return;
                        }
                        if (fnResult instanceof Buffer) {
                            this.success(invocationUrl, (Buffer)fnResult, fnHeaders, (Handler<AsyncResult<Void>>)((Handler)this::next));
                            return;
                        }
                        if (fnResult instanceof String) {
                            this.success(invocationUrl, Buffer.buffer((String)((String)fnResult)), fnHeaders, (Handler<AsyncResult<Void>>)((Handler)this::next));
                            return;
                        }
                        this.fail(LAMBDA_INVOCATION + requestId + ERROR, "Response is not Buffer of JSON");
                    }
                });
            } else {
                getAbs.cause().printStackTrace();
                this.exit(1);
            }
        });
    }

    private void next(AsyncResult<Void> ack) {
        if (ack.failed()) {
            ack.cause().printStackTrace();
            this.exit(1);
        } else {
            this.vertx.runOnContext(v -> this.processEvents());
        }
    }

    private void success(String requestURI, Buffer result, MultiMap header, Handler<AsyncResult<Void>> handler) {
        this.client.post(requestURI).putHeaders(header).sendBuffer(result, ar -> {
            if (ar.succeeded()) {
                handler.handle((Object)Future.succeededFuture());
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
    }

    private void success(String requestURI, JsonObject result, MultiMap headers, Handler<AsyncResult<Void>> handler) {
        HttpRequest request = this.client.post(requestURI);
        if (headers != null) {
            request.putHeaders(headers);
        }
        request.sendJson((Object)result, ar -> {
            if (ar.succeeded()) {
                handler.handle((Object)Future.succeededFuture());
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
    }

    private void fail(String requestURI, String errType, String errMsg, String errTrace) {
        System.err.println("ERR: " + errMsg);
        JsonObject error = new JsonObject().put("errorType", errType).put("errorMessage", errMsg);
        if (errTrace != null) {
            JsonArray trace = new JsonArray();
            error.put("trace", trace);
            for (String line : errTrace.split("\r?\n")) {
                trace.add(line);
            }
        }
        this.client.post(requestURI).sendJson((Object)error, ar -> {
            if (ar.failed()) {
                ar.cause().printStackTrace();
            }
            this.exit(1);
        });
    }

    private void fail(String requestURI, String errMsg) {
        this.fail(requestURI, "RuntimeError", errMsg, null);
    }

    private void fail(String requestURI, Throwable throwable) {
        try (StringWriter sw = new StringWriter();){
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            this.fail(requestURI, throwable.getClass().getSimpleName(), throwable.getMessage(), sw.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            this.exit(1);
        }
    }

    private void exit(int status) {
        try {
            this.vertx.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.exit(status);
    }

    static {
        System.setProperty("vertx.disableMetrics", "true");
        System.setProperty("vertx.disableH2c", "true");
        System.setProperty("vertx.disableWebsockets", "true");
        System.setProperty("vertx.flashPolicyHandler", "true");
    }
}

