/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.wsdl11.builder;

import java.util.Collection;
import javax.wsdl.WSDLException;
import org.codehaus.xfire.AbstractXFireComponent;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.object.ObjectService;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.wsdl.WSDLWriter;
import org.codehaus.xfire.wsdl11.builder.DocumentWSDL;
import org.codehaus.xfire.wsdl11.builder.RPCEncodedWSDL;
import org.codehaus.xfire.wsdl11.builder.WrappedWSDL;

public class WSDLBuilder
extends AbstractXFireComponent {
    private TransportManager manager;

    public WSDLBuilder(TransportManager manager) {
        this.manager = manager;
    }

    public WSDLWriter createWSDLWriter(Service s) throws WSDLException {
        ObjectService service = (ObjectService)s;
        Collection transports = this.manager.getTransports(service.getName());
        if (service.getStyle().equals("wrapped") && service.getUse().equals("literal")) {
            return new WrappedWSDL(service, transports);
        }
        if (service.getStyle().equals("document") && service.getUse().equals("literal")) {
            return new DocumentWSDL(service, transports);
        }
        if (service.getStyle().equals("rpc") && service.getUse().equals("encoded")) {
            return new RPCEncodedWSDL(service, transports);
        }
        throw new UnsupportedOperationException("Service style/use combination is not supported: " + service.getStyle() + "/" + service.getUse());
    }
}

