/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.message.bridge;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.message.MessageReader;
import org.codehaus.xfire.message.bridge.AbstractMessageBridge;
import org.codehaus.xfire.message.stax.ElementReader;
import org.codehaus.xfire.message.stax.ElementWriter;
import org.codehaus.xfire.service.object.Operation;
import org.codehaus.xfire.service.object.Parameter;
import org.codehaus.xfire.util.DepthXMLStreamReader;

public class DocumentBridge
extends AbstractMessageBridge {
    public DocumentBridge(MessageContext context) {
        super(context);
    }

    public List read() throws XFireFault {
        ArrayList<Object> parameters = new ArrayList<Object>();
        DepthXMLStreamReader dr = new DepthXMLStreamReader(this.getRequestReader());
        ElementReader topReader = new ElementReader(dr);
        while (topReader.hasMoreElementReaders()) {
            MessageReader reader = topReader.getNextElementReader();
            Parameter p = this.findParameter(reader.getName());
            if (p == null) {
                throw new XFireFault("Parameter " + reader.getName() + " does not exist!", "Sender");
            }
            parameters.add(p.read(reader, this.getContext()));
        }
        this.setOperation(this.findOperation(parameters.size()));
        return parameters;
    }

    protected Parameter findParameter(QName name) {
        Iterator itr = this.getService().getOperations().iterator();
        while (itr.hasNext()) {
            Operation op = (Operation)itr.next();
            Parameter p = op.getInParameter(name);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    protected Operation findOperation(int i) {
        Iterator itr = this.getService().getOperations().iterator();
        while (itr.hasNext()) {
            Operation o = (Operation)itr.next();
            if (o.getInParameters().size() != i) continue;
            return o;
        }
        return null;
    }

    public void write(Object[] values) throws XFireFault {
        int i = 0;
        Iterator itr = this.getOperation().getOutParameters().iterator();
        while (itr.hasNext()) {
            Parameter outParam = (Parameter)itr.next();
            outParam.write(values[i], new ElementWriter(this.getResponseWriter()), this.getContext());
            ++i;
        }
    }
}

