/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.sqlite;

import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.ConnectionOptions;
import schemacrawler.schemacrawler.ExcludeAll;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import schemacrawler.schemacrawler.SingleUseUserCredentials;
import schemacrawler.schemacrawler.UserCredentials;
import schemacrawler.tools.integration.graph.GraphExecutable;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.sqlite.SQLiteDatabaseConnector;
import sf.util.DatabaseUtility;
import sf.util.IOUtility;

public class SchemaCrawlerSQLiteUtility {
    public static Connection createDatabaseConnection(Path dbFile) throws SchemaCrawlerException {
        Connection connection;
        Objects.requireNonNull(dbFile, "No SQLite database file provided");
        if (!IOUtility.isFileReadable((Path)dbFile)) {
            throw new SchemaCrawlerException("Cannot read, " + dbFile);
        }
        Config config = new Config();
        config.put("server", "sqlite");
        config.put("database", dbFile.toString());
        ConnectionOptions connectionOptions = new SQLiteDatabaseConnector().newDatabaseConnectionOptions((UserCredentials)new SingleUseUserCredentials(), config);
        try {
            connection = connectionOptions.getConnection();
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Cannot read SQLite database " + dbFile, (Throwable)e);
        }
        return connection;
    }

    public static Path createSchemaCrawlerDiagram(Path dbFile, String extension) throws Exception {
        try (Connection connection = SchemaCrawlerSQLiteUtility.createDatabaseConnection(dbFile);){
            Path path = SchemaCrawlerSQLiteUtility.createSchemaCrawlerDiagram(connection, extension);
            return path;
        }
    }

    private static Path createSchemaCrawlerDiagram(Connection connection, String extension) throws Exception {
        DatabaseUtility.checkConnection((Connection)connection);
        SchemaCrawlerOptions options = new SchemaCrawlerOptions();
        options.setSchemaInfoLevel(SchemaInfoLevelBuilder.standard());
        options.setRoutineInclusionRule((InclusionRule)new ExcludeAll());
        Path diagramFile = IOUtility.createTempFilePath((String)"schemacrawler", (String)extension);
        OutputOptions outputOptions = new OutputOptions(extension, diagramFile);
        GraphExecutable executable = new GraphExecutable("schema");
        executable.setSchemaCrawlerOptions(options);
        executable.setOutputOptions(outputOptions);
        executable.execute(connection);
        return diagramFile;
    }

    private SchemaCrawlerSQLiteUtility() {
    }
}

