/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.transforms;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import io.vavr.Tuple4;
import io.vavr.collection.IndexedSeq;
import io.vavr.collection.Vector;
import io.vavr.control.Option;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import uk.modl.ancestry.Child;
import uk.modl.ancestry.Parent;
import uk.modl.model.Array;
import uk.modl.model.ArrayItem;
import uk.modl.model.Condition;
import uk.modl.model.FalsePrimitive;
import uk.modl.model.Map;
import uk.modl.model.MapItem;
import uk.modl.model.NullPrimitive;
import uk.modl.model.NumberPrimitive;
import uk.modl.model.Operator;
import uk.modl.model.Pair;
import uk.modl.model.PairValue;
import uk.modl.model.Primitive;
import uk.modl.model.StringPrimitive;
import uk.modl.model.Structure;
import uk.modl.model.TruePrimitive;
import uk.modl.model.ValueConditional;
import uk.modl.model.ValueItem;
import uk.modl.parser.errors.DeepReferenceException;
import uk.modl.parser.errors.InterpreterError;
import uk.modl.transforms.MethodsTransform;
import uk.modl.transforms.TransformationContext;
import uk.modl.utils.Util;

public class ReferencesTransform {
    private static final Pattern referencePattern = Pattern.compile("(((\\\\%|~%|%)\\w+)(\\.\\w*<`?\\w*`?,`\\w*`>)+|((\\\\%|~%|%)` ?[\\w-]+`[\\w.<>,]*%?)|((\\\\%|~%|%)\\*?[\\w]+(\\.%?\\w*(<[\\w, `]*>)?)*%?)|(%`[ %\\w-]+`(\\.\\w+)+)|(%`.+`))");
    private final MethodsTransform methodsTransform = new MethodsTransform();

    private static ReferenceType refToRefType(String s) {
        String refKey = ReferencesTransform.stripLeadingAndTrailingPercents(s);
        if (s.contains(".")) {
            return ReferenceType.COMPLEX_REF;
        }
        if (StringUtils.isNumeric(refKey)) {
            return ReferenceType.OBJECT_INDEX_REF;
        }
        if (s.startsWith("%`")) {
            return ReferenceType.LITERAL_REF;
        }
        return ReferenceType.SIMPLE_REF;
    }

    private static String stripLeadingAndTrailingPercents(String ref) {
        return StringUtils.removeEnd(StringUtils.removeStart(ref, "%"), "%");
    }

    private TransformationContext accept(TransformationContext ctx, Pair pair) {
        if (pair.getKey().equals("?")) {
            Vector<ArrayItem> objectIndex;
            if (pair.getValue() instanceof Array) {
                objectIndex = ((Array)pair.getValue()).getArrayItems();
            } else {
                ArrayItem value = (ArrayItem)((Object)pair.getValue());
                objectIndex = Vector.of(value);
            }
            return ctx.withObjectIndex(objectIndex);
        }
        return ctx;
    }

    public Condition apply(TransformationContext ctx, Condition condition) {
        Primitive newLhs = condition.getLhs();
        Operator op = condition.getOp();
        Vector<ValueItem> values = condition.getValues();
        String value = newLhs.toString();
        if (value != null) {
            if (value.contains("%")) {
                ValueItem applyResult = this.apply(ctx, newLhs);
                newLhs = applyResult instanceof StringPrimitive ? (StringPrimitive)applyResult : StringPrimitive.of(ctx.getAncestry(), condition, applyResult.toString());
            } else {
                Pair pair = this.findPairFromAncestry(ctx, condition, value);
                if (pair != null) {
                    newLhs = pair.getValue() instanceof StringPrimitive ? (StringPrimitive)pair.getValue() : StringPrimitive.of(ctx.getAncestry(), condition, pair.getValue().toString());
                }
            }
        }
        if (!condition.getLhs().equals(newLhs)) {
            return condition.with(ctx.getAncestry(), newLhs, op, values, condition.isShouldNegate());
        }
        return condition;
    }

    private Pair findPairFromAncestry(TransformationContext ctx, Child c, String key) {
        return ctx.getAncestry().findReferencedPair(ctx, c, key);
    }

    public ValueItem apply(TransformationContext ctx, ValueItem vi) {
        String s;
        if (vi instanceof StringPrimitive && (s = ((StringPrimitive)vi).getValue()) != null) {
            io.vavr.collection.Map<ReferenceType, Vector<String>> groupedByType = this.getReferenceGroups(s);
            ValueItem result = groupedByType.get(ReferenceType.OBJECT_INDEX_REF).map(i -> this.indexToReferencedObject(ctx, (Vector<String>)i)).map(this.replaceAllObjectIndexRefsInValueItem(ctx, vi)).getOrElse(vi);
            ValueItem finalResult = result = groupedByType.get(ReferenceType.SIMPLE_REF).map(k -> this.keyToReferencedObject(ctx, vi, (Vector<String>)k)).map(this.replaceAllSimpleRefsInValueItem(ctx, result)).getOrElse(result);
            result = groupedByType.get(ReferenceType.COMPLEX_REF).map(refList -> refList.map(cr -> this.complexRefToValueItem(ctx, vi, (String)cr))).map(tuples -> (Tuple2)tuples.get(0)).map(tuple -> {
                Pair pair = Pair.of(ctx.getAncestry(), vi, "", (PairValue)tuple._2);
                Vector<Tuple3<String, String, Option<Pair>>> vector = Vector.of(Tuple.of((String)tuple._1, (String)tuple._1, Option.of(pair)));
                return this.replaceAllSimpleRefsInValueItem(ctx, finalResult).apply(vector);
            }).getOrElse(result);
            return result;
        }
        return vi;
    }

    private Tuple2<String, ValueItem> complexRefToValueItem(TransformationContext ctx, ValueItem vi, String complexRef) {
        String ref = complexRef.startsWith("%`%") ? complexRef : ReferencesTransform.stripLeadingAndTrailingPercents(complexRef);
        String chainedMethods = StringUtils.substringAfter(ref, ".");
        String head = StringUtils.substringBefore(ref, ".");
        boolean wasQuoted = head.startsWith("`") && head.endsWith("`");
        String reference = Util.unquote(head);
        Vector<String> methods = Util.toMethodList(chainedMethods);
        String[] refList = (String[])methods.toJavaArray(String[]::new);
        Vector<Tuple3<String, String, Option<Pair>>> referencedObject = this.keyToReferencedObject(ctx, vi, Vector.of(reference));
        try {
            IndexedSeq valueItems = ((Vector)referencedObject.flatMap(t -> {
                if (wasQuoted) {
                    return Option.of(StringPrimitive.of(ctx.getAncestry(), vi, (String)t._2));
                }
                if (((Option)t._3).isDefined()) {
                    return (Iterable)t._3;
                }
                if (StringUtils.isNumeric((CharSequence)t._2)) {
                    return Option.of((ValueItem)((Object)ctx.getObjectIndex().get(Integer.parseInt((String)t._2))));
                }
                return Option.of(StringPrimitive.of(ctx.getAncestry(), vi, (String)t._2));
            })).map(pair -> this.followNestedRef(ctx, (ValueItem)pair, refList, 0));
            if (valueItems.size() == 1) {
                return Tuple.of(complexRef, (ValueItem)((Vector)valueItems).get(0));
            }
            if (valueItems.size() > 1) {
                throw new RuntimeException("Expected 1 ValueItem but found: " + valueItems.size());
            }
            throw new RuntimeException("Expected 1 ValueItem but found none. ");
        }
        catch (DeepReferenceException dre) {
            throw new RuntimeException("Invalid object reference: \"" + complexRef + "\"");
        }
    }

    private ValueItem followNestedRef(TransformationContext ctx, ValueItem vi, String[] refList, int refIndex) {
        int skipRefIndexesForPathElementsWithReferences;
        if (refIndex == refList.length) {
            return vi;
        }
        String ref = refList[refIndex];
        if (StringUtils.isNumeric(ref)) {
            return this.followNumericNestedRef(ctx, vi, refList, refIndex, ref);
        }
        if (vi instanceof Map) {
            return this.followMapNestedRef(ctx, vi, refList, refIndex, ref);
        }
        int n = skipRefIndexesForPathElementsWithReferences = ref.contains("%") ? refIndex + 1 : refIndex;
        if (vi instanceof Pair) {
            return this.followPairNestedRef(ctx, vi, refList, refIndex, ref, skipRefIndexesForPathElementsWithReferences);
        }
        if (vi instanceof StringPrimitive) {
            String valueStr = this.handleMethodsAndTrailingPathComponents(ctx, refList, skipRefIndexesForPathElementsWithReferences, vi.toString());
            return StringPrimitive.of(vi.getId(), valueStr);
        }
        return vi;
    }

    private ValueItem followPairNestedRef(TransformationContext ctx, ValueItem vi, String[] refList, int refIndex, String ref, int skipRefIndexesForPathElementsWithReferences) {
        PairValue value = ((Pair)vi).getValue();
        if (!(value instanceof Primitive)) {
            return this.followNestedRefIntoPrimitive(ctx, (Pair)vi, refList, refIndex, ref, (ValueItem)value);
        }
        if (refIndex == refList.length - 1 && ((Pair)vi).getKey().equals(ref)) {
            return (ValueItem)value;
        }
        String valueStr = this.handleMethodsAndTrailingPathComponents(ctx, refList, skipRefIndexesForPathElementsWithReferences, value.toString());
        if (!StringUtils.isNumeric(valueStr)) {
            return StringPrimitive.of(vi.getId(), valueStr);
        }
        return NumberPrimitive.of(vi.getId(), valueStr);
    }

    private ValueItem followMapNestedRef(TransformationContext ctx, ValueItem vi, String[] refList, int refIndex, String ref) {
        Option<MapItem> matchingMapItem = ((Map)vi).getMapItems().find(mapItem -> this.followNestedRefIntoMap(ctx, vi, ref, (MapItem)mapItem));
        if (matchingMapItem.isDefined()) {
            Pair matchingPair = (Pair)matchingMapItem.get();
            int newRef = ref.equals(matchingPair.getKey()) && refIndex + 1 < refList.length ? refIndex + 1 : refIndex;
            return this.followNestedRef(ctx, matchingPair, refList, newRef);
        }
        throw new DeepReferenceException("No entry '" + ref + "' in Map '" + vi + "'");
    }

    private ValueItem followNumericNestedRef(TransformationContext ctx, ValueItem vi, String[] refList, int refIndex, String ref) {
        int refNum = Integer.parseInt(ref);
        if (vi instanceof Array) {
            Array arr = (Array)vi;
            ValueItem valueItem = (ValueItem)((Object)arr.getArrayItems().get(refNum));
            return this.followNestedRef(ctx, valueItem, refList, refIndex + 1);
        }
        if (this.pairValueIsArray(vi)) {
            ValueItem valueItem = (ValueItem)((Object)((Array)((Pair)vi).getValue()).getArrayItems().get(refNum));
            return this.followNestedRef(ctx, valueItem, refList, refIndex + 1);
        }
        if (refIndex < refList.length - 1) {
            throw new DeepReferenceException("Invalid reference.");
        }
        throw new RuntimeException("Found a map when expecting an array");
    }

    private boolean pairValueIsArray(ValueItem vi) {
        return vi instanceof Pair && ((Pair)vi).getValue() instanceof Array;
    }

    private ValueItem followNestedRefIntoPrimitive(TransformationContext ctx, Pair vi, String[] refList, int refIndex, String ref, ValueItem value) {
        String unhiddenKey;
        String hiddenKey = ref.startsWith("_") ? ref : "_" + ref;
        String string = unhiddenKey = ref.startsWith("_") ? ref.substring(1) : ref;
        if (vi.getKey().equals(hiddenKey) || vi.getKey().equals(unhiddenKey)) {
            return this.followNestedRef(ctx, value, refList, refIndex + 1);
        }
        return this.followNestedRef(ctx, value, refList, refIndex);
    }

    private boolean followNestedRefIntoMap(TransformationContext ctx, ValueItem vi, String ref, MapItem mapItem) {
        if (ref.contains("%")) {
            String rawRef = ReferencesTransform.stripLeadingAndTrailingPercents(ref);
            Pair pair = this.findPairFromAncestry(ctx, vi, rawRef);
            if (pair != null) {
                String actualRef = pair.getValue().toString();
                return mapItem instanceof Pair && ((Pair)mapItem).getKey().equals(actualRef);
            }
            throw new DeepReferenceException("No entry '" + ref + "' in Map '" + vi + "'");
        }
        String hiddenKey = ref.startsWith("_") ? ref : "_" + ref;
        String unhiddenKey = ref.startsWith("_") ? ref.substring(1) : ref;
        return mapItem instanceof Pair && (((Pair)mapItem).getKey().equals(hiddenKey) || ((Pair)mapItem).getKey().equals(unhiddenKey));
    }

    private String handleMethodsAndTrailingPathComponents(TransformationContext ctx, String[] refList, int refIndex, String valueStr) {
        for (int i = refIndex; i < refList.length; ++i) {
            String updated;
            String pathComponent = refList[i];
            if (pathComponent.length() == 1) {
                switch (pathComponent) {
                    case "p": {
                        valueStr = Util.replacePunycode(Util.unquote(valueStr));
                        break;
                    }
                    case "u": {
                        valueStr = Util.unquote(valueStr).toUpperCase();
                        break;
                    }
                    case "d": {
                        valueStr = Util.unquote(valueStr).toLowerCase();
                        break;
                    }
                    case "i": {
                        valueStr = WordUtils.capitalize(Util.unquote(valueStr));
                        break;
                    }
                    case "s": {
                        valueStr = StringUtils.capitalize(Util.unquote(valueStr));
                        break;
                    }
                    case "e": {
                        try {
                            valueStr = URLEncoder.encode(valueStr, StandardCharsets.UTF_8.toString());
                            break;
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Error processing URL encoding instruction: " + e.getMessage());
                        }
                    }
                }
                continue;
            }
            valueStr = pathComponent.startsWith("r<") || pathComponent.startsWith("replace<") ? Util.replacer(pathComponent, valueStr) : (pathComponent.startsWith("t<") || pathComponent.startsWith("trim<") ? Util.trimmer(pathComponent, valueStr) : ((updated = this.methodsTransform.apply(ctx, pathComponent, valueStr)).equals(valueStr) ? valueStr + "." + pathComponent : updated));
        }
        return valueStr;
    }

    public Tuple2<TransformationContext, Structure> apply(TransformationContext ctx, Structure p) {
        Vector<Parent> items;
        if (p == null) {
            return Tuple.of(ctx, null);
        }
        TransformationContext newCtx = ctx;
        if (p instanceof Pair) {
            Pair pair = (Pair)p;
            if (pair.getValue() instanceof ValueConditional) {
                return Tuple.of(ctx, p);
            }
            if (!pair.getValue().toString().startsWith("%*")) {
                Tuple2<TransformationContext, Pair> resolved = this.resolve(newCtx, pair);
                newCtx = (TransformationContext)resolved._1;
                newCtx.getAncestry().replaceChild(((Pair)p).getValue(), ((Pair)resolved._2).getValue());
                newCtx = this.accept(newCtx, (Pair)resolved._2);
                Pair transformedPair = (Pair)resolved._2;
                return Tuple.of(newCtx, transformedPair);
            }
        }
        if (p instanceof Array) {
            items = ((Array)p).getArrayItems();
            IndexedSeq<ArrayItem> newItems = Vector.empty();
            for (ArrayItem arrayItem : items) {
                Object applyResult;
                if (arrayItem instanceof Structure) {
                    applyResult = this.apply(ctx, (Structure)((Object)arrayItem));
                    newItems = newItems.append((Object)((ArrayItem)((Tuple2)applyResult)._2));
                    newCtx = (TransformationContext)((Tuple2)applyResult)._1;
                    continue;
                }
                applyResult = this.apply(ctx, (ValueItem)((Object)arrayItem));
                newItems = newItems.append((Object)((ArrayItem)applyResult));
            }
            return Tuple.of(newCtx, ((Array)p).with(ctx.getAncestry(), (Vector<ArrayItem>)newItems));
        }
        if (p instanceof Map) {
            items = ((Map)p).getMapItems();
            IndexedSeq<MapItem> newItems = Vector.empty();
            for (MapItem mapItem : items) {
                Object applyResult;
                if (mapItem instanceof Structure) {
                    applyResult = this.apply(newCtx, (Structure)((Object)mapItem));
                    newItems = newItems.append((Object)((MapItem)((Tuple2)applyResult)._2));
                    newCtx = (TransformationContext)((Tuple2)applyResult)._1;
                    continue;
                }
                applyResult = this.apply(ctx, (ValueItem)((Object)mapItem));
                newItems = newItems.append((Object)((MapItem)applyResult));
            }
            return Tuple.of(newCtx, ((Map)p).with(ctx.getAncestry(), (Vector<MapItem>)newItems));
        }
        return Tuple.of(ctx, p);
    }

    private Tuple2<TransformationContext, Pair> resolve(TransformationContext ctx, Pair p) {
        TransformationContext newCtx = ctx;
        if (p.getValue() instanceof StringPrimitive) {
            io.vavr.collection.Map<ReferenceType, Vector<String>> groupedByType = this.getReferenceGroups(p.getValue().toString());
            Pair result = groupedByType.get(ReferenceType.OBJECT_INDEX_REF).map(i -> this.indexToReferencedObject(ctx, (Vector<String>)i)).map(this.replaceAllObjectIndexRefs(ctx, p)).getOrElse(p);
            Pair finalResult = result = groupedByType.get(ReferenceType.SIMPLE_REF).map(k -> this.keyToReferencedObject(ctx, p, (Vector<String>)k)).map(this.replaceAllSimpleRefs(ctx, result)).getOrElse(result);
            result = groupedByType.get(ReferenceType.COMPLEX_REF).map(refList -> this.complexRefToReferencedItems(ctx, finalResult, (Vector<String>)refList)).map(this.replaceAllSimpleRefs(ctx, result)).getOrElse(result);
            return Tuple.of(newCtx, result);
        }
        if (p.getValue() instanceof Map) {
            @NonNull Vector<MapItem> items = ((Map)p.getValue()).getMapItems();
            IndexedSeq<MapItem> newItems = Vector.empty();
            for (MapItem item : items) {
                if (item instanceof Structure) {
                    Tuple2<TransformationContext, Structure> applyResult = this.apply(newCtx, (Structure)((Object)item));
                    newItems = ((Vector)newItems).append((MapItem)applyResult._2);
                    newCtx = (TransformationContext)applyResult._1;
                    continue;
                }
                newItems = ((Vector)newItems).append(item);
            }
            return Tuple.of(newCtx, p.with(ctx.getAncestry(), ((Map)p.getValue()).with(ctx.getAncestry(), (Vector<MapItem>)newItems)));
        }
        if (p.getValue() instanceof Array) {
            @NonNull Vector<ArrayItem> items = ((Array)p.getValue()).getArrayItems();
            IndexedSeq<ArrayItem> newItems = Vector.empty();
            for (ArrayItem item : items) {
                if (item instanceof Structure) {
                    Tuple2<TransformationContext, Structure> applyResult = this.apply(ctx, (Structure)((Object)item));
                    newItems = ((Vector)newItems).append((ArrayItem)applyResult._2);
                    newCtx = (TransformationContext)applyResult._1;
                    continue;
                }
                newItems = ((Vector)newItems).append(item);
            }
            return Tuple.of(newCtx, p.with(ctx.getAncestry(), ((Array)p.getValue()).with(ctx.getAncestry(), (Vector<ArrayItem>)newItems)));
        }
        return Tuple.of(newCtx, p);
    }

    private Vector<Tuple3<String, String, Option<Pair>>> complexRefToReferencedItems(TransformationContext ctx, Pair p, Vector<String> refList) {
        return refList.map(ref -> {
            Tuple2<String, ValueItem> result = this.complexRefToValueItem(ctx, p, (String)ref);
            return Tuple.of(ref, p.getKey(), Option.of(p.with(ctx.getAncestry(), (PairValue)result._2)));
        });
    }

    private io.vavr.collection.Map<ReferenceType, Vector<String>> getReferenceGroups(String stringWithRefs) {
        Matcher matcher = referencePattern.matcher(stringWithRefs);
        IndexedSeq<String> groups = Vector.empty();
        while (matcher.find()) {
            groups = groups.append((Object)matcher.group());
        }
        return groups.groupBy(ReferencesTransform::refToRefType);
    }

    private Function<Vector<Tuple4<String, String, Integer, Option<ArrayItem>>>, Pair> replaceAllObjectIndexRefs(TransformationContext ctx, Pair p) {
        return refTuples -> refTuples.foldLeft(p, this.replaceObjectIndexRefInArrayItem(ctx));
    }

    private Function<Vector<Tuple4<String, String, Integer, Option<ArrayItem>>>, ValueItem> replaceAllObjectIndexRefsInValueItem(TransformationContext ctx, ValueItem vi) {
        return refTuples -> refTuples.foldLeft(vi, this.replaceObjectIndexRefInValueItem(ctx));
    }

    private Function<Vector<Tuple3<String, String, Option<Pair>>>, Pair> replaceAllSimpleRefs(TransformationContext ctx, Pair p) {
        return refTuples -> refTuples.foldLeft(p, this.replaceSimpleRefInPair(ctx));
    }

    private Function<Vector<Tuple3<String, String, Option<Pair>>>, ValueItem> replaceAllSimpleRefsInValueItem(TransformationContext ctx, ValueItem vi) {
        return refTuples -> refTuples.foldLeft(vi, this.replaceSimpleRefInValueItem(ctx));
    }

    private Vector<Tuple4<String, String, Integer, Option<ArrayItem>>> indexToReferencedObject(TransformationContext ctx, Vector<String> list) {
        return ((Vector)((Vector)list.map(s -> Tuple.of(s, ReferencesTransform.stripLeadingAndTrailingPercents(s)))).map(t -> t.append(Integer.parseInt((String)t._2)))).map(t -> {
            if ((Integer)t._3 >= 0 && (Integer)t._3 < ctx.getObjectIndex().size()) {
                return t.append(Option.of(ctx.getObjectIndex().get((Integer)t._3)));
            }
            return t.append(Option.none());
        });
    }

    private Vector<Tuple3<String, String, Option<Pair>>> keyToReferencedObject(TransformationContext ctx, ValueItem vi, Vector<String> list) {
        return ((Vector)list.map(s -> Tuple.of(s, ReferencesTransform.stripLeadingAndTrailingPercents(s)))).map(t -> {
            String hiddenKey = ((String)t._2).startsWith("_") ? (String)t._2 : "_" + (String)t._2;
            String unhiddenKey = ((String)t._2).startsWith("_") ? ((String)t._2).substring(1) : (String)t._2;
            Pair transformedPair = ctx.getAncestry().findByKey(vi, hiddenKey).orElse(() -> ctx.getAncestry().findByKey(vi, unhiddenKey)).getOrElse((Pair)null);
            Option<Pair> pair = Option.of(transformedPair);
            return t.append(pair);
        });
    }

    private BiFunction<Pair, Tuple4<String, String, Integer, Option<ArrayItem>>, Pair> replaceObjectIndexRefInArrayItem(TransformationContext ctx) {
        return (curr, next) -> {
            if (((Option)next._4).isDefined()) {
                if (((Option)next._4).get() instanceof StringPrimitive) {
                    String s = ((StringPrimitive)curr.getValue()).getValue();
                    String r = ctx.getObjectIndex().get((Integer)next._3).toString();
                    String indexReference = (String)next._1;
                    String tmpResult = s;
                    if (!indexReference.endsWith("%")) {
                        tmpResult = s.replace(indexReference + "%", r);
                    }
                    return curr.with(ctx.getAncestry(), StringPrimitive.of(ctx.getAncestry(), curr, tmpResult.replace(indexReference, r)));
                }
                return curr.with(ctx.getAncestry(), (PairValue)((Object)ctx.getObjectIndex().get((Integer)next._3)));
            }
            return curr;
        };
    }

    private BiFunction<ValueItem, Tuple4<String, String, Integer, Option<ArrayItem>>, ValueItem> replaceObjectIndexRefInValueItem(TransformationContext ctx) {
        return (curr, next) -> {
            if (((Option)next._4).isDefined() && (((Option)next._4).get() instanceof NumberPrimitive || ((Option)next._4).get() instanceof StringPrimitive) && curr instanceof StringPrimitive) {
                String s;
                String r = ctx.getObjectIndex().get((Integer)next._3).toString();
                String indexReference = (String)next._1;
                String tmpResult = s = ((StringPrimitive)curr).getValue();
                if (!indexReference.endsWith("%")) {
                    tmpResult = s.replace(indexReference + "%", r);
                }
                return ((StringPrimitive)curr).with(ctx.getAncestry(), tmpResult.replace((CharSequence)next._1, r));
            }
            return curr;
        };
    }

    private BiFunction<Pair, Tuple3<String, String, Option<Pair>>, Pair> replaceSimpleRefInPair(TransformationContext ctx) {
        return (curr, next) -> {
            if (((Option)next._3).isDefined()) {
                Pair p = (Pair)((Option)next._3).get();
                @NonNull PairValue pairValue = p.getValue();
                if (curr.getValue() instanceof StringPrimitive) {
                    String s = ((StringPrimitive)curr.getValue()).getValue();
                    if (pairValue instanceof StringPrimitive) {
                        String r = ((StringPrimitive)pairValue).getValue();
                        return curr.with(ctx.getAncestry(), StringPrimitive.of(ctx.getAncestry(), curr, s.replace((CharSequence)next._1, r)));
                    }
                    if (pairValue instanceof NumberPrimitive) {
                        String r = ((NumberPrimitive)pairValue).getValue();
                        if (s.equals(next._1)) {
                            return curr.with(ctx.getAncestry(), NumberPrimitive.of(ctx.getAncestry(), curr, s.replace((CharSequence)next._1, r)));
                        }
                        return curr.with(ctx.getAncestry(), StringPrimitive.of(ctx.getAncestry(), curr, s.replace((CharSequence)next._1, r)));
                    }
                    if (pairValue instanceof TruePrimitive) {
                        String r = "true";
                        if (s.equals(next._1)) {
                            return curr.with(ctx.getAncestry(), TruePrimitive.instance);
                        }
                        return curr.with(ctx.getAncestry(), StringPrimitive.of(ctx.getAncestry(), curr, s.replace((CharSequence)next._1, "true")));
                    }
                    if (pairValue instanceof FalsePrimitive) {
                        String r = "false";
                        if (s.equals(next._1)) {
                            return curr.with(ctx.getAncestry(), FalsePrimitive.instance);
                        }
                        return curr.with(ctx.getAncestry(), StringPrimitive.of(ctx.getAncestry(), curr, s.replace((CharSequence)next._1, "false")));
                    }
                    if (pairValue instanceof NullPrimitive) {
                        String r = "null";
                        if (s.equals(next._1)) {
                            return curr.with(ctx.getAncestry(), NullPrimitive.instance);
                        }
                        return curr.with(ctx.getAncestry(), StringPrimitive.of(ctx.getAncestry(), curr, s.replace((CharSequence)next._1, "null")));
                    }
                    if (!s.equals(next._1)) {
                        throw new InterpreterError("Interpreter Error: Cannot embed object in a primitive value.");
                    }
                }
                return curr.with(ctx.getAncestry(), pairValue);
            }
            return curr;
        };
    }

    private BiFunction<ValueItem, Tuple3<String, String, Option<Pair>>, ValueItem> replaceSimpleRefInValueItem(TransformationContext ctx) {
        return (curr, next) -> {
            if (((Option)next._3).isDefined()) {
                if (((Pair)((Option)next._3).get()).getValue() instanceof StringPrimitive && curr instanceof StringPrimitive) {
                    String r = ((StringPrimitive)((Pair)((Option)next._3).get()).getValue()).getValue();
                    return ((StringPrimitive)curr).with(ctx.getAncestry(), ((StringPrimitive)curr).getValue().replace((CharSequence)next._1, r));
                }
                return (ValueItem)((Pair)((Option)next._3).get()).getValue();
            }
            return curr;
        };
    }

    private static enum ReferenceType {
        COMPLEX_REF,
        OBJECT_INDEX_REF,
        LITERAL_REF,
        SIMPLE_REF;

    }
}

