/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class Section
extends ExpandableComposite {
    public static final int DESCRIPTION = 128;
    private Label descriptionLabel;
    private Control separator;

    public Section(Composite parent, int style) {
        super(parent, 0, style);
        if ((style & 0x80) != 0) {
            this.descriptionLabel = new Label((Composite)this, 64);
        }
    }

    protected void internalSetExpanded(boolean expanded) {
        super.internalSetExpanded(expanded);
        this.reflow();
    }

    protected void reflow() {
        Section c = this;
        while (c != null) {
            c.setRedraw(false);
            c = c.getParent();
            if (c instanceof ScrolledForm) break;
        }
        for (c = this; c != null; c = c.getParent()) {
            c.layout(true);
            if (!(c instanceof ScrolledForm)) continue;
            ((ScrolledForm)((Object)c)).reflow(true);
            break;
        }
        c = this;
        while (c != null) {
            c.setRedraw(true);
            c = c.getParent();
            if (c instanceof ScrolledForm) break;
        }
    }

    public void setDescription(String description) {
        if (this.descriptionLabel != null) {
            this.descriptionLabel.setText(description);
        }
    }

    public String getDescription() {
        if (this.descriptionLabel != null) {
            return this.descriptionLabel.getText();
        }
        return null;
    }

    public void setSeparatorControl(Control separator) {
        Assert.isTrue((separator != null && separator.getParent().equals((Object)this) ? 1 : 0) != 0);
        this.separator = separator;
    }

    public Control getSeparatorControl() {
        return this.separator;
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.descriptionLabel != null) {
            this.descriptionLabel.setBackground(bg);
        }
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.descriptionLabel != null) {
            this.descriptionLabel.setForeground(fg);
        }
    }

    protected Control getDescriptionControl() {
        return this.descriptionLabel;
    }
}

