/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.internal.widgets;

import java.text.BreakIterator;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.forms.internal.widgets.Locator;
import org.eclipse.ui.forms.internal.widgets.ParagraphSegment;

public class TextSegment
extends ParagraphSegment {
    private String colorId;
    private String fontId;
    private String text;
    protected boolean underline;
    private boolean wrapAllowed = true;
    protected Vector areaRectangles = new Vector();

    public TextSegment(String text, String fontId) {
        this(text, fontId, null);
    }

    public TextSegment(String text, String fontId, String colorId) {
        this.text = this.cleanup(text);
        this.fontId = fontId;
        this.colorId = colorId;
    }

    private String cleanup(String text) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '\n' || c == '\r' || c == '\f') {
                if (i > 0) {
                    buf.append(' ');
                }
            } else {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    public void setWordWrapAllowed(boolean value) {
        this.wrapAllowed = value;
    }

    public boolean isWordWrapAllowed() {
        return this.wrapAllowed;
    }

    public boolean isSelectable() {
        return false;
    }

    public String getColorId() {
        return this.colorId;
    }

    public String getText() {
        return this.text;
    }

    void setText(String text) {
        this.text = this.cleanup(text);
    }

    void setColorId(String colorId) {
        this.colorId = colorId;
    }

    void setFontId(String fontId) {
        this.fontId = fontId;
    }

    public boolean contains(int x, int y) {
        int i = 0;
        while (i < this.areaRectangles.size()) {
            AreaRectangle ar = (AreaRectangle)this.areaRectangles.get(i);
            if (ar.contains(x, y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Rectangle getBounds() {
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < this.areaRectangles.size()) {
            AreaRectangle ar = (AreaRectangle)this.areaRectangles.get(i);
            if (i == 0) {
                x = ar.rect.x;
                y = ar.rect.y;
            } else {
                x = Math.min(ar.rect.x, x);
            }
            width = Math.max(ar.rect.width, width);
            height += ar.rect.height;
            ++i;
        }
        return new Rectangle(x, y, width, height);
    }

    public boolean advanceLocator(GC gc, int wHint, Locator locator, Hashtable objectTable, boolean computeHeightOnly) {
        Font oldFont = null;
        if (this.fontId != null) {
            oldFont = gc.getFont();
            Font newFont = (Font)objectTable.get(this.fontId);
            if (newFont != null) {
                gc.setFont(newFont);
            }
        }
        FontMetrics fm = gc.getFontMetrics();
        int lineHeight = fm.getHeight();
        boolean newLine = false;
        if (wHint == -1 || !this.wrapAllowed) {
            Point extent = gc.textExtent(this.text);
            if (wHint != -1 && locator.x + extent.x > wHint) {
                locator.x = this.isSelectable() ? locator.indent + 1 : locator.indent;
                locator.y += locator.rowHeight;
                if (computeHeightOnly) {
                    locator.collectHeights(true);
                }
                locator.rowHeight = 0;
                locator.leading = 0;
                newLine = true;
            }
            int width = extent.x;
            if (this.isSelectable()) {
                width += 2;
            }
            locator.x += width;
            locator.width = width;
            locator.height = extent.y;
            locator.rowHeight = Math.max(locator.rowHeight, extent.y);
            locator.leading = Math.max(locator.leading, fm.getLeading());
            return newLine;
        }
        BreakIterator wb = BreakIterator.getLineInstance();
        wb.setText(this.text);
        int saved = 0;
        int last = 0;
        int width = 0;
        Point lastExtent = null;
        int loc = wb.first();
        while (loc != -1) {
            String word = this.text.substring(saved, loc);
            Point extent = gc.textExtent(word);
            if (locator.x + extent.x > wHint) {
                String savedWord = this.text.substring(saved, last);
                if (lastExtent == null) {
                    lastExtent = gc.textExtent(savedWord);
                }
                int lineWidth = locator.x + lastExtent.x;
                if (this.isSelectable()) {
                    lineWidth += 2;
                }
                saved = last;
                locator.rowHeight = Math.max(locator.rowHeight, lastExtent.y);
                locator.leading = Math.max(locator.leading, fm.getLeading());
                if (computeHeightOnly) {
                    locator.collectHeights(true);
                }
                locator.x = this.isSelectable() ? locator.indent + 1 : locator.indent;
                locator.y += locator.rowHeight;
                locator.rowHeight = 0;
                locator.leading = 0;
                width = Math.max(width, lineWidth);
                newLine = true;
            }
            last = loc;
            lastExtent = extent;
            loc = wb.next();
        }
        String lastString = this.text.substring(saved, last);
        Point extent = gc.textExtent(lastString);
        int lineWidth = extent.x;
        if (this.isSelectable()) {
            lineWidth += 2;
        }
        locator.x += lineWidth;
        locator.width = width;
        locator.height = lineHeight;
        locator.rowHeight = Math.max(locator.rowHeight, extent.y);
        locator.leading = Math.max(locator.leading, fm.getLeading());
        if (oldFont != null) {
            gc.setFont(oldFont);
        }
        return newLine;
    }

    public void paint(GC gc, int width, Locator locator, Hashtable resourceTable, boolean selected) {
        Font oldFont = null;
        Color oldColor = null;
        this.areaRectangles.clear();
        if (this.fontId != null) {
            oldFont = gc.getFont();
            Font newFont = (Font)resourceTable.get(this.fontId);
            if (newFont != null) {
                gc.setFont(newFont);
            }
        }
        if (this.colorId != null) {
            oldColor = gc.getForeground();
            Color newColor = (Color)resourceTable.get(this.colorId);
            if (newColor != null) {
                gc.setForeground(newColor);
            }
        }
        FontMetrics fm = gc.getFontMetrics();
        int lineHeight = fm.getHeight();
        int descent = fm.getDescent();
        if (!this.wrapAllowed) {
            Point extent = gc.textExtent(this.text);
            int ewidth = extent.x;
            if (this.isSelectable()) {
                ewidth += 2;
            }
            if (locator.x + ewidth > width) {
                locator.resetCaret();
                if (this.isSelectable()) {
                    ++locator.x;
                }
                locator.y += locator.rowHeight;
                locator.rowHeight = 0;
                ++locator.rowCounter;
            }
            int ly = locator.getBaseline(fm.getHeight() - fm.getLeading());
            gc.drawString(this.text, locator.x, ly);
            if (this.underline) {
                int lineY = ly + lineHeight - descent + 1;
                gc.drawLine(locator.x, lineY, locator.x + extent.x, lineY);
            }
            Rectangle br = new Rectangle(locator.x - 1, ly, extent.x + 2, lineHeight - descent + 3);
            this.areaRectangles.add(new AreaRectangle(br, 0, -1));
            if (selected) {
                if (this.colorId != null) {
                    gc.setForeground(oldColor);
                }
                gc.drawFocus(br.x, br.y, br.width, br.height);
            }
            locator.x += ewidth;
            locator.width = ewidth;
            locator.height = lineHeight;
            locator.rowHeight = Math.max(locator.rowHeight, extent.y);
            if (oldFont != null) {
                gc.setFont(oldFont);
            }
            if (oldColor != null) {
                gc.setForeground(oldColor);
            }
            return;
        }
        BreakIterator wb = BreakIterator.getLineInstance();
        wb.setText(this.text);
        int saved = 0;
        int last = 0;
        int loc = wb.first();
        while (loc != -1) {
            if (loc != 0) {
                String word = this.text.substring(saved, loc);
                Point extent = gc.textExtent(word);
                int ewidth = extent.x;
                if (this.isSelectable()) {
                    ewidth += 2;
                }
                if (locator.x + ewidth > width) {
                    String prevLine = this.text.substring(saved, last);
                    int ly = locator.getBaseline(lineHeight - fm.getLeading());
                    gc.drawString(prevLine, locator.x, ly, true);
                    Point prevExtent = gc.textExtent(prevLine);
                    int prevWidth = prevExtent.x;
                    if (this.isSelectable()) {
                        prevWidth += 2;
                    }
                    if (this.underline) {
                        int lineY = ly + lineHeight - descent + 1;
                        gc.drawLine(locator.x, lineY, locator.x + prevWidth, lineY);
                    }
                    Rectangle br = new Rectangle(locator.x - 1, ly, prevExtent.x + 2, lineHeight - descent + 3);
                    if (selected) {
                        if (this.colorId != null) {
                            gc.setForeground(oldColor);
                        }
                        gc.drawFocus(br.x, br.y, br.width, br.height);
                        Color newColor = (Color)resourceTable.get(this.colorId);
                        if (newColor != null) {
                            gc.setForeground(newColor);
                        }
                    }
                    this.areaRectangles.add(new AreaRectangle(br, saved, last));
                    locator.rowHeight = Math.max(locator.rowHeight, prevExtent.y);
                    locator.resetCaret();
                    if (this.isSelectable()) {
                        ++locator.x;
                    }
                    locator.y += locator.rowHeight;
                    ++locator.rowCounter;
                    locator.rowHeight = 0;
                    saved = last;
                }
                last = loc;
            }
            loc = wb.next();
        }
        String lastLine = this.text.substring(saved, last);
        int ly = locator.getBaseline(lineHeight - fm.getLeading());
        gc.drawString(lastLine, locator.x, ly, true);
        Point lastExtent = gc.textExtent(lastLine);
        int lastWidth = lastExtent.x;
        if (this.isSelectable()) {
            lastWidth += 2;
        }
        Rectangle br = new Rectangle(locator.x - 1, ly, lastExtent.x + 2, lineHeight - descent + 3);
        this.areaRectangles.add(new AreaRectangle(br, saved, last));
        if (this.underline) {
            int lineY = ly + lineHeight - descent + 1;
            gc.drawLine(locator.x, lineY, locator.x + lastExtent.x, lineY);
        }
        if (selected) {
            if (this.colorId != null) {
                gc.setForeground(oldColor);
            }
            gc.drawFocus(br.x, br.y, br.width, br.height);
        }
        locator.x += lastWidth;
        locator.rowHeight = Math.max(locator.rowHeight, lastExtent.y);
        if (oldFont != null) {
            gc.setFont(oldFont);
        }
        if (oldColor != null) {
            gc.setForeground(oldColor);
        }
    }

    public void paintFocus(GC gc, Color bg, Color fg, boolean selected) {
        if (this.areaRectangles == null) {
            return;
        }
        int i = 0;
        while (i < this.areaRectangles.size()) {
            AreaRectangle areaRectangle = (AreaRectangle)this.areaRectangles.get(i);
            Rectangle br = areaRectangle.rect;
            if (selected) {
                gc.setBackground(bg);
                gc.setForeground(fg);
                gc.drawFocus(br.x, br.y, br.width, br.height);
            } else {
                gc.setForeground(bg);
                gc.drawRectangle(br.x, br.y, br.width - 1, br.height - 1);
            }
            ++i;
        }
    }

    class AreaRectangle {
        Rectangle rect;
        int from;
        int to;

        public AreaRectangle(Rectangle rect, int from, int to) {
            this.rect = rect;
            this.from = from;
            this.to = to;
        }

        public boolean contains(int x, int y) {
            return this.rect.contains(x, y);
        }

        public String getText() {
            if (this.from == 0 && this.to == -1) {
                return TextSegment.this.getText();
            }
            if (this.from > 0 && this.to == -1) {
                return TextSegment.this.getText().substring(this.from);
            }
            return TextSegment.this.getText().substring(this.from, this.to);
        }
    }
}

