/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class EncodedResource {
    private final Resource resource;
    private final String encoding;

    public EncodedResource(Resource resource) {
        this(resource, null);
    }

    public EncodedResource(Resource resource, String encoding) {
        Assert.notNull("Resource is required");
        this.resource = resource;
        this.encoding = encoding;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Reader getReader() throws IOException {
        if (this.encoding != null) {
            return new InputStreamReader(this.resource.getInputStream(), this.encoding);
        }
        return new InputStreamReader(this.resource.getInputStream());
    }
}

