/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo;

import javax.jdo.PersistenceManager;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.orm.jdo.JdoAccessor;
import org.springframework.orm.jdo.PersistenceManagerFactoryUtils;
import org.springframework.orm.jdo.PersistenceManagerHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class JdoInterceptor
extends JdoAccessor
implements MethodInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        boolean existingTransaction = false;
        PersistenceManager pm = PersistenceManagerFactoryUtils.getPersistenceManager(this.getPersistenceManagerFactory(), true);
        if (TransactionSynchronizationManager.hasResource(this.getPersistenceManagerFactory())) {
            this.logger.debug((Object)"Found thread-bound PersistenceManager for JDO interceptor");
            existingTransaction = true;
        } else {
            this.logger.debug((Object)"Using new PersistenceManager for JDO interceptor");
            TransactionSynchronizationManager.bindResource(this.getPersistenceManagerFactory(), new PersistenceManagerHolder(pm));
        }
        try {
            Object retVal = methodInvocation.proceed();
            this.flushIfNecessary(pm, existingTransaction);
            Object object = retVal;
            return object;
        }
        finally {
            if (existingTransaction) {
                this.logger.debug((Object)"Not closing pre-bound JDO PersistenceManager after interceptor");
            } else {
                TransactionSynchronizationManager.unbindResource(this.getPersistenceManagerFactory());
                PersistenceManagerFactoryUtils.closePersistenceManagerIfNecessary(pm, this.getPersistenceManagerFactory());
            }
        }
    }
}

