/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jca.cci.core.support;

import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jca.cci.CannotGetCciConnectionException;
import org.springframework.jca.cci.connection.ConnectionFactoryUtils;
import org.springframework.jca.cci.core.CciTemplate;

public abstract class CciDaoSupport
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private CciTemplate cciTemplate;

    public final void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.cciTemplate = this.createCciTemplate(connectionFactory);
    }

    protected CciTemplate createCciTemplate(ConnectionFactory connectionFactory) {
        return new CciTemplate(connectionFactory);
    }

    public final ConnectionFactory getConnectionFactory() {
        return this.cciTemplate.getConnectionFactory();
    }

    public final void setCciTemplate(CciTemplate cciTemplate) {
        this.cciTemplate = cciTemplate;
    }

    public final CciTemplate getCciTemplate() {
        return this.cciTemplate;
    }

    public final void afterPropertiesSet() throws Exception {
        if (this.cciTemplate == null) {
            throw new IllegalArgumentException("connectionFactory or cciTemplate is required");
        }
        this.initDao();
    }

    protected void initDao() throws Exception {
    }

    protected final Connection getConnection() throws CannotGetCciConnectionException {
        return ConnectionFactoryUtils.getConnection(this.getConnectionFactory());
    }

    protected final void closeConnectionIfNecessary(Connection con) {
        ConnectionFactoryUtils.closeConnectionIfNecessary(con, this.getConnectionFactory());
    }
}

