/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jca.cci.connection;

import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jca.cci.CannotGetCciConnectionException;
import org.springframework.jca.cci.connection.ConnectionHolder;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class ConnectionFactoryUtils {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$jca$cci$connection$ConnectionFactoryUtils == null ? (class$org$springframework$jca$cci$connection$ConnectionFactoryUtils = ConnectionFactoryUtils.class$("org.springframework.jca.cci.connection.ConnectionFactoryUtils")) : class$org$springframework$jca$cci$connection$ConnectionFactoryUtils));
    static /* synthetic */ Class class$org$springframework$jca$cci$connection$ConnectionFactoryUtils;

    public static Connection getConnection(ConnectionFactory cf) throws CannotGetCciConnectionException {
        return ConnectionFactoryUtils.getConnection(cf, true);
    }

    public static Connection getConnection(ConnectionFactory cf, boolean allowSynchronization) throws CannotGetCciConnectionException {
        try {
            return ConnectionFactoryUtils.doGetConnection(cf, allowSynchronization);
        }
        catch (ResourceException ex) {
            throw new CannotGetCciConnectionException("Could not get CCI connection", ex);
        }
    }

    public static Connection doGetConnection(ConnectionFactory cf) throws ResourceException {
        return ConnectionFactoryUtils.doGetConnection(cf, true);
    }

    public static Connection doGetConnection(ConnectionFactory cf, boolean allowSynchronization) throws ResourceException {
        ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource(cf);
        if (conHolder != null) {
            return conHolder.getConnection();
        }
        Connection con = cf.getConnection();
        if (allowSynchronization && TransactionSynchronizationManager.isSynchronizationActive()) {
            logger.debug((Object)"Registering transaction synchronization for CCI connection");
            conHolder = new ConnectionHolder(con);
            TransactionSynchronizationManager.bindResource(cf, conHolder);
            TransactionSynchronizationManager.registerSynchronization(new ConnectionSynchronization(conHolder, cf));
        }
        return con;
    }

    public static void closeConnectionIfNecessary(Connection con, ConnectionFactory cf) {
        try {
            ConnectionFactoryUtils.doCloseConnectionIfNecessary(con, cf);
        }
        catch (ResourceException ex) {
            logger.error((Object)"Could not close CCI connection", (Throwable)ex);
        }
    }

    public static void doCloseConnectionIfNecessary(Connection con, ConnectionFactory cf) throws ResourceException {
        if (con == null || TransactionSynchronizationManager.hasResource(cf)) {
            return;
        }
        con.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ConnectionSynchronization
    extends TransactionSynchronizationAdapter {
        private final ConnectionHolder connectionHolder;
        private final ConnectionFactory connectionFactory;

        public ConnectionSynchronization(ConnectionHolder connectionHolder, ConnectionFactory connectionFactory) {
            this.connectionHolder = connectionHolder;
            this.connectionFactory = connectionFactory;
        }

        public void suspend() {
            TransactionSynchronizationManager.unbindResource(this.connectionFactory);
        }

        public void resume() {
            TransactionSynchronizationManager.bindResource(this.connectionFactory, this.connectionHolder);
        }

        public void beforeCompletion() {
            TransactionSynchronizationManager.unbindResource(this.connectionFactory);
            ConnectionFactoryUtils.closeConnectionIfNecessary(this.connectionHolder.getConnection(), this.connectionFactory);
        }
    }
}

