/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeansDtdResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionParser;
import org.springframework.core.io.Resource;
import org.springframework.util.xml.SimpleSaxErrorHandler;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlBeanDefinitionReader
extends AbstractBeanDefinitionReader {
    private boolean validating = true;
    private ErrorHandler errorHandler = new SimpleSaxErrorHandler(this.logger);
    private EntityResolver entityResolver = new BeansDtdResolver();
    private Class parserClass = class$org$springframework$beans$factory$xml$DefaultXmlBeanDefinitionParser == null ? (class$org$springframework$beans$factory$xml$DefaultXmlBeanDefinitionParser = XmlBeanDefinitionReader.class$("org.springframework.beans.factory.xml.DefaultXmlBeanDefinitionParser")) : class$org$springframework$beans$factory$xml$DefaultXmlBeanDefinitionParser;
    static /* synthetic */ Class class$org$springframework$beans$factory$xml$DefaultXmlBeanDefinitionParser;
    static /* synthetic */ Class class$org$springframework$beans$factory$xml$XmlBeanDefinitionParser;

    public XmlBeanDefinitionReader(BeanDefinitionRegistry beanFactory) {
        super(beanFactory);
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setParserClass(Class parserClass) {
        if (this.parserClass == null || !(class$org$springframework$beans$factory$xml$XmlBeanDefinitionParser == null ? (class$org$springframework$beans$factory$xml$XmlBeanDefinitionParser = XmlBeanDefinitionReader.class$("org.springframework.beans.factory.xml.XmlBeanDefinitionParser")) : class$org$springframework$beans$factory$xml$XmlBeanDefinitionParser).isAssignableFrom(parserClass)) {
            throw new IllegalArgumentException("parserClass must be an XmlBeanDefinitionParser");
        }
        this.parserClass = parserClass;
    }

    public int loadBeanDefinitions(Resource resource) throws BeansException {
        if (resource == null) {
            throw new BeanDefinitionStoreException("resource cannot be null: expected an XML file");
        }
        InputStream is = null;
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Loading XML bean definitions from " + resource + ""));
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using JAXP implementation [" + factory + "]"));
            }
            factory.setValidating(this.validating);
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            docBuilder.setErrorHandler(this.errorHandler);
            if (this.entityResolver != null) {
                docBuilder.setEntityResolver(this.entityResolver);
            }
            is = resource.getInputStream();
            Document doc = docBuilder.parse(is);
            int n = this.registerBeanDefinitions(doc, resource);
            return n;
        }
        catch (ParserConfigurationException ex) {
            throw new BeanDefinitionStoreException("Parser configuration exception parsing XML from " + resource, ex);
        }
        catch (SAXParseException ex) {
            throw new BeanDefinitionStoreException("Line " + ex.getLineNumber() + " in XML document from " + resource + " is invalid", ex);
        }
        catch (SAXException ex) {
            throw new BeanDefinitionStoreException("XML document from " + resource + " is invalid", ex);
        }
        catch (IOException ex) {
            throw new BeanDefinitionStoreException("IOException parsing XML document from " + resource, ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    this.logger.warn((Object)"Could not close InputStream", (Throwable)ex);
                }
            }
        }
    }

    public int registerBeanDefinitions(Document doc, Resource resource) throws BeansException {
        XmlBeanDefinitionParser parser = (XmlBeanDefinitionParser)BeanUtils.instantiateClass(this.parserClass);
        return parser.registerBeanDefinitions(this, doc, resource);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

