/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.io.Resource;

public class PropertiesBeanDefinitionReader
extends AbstractBeanDefinitionReader {
    public static final String TRUE_VALUE = "true";
    public static final String SEPARATOR = ".";
    public static final String CLASS_KEY = "class";
    public static final String PARENT_KEY = "parent";
    public static final String ABSTRACT_KEY = "(abstract)";
    public static final String SINGLETON_KEY = "(singleton)";
    public static final String LAZY_INIT_KEY = "(lazy-init)";
    public static final String REF_SUFFIX = "(ref)";
    public static final String REF_PREFIX = "*";
    private String defaultParentBean;

    public PropertiesBeanDefinitionReader(BeanDefinitionRegistry beanFactory) {
        super(beanFactory);
    }

    public void setDefaultParentBean(String defaultParentBean) {
        this.defaultParentBean = defaultParentBean;
    }

    public String getDefaultParentBean() {
        return this.defaultParentBean;
    }

    public int loadBeanDefinitions(Resource resource) {
        return this.loadBeanDefinitions(resource, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadBeanDefinitions(Resource resource, String prefix) {
        Properties props = new Properties();
        try {
            InputStream is = resource.getInputStream();
            try {
                props.load(is);
            }
            finally {
                is.close();
            }
            return this.registerBeanDefinitions(props, prefix, resource.getDescription());
        }
        catch (IOException ex) {
            throw new BeanDefinitionStoreException("Could not parse properties from " + resource, ex);
        }
    }

    public int registerBeanDefinitions(ResourceBundle rb) throws BeanDefinitionStoreException {
        return this.registerBeanDefinitions(rb, null);
    }

    public int registerBeanDefinitions(ResourceBundle rb, String prefix) throws BeanDefinitionStoreException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration<String> keys = rb.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            map.put(key, rb.getObject(key));
        }
        return this.registerBeanDefinitions(map, prefix);
    }

    public int registerBeanDefinitions(Map map) throws BeansException {
        return this.registerBeanDefinitions(map, null);
    }

    public int registerBeanDefinitions(Map map, String prefix) throws BeansException {
        return this.registerBeanDefinitions(map, prefix, "Map " + map);
    }

    public int registerBeanDefinitions(Map map, String prefix, String resourceDescription) throws BeansException {
        if (prefix == null) {
            prefix = "";
        }
        int beanCount = 0;
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("Illegal key [" + key + "]: only Strings allowed");
            }
            String keyString = (String)key;
            if (!keyString.startsWith(prefix)) continue;
            String nameAndProperty = keyString.substring(prefix.length());
            int sepIdx = -1;
            int propKeyIdx = nameAndProperty.indexOf("[");
            sepIdx = propKeyIdx != -1 ? nameAndProperty.lastIndexOf(SEPARATOR, propKeyIdx) : nameAndProperty.lastIndexOf(SEPARATOR);
            if (sepIdx != -1) {
                String beanName = nameAndProperty.substring(0, sepIdx);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Found bean name '" + beanName + "'"));
                }
                if (this.getBeanFactory().containsBeanDefinition(beanName)) continue;
                this.registerBeanDefinition(beanName, map, prefix + beanName, resourceDescription);
                ++beanCount;
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Invalid bean name and property [" + nameAndProperty + "]"));
        }
        return beanCount;
    }

    protected void registerBeanDefinition(String beanName, Map map, String prefix, String resourceDescription) throws BeansException {
        String className = null;
        String parent = null;
        boolean isAbstract = false;
        boolean singleton = true;
        boolean lazyInit = false;
        MutablePropertyValues pvs = new MutablePropertyValues();
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            String strVal;
            Object val;
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            if (!key.startsWith(prefix + SEPARATOR)) continue;
            String property = key.substring(prefix.length() + SEPARATOR.length());
            if (property.equals(CLASS_KEY)) {
                className = (String)entry.getValue();
                continue;
            }
            if (property.equals(ABSTRACT_KEY)) {
                val = (String)entry.getValue();
                isAbstract = ((String)val).equals(TRUE_VALUE);
                continue;
            }
            if (property.equals(SINGLETON_KEY)) {
                val = (String)entry.getValue();
                singleton = val == null || ((String)val).equals(TRUE_VALUE);
                continue;
            }
            if (property.equals(LAZY_INIT_KEY)) {
                val = (String)entry.getValue();
                lazyInit = ((String)val).equals(TRUE_VALUE);
                continue;
            }
            if (property.equals(PARENT_KEY)) {
                parent = (String)entry.getValue();
                continue;
            }
            if (property.endsWith(REF_SUFFIX)) {
                property = property.substring(0, property.length() - REF_SUFFIX.length());
                String ref = (String)entry.getValue();
                RuntimeBeanReference val2 = new RuntimeBeanReference(ref);
                pvs.addPropertyValue(new PropertyValue(property, val2));
                continue;
            }
            val = entry.getValue();
            if (val instanceof String && (strVal = val).startsWith(REF_PREFIX)) {
                String targetName = strVal.substring(1);
                val = targetName.startsWith(REF_PREFIX) ? targetName : new RuntimeBeanReference(targetName);
            }
            pvs.addPropertyValue(new PropertyValue(property, val));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Registering bean definition for bean name '" + beanName + "' with " + pvs));
        }
        if (parent == null && className == null && !beanName.equals(this.defaultParentBean)) {
            parent = this.defaultParentBean;
        }
        try {
            AbstractBeanDefinition bd = BeanDefinitionReaderUtils.createBeanDefinition(className, parent, null, pvs, this.getBeanClassLoader());
            bd.setAbstract(isAbstract);
            bd.setSingleton(singleton);
            bd.setLazyInit(lazyInit);
            this.getBeanFactory().registerBeanDefinition(beanName, bd);
        }
        catch (ClassNotFoundException ex) {
            throw new BeanDefinitionStoreException(resourceDescription, beanName, "Bean class [" + className + "] not found", (Throwable)ex);
        }
        catch (NoClassDefFoundError err) {
            throw new BeanDefinitionStoreException(resourceDescription, beanName, "Class that bean class [" + className + "] depends on not found", (Throwable)err);
        }
    }
}

