/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.DelegatingDataSource;

public class LazyConnectionDataSourceProxy
extends DelegatingDataSource {
    private Boolean defaultAutoCommit;
    private Integer defaultTransactionIsolation;
    static /* synthetic */ Class class$org$springframework$jdbc$datasource$ConnectionProxy;

    public LazyConnectionDataSourceProxy() {
    }

    public LazyConnectionDataSourceProxy(DataSource targetDataSource) {
        this.setTargetDataSource(targetDataSource);
        this.afterPropertiesSet();
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this.defaultAutoCommit = new Boolean(defaultAutoCommit);
    }

    public void setDefaultTransactionIsolation(int defaultTransactionIsolation) {
        this.defaultTransactionIsolation = new Integer(defaultTransactionIsolation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.defaultAutoCommit == null || this.defaultTransactionIsolation == null) {
            try {
                Connection con = this.getTargetDataSource().getConnection();
                try {
                    this.checkDefaultConnectionProperties(con);
                }
                finally {
                    con.close();
                }
            }
            catch (SQLException ex) {
                this.logger.warn((Object)"Could not retrieve default auto-commit and transaction isolation settings", (Throwable)ex);
            }
        }
    }

    protected synchronized void checkDefaultConnectionProperties(Connection con) throws SQLException {
        if (this.defaultAutoCommit == null) {
            this.defaultAutoCommit = new Boolean(con.getAutoCommit());
        }
        if (this.defaultTransactionIsolation == null) {
            this.defaultTransactionIsolation = new Integer(con.getTransactionIsolation());
        }
    }

    protected Boolean defaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    protected Integer defaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public Connection getConnection() throws SQLException {
        return (Connection)Proxy.newProxyInstance((class$org$springframework$jdbc$datasource$ConnectionProxy == null ? (class$org$springframework$jdbc$datasource$ConnectionProxy = LazyConnectionDataSourceProxy.class$("org.springframework.jdbc.datasource.ConnectionProxy")) : class$org$springframework$jdbc$datasource$ConnectionProxy).getClassLoader(), new Class[]{class$org$springframework$jdbc$datasource$ConnectionProxy == null ? (class$org$springframework$jdbc$datasource$ConnectionProxy = LazyConnectionDataSourceProxy.class$("org.springframework.jdbc.datasource.ConnectionProxy")) : class$org$springframework$jdbc$datasource$ConnectionProxy}, (InvocationHandler)new LazyConnectionInvocationHandler());
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return (Connection)Proxy.newProxyInstance((class$org$springframework$jdbc$datasource$ConnectionProxy == null ? (class$org$springframework$jdbc$datasource$ConnectionProxy = LazyConnectionDataSourceProxy.class$("org.springframework.jdbc.datasource.ConnectionProxy")) : class$org$springframework$jdbc$datasource$ConnectionProxy).getClassLoader(), new Class[]{class$org$springframework$jdbc$datasource$ConnectionProxy == null ? (class$org$springframework$jdbc$datasource$ConnectionProxy = LazyConnectionDataSourceProxy.class$("org.springframework.jdbc.datasource.ConnectionProxy")) : class$org$springframework$jdbc$datasource$ConnectionProxy}, (InvocationHandler)new LazyConnectionInvocationHandler(username, password));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LazyConnectionInvocationHandler
    implements InvocationHandler {
        private String username;
        private String password;
        private Boolean readOnly = Boolean.FALSE;
        private Integer transactionIsolation;
        private Boolean autoCommit;
        private boolean closed = false;
        private Connection target;

        public LazyConnectionInvocationHandler() {
            this.autoCommit = LazyConnectionDataSourceProxy.this.defaultAutoCommit();
            this.transactionIsolation = LazyConnectionDataSourceProxy.this.defaultTransactionIsolation();
        }

        public LazyConnectionInvocationHandler(String username, String password) {
            this();
            this.username = username;
            this.password = password;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getTargetConnection")) {
                return this.getTargetConnection();
            }
            if (!this.hasTargetConnection()) {
                if (method.getName().equals("isReadOnly")) {
                    return this.readOnly;
                }
                if (method.getName().equals("setReadOnly")) {
                    this.readOnly = (Boolean)args[0];
                    return null;
                }
                if (method.getName().equals("getTransactionIsolation")) {
                    if (this.transactionIsolation != null) {
                        return this.transactionIsolation;
                    }
                } else {
                    if (method.getName().equals("setTransactionIsolation")) {
                        this.transactionIsolation = (Integer)args[0];
                        return null;
                    }
                    if (method.getName().equals("getAutoCommit")) {
                        if (this.autoCommit != null) {
                            return this.autoCommit;
                        }
                    } else {
                        if (method.getName().equals("setAutoCommit")) {
                            this.autoCommit = (Boolean)args[0];
                            return null;
                        }
                        if (method.getName().equals("commit")) {
                            return null;
                        }
                        if (method.getName().equals("rollback")) {
                            return null;
                        }
                        if (method.getName().equals("getWarnings")) {
                            return null;
                        }
                        if (method.getName().equals("clearWarnings")) {
                            return null;
                        }
                        if (method.getName().equals("isClosed")) {
                            return new Boolean(this.closed);
                        }
                        if (method.getName().equals("close")) {
                            this.closed = true;
                            return null;
                        }
                        if (this.closed) {
                            throw new SQLException("Illegal operation: connection is closed");
                        }
                    }
                }
            }
            try {
                return method.invoke((Object)this.getTargetConnection(), args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }

        protected boolean hasTargetConnection() {
            return this.target != null;
        }

        protected Connection getTargetConnection() throws SQLException {
            if (this.target == null) {
                this.target = this.username != null ? LazyConnectionDataSourceProxy.this.getTargetDataSource().getConnection(this.username, this.password) : LazyConnectionDataSourceProxy.this.getTargetDataSource().getConnection();
                LazyConnectionDataSourceProxy.this.checkDefaultConnectionProperties(this.target);
                if (this.readOnly.booleanValue()) {
                    this.target.setReadOnly(this.readOnly);
                }
                if (this.transactionIsolation != null && !this.transactionIsolation.equals(LazyConnectionDataSourceProxy.this.defaultTransactionIsolation())) {
                    this.target.setTransactionIsolation(this.transactionIsolation);
                }
                if (this.autoCommit != null && this.autoCommit.booleanValue() != this.target.getAutoCommit()) {
                    this.target.setAutoCommit(this.autoCommit);
                }
            }
            return this.target;
        }
    }
}

