/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.interceptor;

import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.springframework.aop.interceptor.AbstractTraceInterceptor;
import org.springframework.util.StopWatch;

public class PerformanceMonitorInterceptor
extends AbstractTraceInterceptor {
    public PerformanceMonitorInterceptor() {
    }

    public PerformanceMonitorInterceptor(boolean useDynamicLogger) {
        this.setUseDynamicLogger(useDynamicLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeUnderTrace(MethodInvocation invocation, Log logger) throws Throwable {
        String name = invocation.getMethod().getDeclaringClass().getName() + "." + invocation.getMethod().getName();
        StopWatch stopWatch = new StopWatch(name);
        stopWatch.start(name);
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            stopWatch.stop();
            logger.trace((Object)stopWatch.shortSummary());
        }
    }
}

