/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.interceptor;

import java.io.Serializable;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConcurrencyThrottleInterceptor
implements MethodInterceptor,
Serializable {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$aop$interceptor$ConcurrencyThrottleInterceptor == null ? (class$org$springframework$aop$interceptor$ConcurrencyThrottleInterceptor = ConcurrencyThrottleInterceptor.class$("org.springframework.aop.interceptor.ConcurrencyThrottleInterceptor")) : class$org$springframework$aop$interceptor$ConcurrencyThrottleInterceptor));
    private final transient Object monitor = new Object();
    private int concurrencyLimit = 1;
    private int concurrencyCount = 0;
    static /* synthetic */ Class class$org$springframework$aop$interceptor$ConcurrencyThrottleInterceptor;

    public void setConcurrencyLimit(int concurrencyLimit) {
        this.concurrencyLimit = concurrencyLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        boolean debug = logger.isDebugEnabled();
        Object object = this.monitor;
        synchronized (object) {
            while (this.concurrencyCount >= this.concurrencyLimit) {
                if (debug) {
                    logger.debug((Object)("Concurrency count " + this.concurrencyCount + " has reached limit " + this.concurrencyLimit + " - blocking"));
                }
                try {
                    this.monitor.wait();
                }
                catch (InterruptedException ex) {}
            }
            if (debug) {
                logger.debug((Object)("Entering method at concurrency count " + this.concurrencyCount));
            }
            ++this.concurrencyCount;
        }
        try {
            object = methodInvocation.proceed();
            return object;
        }
        finally {
            Object object2 = this.monitor;
            synchronized (object2) {
                --this.concurrencyCount;
                if (debug) {
                    logger.debug((Object)("Returning from method at concurrency count " + this.concurrencyCount));
                }
                this.monitor.notify();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

