/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.springframework.faces.webflow.FlowFacesContext;
import org.springframework.faces.webflow.FlowLifecycle;
import org.springframework.util.Assert;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class JsfManagedBeanResolver
extends ELResolver {
    public Class getCommonPropertyType(ELContext context, Object base) {
        return Object.class;
    }

    public Iterator getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class getType(ELContext context, Object base, Object property) {
        Object bean;
        if (base == null && (bean = this.getFacesBean(property)) != null) {
            context.setPropertyResolved(true);
            return bean.getClass();
        }
        return null;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        Object bean;
        if (base == null && (bean = this.getFacesBean(property)) != null) {
            context.setPropertyResolved(true);
            return bean;
        }
        return null;
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        RequestContext requestContext;
        if (base == null && ((requestContext = RequestContextHolder.getRequestContext()).getExternalContext().getRequestMap().contains(property.toString()) || requestContext.getExternalContext().getSessionMap().contains(property.toString()) || requestContext.getExternalContext().getApplicationMap().contains(property.toString()))) {
            context.setPropertyResolved(true);
        }
        return false;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (base == null) {
            RequestContext requestContext = RequestContextHolder.getRequestContext();
            if (requestContext.getExternalContext().getRequestMap().contains(property.toString())) {
                context.setPropertyResolved(true);
                requestContext.getExternalContext().getRequestMap().put(property.toString(), value);
            } else if (requestContext.getExternalContext().getSessionMap().contains(property.toString())) {
                context.setPropertyResolved(true);
                requestContext.getExternalContext().getSessionMap().put(property.toString(), value);
            } else if (requestContext.getExternalContext().getApplicationMap().contains(property.toString())) {
                context.setPropertyResolved(true);
                requestContext.getExternalContext().getApplicationMap().put(property.toString(), value);
            }
        }
    }

    private FacesContext getFacesContext() {
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        Assert.notNull((Object)requestContext, (String)"RequestContext cannot be null - This resolver is only intended to be invoked from an active Flow Execution.");
        FlowFacesContext facesContext = FlowFacesContext.newInstance(requestContext, FlowLifecycle.newInstance());
        return facesContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getFacesBean(Object beanName) {
        FacesContext facesContext = this.getFacesContext();
        Object result = null;
        try {
            ValueBinding vb = facesContext.getApplication().createValueBinding("#{" + beanName + "}");
            result = vb.getValue(facesContext);
        }
        finally {
            facesContext.release();
        }
        return result;
    }
}

