/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.snapshot;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.springframework.util.ClassUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.repository.snapshot.FlowExecutionSnapshot;
import org.springframework.webflow.execution.repository.snapshot.SnapshotCreationException;
import org.springframework.webflow.execution.repository.snapshot.SnapshotUnmarshalException;

public class SerializedFlowExecutionSnapshot
extends FlowExecutionSnapshot
implements Externalizable {
    private byte[] flowExecutionData;
    private boolean compressed;

    public SerializedFlowExecutionSnapshot() {
    }

    public SerializedFlowExecutionSnapshot(FlowExecution flowExecution, boolean compress) throws SnapshotCreationException {
        try {
            this.flowExecutionData = this.serialize(flowExecution);
            if (compress) {
                this.flowExecutionData = this.compress(this.flowExecutionData);
            }
        }
        catch (NotSerializableException e) {
            throw new SnapshotCreationException(flowExecution, "Could not serialize flow execution; make sure all objects stored in flow or flash scope are serializable", e);
        }
        catch (IOException e) {
            throw new SnapshotCreationException(flowExecution, "IOException thrown serializing flow execution -- this should not happen!", e);
        }
        this.compressed = compress;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public FlowExecution unmarshal(ClassLoader classLoader) throws SnapshotUnmarshalException {
        try {
            return this.deserialize(this.getFlowExecutionData(), classLoader);
        }
        catch (IOException e) {
            throw new SnapshotUnmarshalException("IOException thrown deserializing the flow execution stored in this snapshot -- this should not happen!", e);
        }
        catch (ClassNotFoundException e) {
            throw new SnapshotUnmarshalException("ClassNotFoundException thrown deserializing the flow execution stored in this snapshot -- This should not happen! Make sure there are no classloader issues. For example, perhaps the Web Flow system is being loaded by a classloader that is a parent of the classloader loading application classes?", e);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof SerializedFlowExecutionSnapshot)) {
            return false;
        }
        SerializedFlowExecutionSnapshot c = (SerializedFlowExecutionSnapshot)o;
        return Arrays.equals(this.flowExecutionData, c.flowExecutionData);
    }

    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.flowExecutionData.length; ++i) {
            hashCode += this.flowExecutionData[i];
        }
        return hashCode;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.flowExecutionData.length);
        out.write(this.flowExecutionData);
        out.writeBoolean(this.compressed);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int length = in.readInt();
        this.flowExecutionData = new byte[length];
        in.readFully(this.flowExecutionData);
        this.compressed = in.readBoolean();
    }

    protected byte[] getFlowExecutionData() throws IOException {
        if (this.isCompressed()) {
            return this.decompress(this.flowExecutionData);
        }
        return this.flowExecutionData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] serialize(FlowExecution flowExecution) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeObject(flowExecution);
            oos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            oos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FlowExecution deserialize(byte[] data, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        ConfigurableObjectInputStream ois = new ConfigurableObjectInputStream(new ByteArrayInputStream(data), classLoader);
        try {
            FlowExecution flowExecution = (FlowExecution)ois.readObject();
            return flowExecution;
        }
        finally {
            ois.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] compress(byte[] dataToCompress) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzipos = new GZIPOutputStream(baos);
        try {
            gzipos.write(dataToCompress);
            gzipos.flush();
        }
        finally {
            gzipos.close();
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] decompress(byte[] dataToDecompress) throws IOException {
        GZIPInputStream gzipin = new GZIPInputStream(new ByteArrayInputStream(dataToDecompress));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            FileCopyUtils.copy((InputStream)gzipin, (OutputStream)baos);
        }
        finally {
            gzipin.close();
        }
        return baos.toByteArray();
    }

    private static class ConfigurableObjectInputStream
    extends ObjectInputStream {
        private static final HashMap PRIMITIVE_CLASSES = new HashMap(8, 1.0f);
        private final ClassLoader classLoader;

        public ConfigurableObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classLoader = classLoader;
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String name = desc.getName();
            try {
                return ClassUtils.forName((String)desc.getName(), (ClassLoader)this.classLoader);
            }
            catch (ClassNotFoundException ex) {
                Class rtn = (Class)PRIMITIVE_CLASSES.get(name);
                if (rtn == null) {
                    throw ex;
                }
                return rtn;
            }
        }

        protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
            ClassLoader nonPublicLoader = null;
            boolean hasNonPublicInterface = false;
            Class[] classObjs = new Class[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                Class cl = ClassUtils.forName((String)interfaces[i], (ClassLoader)this.classLoader);
                if ((cl.getModifiers() & 1) == 0) {
                    if (hasNonPublicInterface) {
                        if (nonPublicLoader != cl.getClassLoader()) {
                            throw new IllegalAccessError("Conflicting non-public interface class loaders");
                        }
                    } else {
                        nonPublicLoader = cl.getClassLoader();
                        hasNonPublicInterface = true;
                    }
                }
                classObjs[i] = cl;
            }
            try {
                return Proxy.getProxyClass(hasNonPublicInterface ? nonPublicLoader : this.classLoader, classObjs);
            }
            catch (IllegalArgumentException e) {
                throw new ClassNotFoundException(null, e);
            }
        }

        static {
            PRIMITIVE_CLASSES.put("boolean", Boolean.TYPE);
            PRIMITIVE_CLASSES.put("byte", Byte.TYPE);
            PRIMITIVE_CLASSES.put("char", Character.TYPE);
            PRIMITIVE_CLASSES.put("short", Short.TYPE);
            PRIMITIVE_CLASSES.put("int", Integer.TYPE);
            PRIMITIVE_CLASSES.put("long", Long.TYPE);
            PRIMITIVE_CLASSES.put("float", Float.TYPE);
            PRIMITIVE_CLASSES.put("double", Double.TYPE);
            PRIMITIVE_CLASSES.put("void", Void.TYPE);
        }
    }
}

