/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.message.DefaultMessageContext;
import org.springframework.binding.message.MessageContext;
import org.springframework.binding.message.StateManageableMessageContext;
import org.springframework.context.MessageSource;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.CollectionUtils;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.TransitionDefinition;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.impl.FlowExecutionListeners;
import org.springframework.webflow.engine.impl.FlowExecutionStatus;
import org.springframework.webflow.engine.impl.FlowSessionImpl;
import org.springframework.webflow.engine.impl.RequestControlContextImpl;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.FlowExecutionKeyFactory;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.FlowExecutionOutcome;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springframework.webflow.execution.View;

public class FlowExecutionImpl
implements FlowExecution,
Externalizable {
    private static final Log logger = LogFactory.getLog(FlowExecutionImpl.class);
    private static final String FLASH_SCOPE_ATTRIBUTE = "flashScope";
    private transient Flow flow;
    private FlowExecutionStatus status;
    private LinkedList flowSessions;
    private transient FlowExecutionListeners listeners;
    private transient FlowExecutionKeyFactory keyFactory;
    private transient FlowExecutionKey key;
    private transient MutableAttributeMap conversationScope;
    private transient AttributeMap attributes;
    private transient FlowExecutionOutcome outcome;

    public FlowExecutionImpl() {
    }

    public FlowExecutionImpl(Flow flow) {
        Assert.notNull((Object)flow, (String)"The flow definition is required");
        this.flow = flow;
        this.status = FlowExecutionStatus.NOT_STARTED;
        this.listeners = new FlowExecutionListeners();
        this.attributes = CollectionUtils.EMPTY_ATTRIBUTE_MAP;
        this.flowSessions = new LinkedList();
        this.conversationScope = new LocalAttributeMap();
        this.conversationScope.put(FLASH_SCOPE_ATTRIBUTE, new LocalAttributeMap());
    }

    public String getCaption() {
        return "execution of '" + this.flow.getId() + "'";
    }

    public FlowExecutionKey getKey() {
        return this.key;
    }

    public FlowDefinition getDefinition() {
        return this.flow;
    }

    public boolean hasStarted() {
        return this.status == FlowExecutionStatus.ACTIVE || this.status == FlowExecutionStatus.ENDED;
    }

    public boolean isActive() {
        return this.status == FlowExecutionStatus.ACTIVE;
    }

    public boolean hasEnded() {
        return this.status == FlowExecutionStatus.ENDED;
    }

    public FlowExecutionOutcome getOutcome() {
        return this.outcome;
    }

    public FlowSession getActiveSession() {
        if (!this.isActive()) {
            if (this.status == FlowExecutionStatus.NOT_STARTED) {
                throw new IllegalStateException("No active FlowSession to access; this FlowExecution has not been started");
            }
            throw new IllegalStateException("No active FlowSession to access; this FlowExecution has ended");
        }
        return this.getActiveSessionInternal();
    }

    public MutableAttributeMap getFlashScope() {
        return (MutableAttributeMap)this.conversationScope.get(FLASH_SCOPE_ATTRIBUTE);
    }

    public MutableAttributeMap getConversationScope() {
        return this.conversationScope;
    }

    public AttributeMap getAttributes() {
        return this.attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(MutableAttributeMap input, ExternalContext externalContext) throws FlowExecutionException, IllegalStateException {
        Assert.state((!this.hasStarted() ? 1 : 0) != 0, (String)"This flow has already been started; you cannot call 'start()' more than once");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting in " + externalContext + " with input " + input));
        }
        MessageContext messageContext = this.createMessageContext(null);
        RequestControlContext requestContext = this.createRequestContext(externalContext, messageContext);
        RequestContextHolder.setRequestContext(requestContext);
        this.listeners.fireRequestSubmitted(requestContext);
        try {
            this.start(this.flow, input, requestContext);
        }
        catch (FlowExecutionException e) {
            this.handleException(e, requestContext);
        }
        catch (Exception e) {
            this.handleException(this.wrap(e), requestContext);
        }
        finally {
            this.saveFlashMessages(requestContext);
            if (this.isActive()) {
                try {
                    this.listeners.firePaused(requestContext);
                }
                catch (Throwable e) {
                    logger.error((Object)"FlowExecutionListener threw exception", e);
                }
            }
            try {
                this.listeners.fireRequestProcessed(requestContext);
            }
            catch (Throwable e) {
                logger.error((Object)"FlowExecutionListener threw exception", e);
            }
            RequestContextHolder.setRequestContext(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(ExternalContext externalContext) throws FlowExecutionException, IllegalStateException {
        Assert.state((this.status == FlowExecutionStatus.ACTIVE ? 1 : 0) != 0, (String)"This FlowExecution cannot be resumed because it is not active; it has either not been started or has ended");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resuming in " + externalContext));
        }
        Flow activeFlow = this.getActiveSessionInternal().getFlow();
        MessageContext messageContext = this.createMessageContext((MessageSource)activeFlow.getApplicationContext());
        RequestControlContext requestContext = this.createRequestContext(externalContext, messageContext);
        RequestContextHolder.setRequestContext(requestContext);
        this.listeners.fireRequestSubmitted(requestContext);
        try {
            this.listeners.fireResuming(requestContext);
            activeFlow.resume(requestContext);
        }
        catch (FlowExecutionException e) {
            this.handleException(e, requestContext);
        }
        catch (Exception e) {
            this.handleException(this.wrap(e), requestContext);
        }
        finally {
            this.saveFlashMessages(requestContext);
            if (this.isActive()) {
                try {
                    this.listeners.firePaused(requestContext);
                }
                catch (Throwable e) {
                    logger.error((Object)"FlowExecutionListener threw exception", e);
                }
            }
            try {
                this.listeners.fireRequestProcessed(requestContext);
            }
            catch (Throwable e) {
                logger.error((Object)"FlowExecutionListener threw exception", e);
            }
            RequestContextHolder.setRequestContext(null);
        }
    }

    public void setCurrentState(String stateId) {
        FlowSessionImpl session;
        if (this.status == FlowExecutionStatus.NOT_STARTED) {
            session = this.activateSession(this.flow);
            this.status = FlowExecutionStatus.ACTIVE;
        } else {
            session = this.getActiveSessionInternal();
        }
        State state = session.getFlow().getStateInstance(stateId);
        session.setCurrentState(state);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.status = (FlowExecutionStatus)((Object)in.readObject());
        this.flowSessions = (LinkedList)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject((Object)this.status);
        out.writeObject(this.flowSessions);
    }

    public String toString() {
        if (!this.isActive()) {
            if (!this.hasStarted()) {
                return "[Not yet started " + this.getCaption() + "]";
            }
            return "[Ended " + this.getCaption() + "]";
        }
        if (this.flow != null) {
            return new ToStringCreator((Object)this).append("flow", (Object)this.flow.getId()).append("flowSessions", (Object)this.flowSessions).toString();
        }
        return "[Unhydrated execution of '" + this.getRootSession().getFlowId() + "']";
    }

    protected RequestControlContext createRequestContext(ExternalContext externalContext, MessageContext messageContext) {
        return new RequestControlContextImpl(this, externalContext, messageContext);
    }

    protected FlowSessionImpl createFlowSession(Flow flow, FlowSessionImpl parent) {
        return new FlowSessionImpl(flow, parent);
    }

    void start(Flow flow, MutableAttributeMap input, RequestControlContext context) {
        this.listeners.fireSessionCreating(context, flow);
        FlowSessionImpl session = this.activateSession(flow);
        if (session.isRoot()) {
            this.status = FlowExecutionStatus.ACTIVE;
        }
        if (input == null) {
            input = new LocalAttributeMap();
        }
        if (this.hasEmbeddedModeAttribute(input)) {
            session.setEmbeddedMode();
        }
        StateManageableMessageContext messageContext = (StateManageableMessageContext)context.getMessageContext();
        messageContext.setMessageSource((MessageSource)flow.getApplicationContext());
        this.listeners.fireSessionStarting(context, session, input);
        flow.start(context, input);
        this.listeners.fireSessionStarted(context, session);
    }

    void setCurrentState(State newState, RequestContext context) {
        this.listeners.fireStateEntering(context, newState);
        FlowSessionImpl session = this.getActiveSessionInternal();
        State previousState = (State)session.getState();
        session.setCurrentState(newState);
        this.listeners.fireStateEntered(context, previousState);
    }

    public void viewRendering(View view, RequestContext context) {
        this.listeners.fireViewRendering(context, view);
    }

    public void viewRendered(View view, RequestContext context) {
        this.listeners.fireViewRendered(context, view);
    }

    boolean handleEvent(Event event, RequestControlContext context) {
        this.listeners.fireEventSignaled(context, event);
        return this.getActiveSessionInternal().getFlow().handleEvent(context);
    }

    boolean execute(Transition transition, RequestControlContext context) {
        this.listeners.fireTransitionExecuting(context, transition);
        return transition.execute((State)this.getActiveSession().getState(), context);
    }

    void endActiveFlowSession(String outcome, MutableAttributeMap output, RequestControlContext context) {
        FlowSessionImpl session = this.getActiveSessionInternal();
        this.listeners.fireSessionEnding(context, session, outcome, output);
        session.getFlow().end(context, outcome, output);
        this.flowSessions.removeLast();
        boolean executionEnded = this.flowSessions.isEmpty();
        if (executionEnded) {
            this.outcome = new FlowExecutionOutcome(outcome, output);
            this.status = FlowExecutionStatus.ENDED;
        }
        this.listeners.fireSessionEnded(context, session, outcome, output);
        if (!executionEnded) {
            this.getActiveSessionInternal().getFlow().restoreVariables(context);
            context.handleEvent(new Event(session.getState(), outcome, output));
        }
    }

    FlowExecutionKey assignKey() {
        this.key = this.keyFactory.getKey(this);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Assigned key " + this.key));
        }
        return this.key;
    }

    void updateCurrentFlowExecutionSnapshot() {
        this.keyFactory.updateFlowExecutionSnapshot(this);
    }

    void removeCurrentFlowExecutionSnapshot() {
        this.keyFactory.removeFlowExecutionSnapshot(this);
    }

    void removeAllFlowExecutionSnapshots() {
        this.keyFactory.removeAllFlowExecutionSnapshots(this);
    }

    TransitionDefinition getMatchingTransition(String eventId) {
        FlowSessionImpl session = this.getActiveSessionInternal();
        if (session == null) {
            return null;
        }
        TransitionableState currentState = (TransitionableState)session.getState();
        TransitionDefinition transition = currentState.getTransition(eventId);
        if (transition == null) {
            transition = session.getFlow().getGlobalTransition(eventId);
        }
        return transition;
    }

    FlowExecutionListener[] getListeners() {
        return this.listeners.getArray();
    }

    void setListeners(FlowExecutionListener[] listeners) {
        this.listeners = new FlowExecutionListeners(listeners);
    }

    void setAttributes(AttributeMap attributes) {
        this.attributes = attributes;
    }

    FlowExecutionKeyFactory getKeyFactory() {
        return this.keyFactory;
    }

    void setKeyFactory(FlowExecutionKeyFactory keyFactory) {
        this.keyFactory = keyFactory;
    }

    LinkedList getFlowSessions() {
        return this.flowSessions;
    }

    boolean hasSessions() {
        return !this.flowSessions.isEmpty();
    }

    boolean hasSubflowSessions() {
        return this.flowSessions.size() > 1;
    }

    FlowSessionImpl getRootSession() {
        return (FlowSessionImpl)this.flowSessions.getFirst();
    }

    Iterator getSubflowSessionIterator() {
        return this.flowSessions.listIterator(1);
    }

    void setFlow(Flow flow) {
        this.flow = flow;
    }

    void setConversationScope(MutableAttributeMap conversationScope) {
        this.conversationScope = conversationScope;
    }

    void setKey(FlowExecutionKey key) {
        this.key = key;
    }

    private MessageContext createMessageContext(MessageSource messageSource) {
        DefaultMessageContext messageContext = new DefaultMessageContext(messageSource);
        Serializable messagesMemento = (Serializable)this.getFlashScope().extract("messagesMemento");
        if (messagesMemento != null) {
            messageContext.restoreMessages(messagesMemento);
        }
        return messageContext;
    }

    private FlowSessionImpl activateSession(Flow flow) {
        FlowSessionImpl parent = this.getActiveSessionInternal();
        FlowSessionImpl session = this.createFlowSession(flow, parent);
        this.flowSessions.add(session);
        return session;
    }

    private FlowSessionImpl getActiveSessionInternal() {
        if (this.flowSessions.isEmpty()) {
            return null;
        }
        return (FlowSessionImpl)this.flowSessions.getLast();
    }

    private void saveFlashMessages(RequestContext context) {
        StateManageableMessageContext messageContext = (StateManageableMessageContext)context.getMessageContext();
        Serializable messagesMemento = messageContext.createMessagesMemento();
        this.getFlashScope().put("messagesMemento", messagesMemento);
    }

    private FlowExecutionException wrap(Exception e) {
        if (this.isActive()) {
            FlowSession session = this.getActiveSession();
            String flowId = session.getDefinition().getId();
            String stateId = session.getState() != null ? session.getState().getId() : null;
            return new FlowExecutionException(flowId, stateId, "Exception thrown in state '" + stateId + "' of flow '" + flowId + "'", e);
        }
        return new FlowExecutionException(this.flow.getId(), null, "Exception thrown within inactive flow '" + this.flow.getId() + "'", e);
    }

    private void handleException(FlowExecutionException exception, RequestControlContext context) {
        this.listeners.fireExceptionThrown(context, exception);
        if (logger.isDebugEnabled()) {
            if (exception.getCause() != null) {
                logger.debug((Object)("Attempting to handle [" + exception + "] with root cause [" + this.getRootCause(exception) + "]"));
            } else {
                logger.debug((Object)("Attempting to handle [" + exception + "]"));
            }
        }
        if (!this.isActive()) {
            throw exception;
        }
        boolean handled = false;
        try {
            if (this.tryStateHandlers(exception, context) || this.tryFlowHandlers(exception, context)) {
                handled = true;
            }
        }
        catch (FlowExecutionException newException) {
            this.handleException(newException, context);
            handled = true;
        }
        if (!handled) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Rethrowing unhandled flow execution exception");
            }
            throw exception;
        }
    }

    private Throwable getRootCause(Throwable e) {
        Throwable cause = e.getCause();
        return cause == null ? e : this.getRootCause(cause);
    }

    private boolean tryStateHandlers(FlowExecutionException exception, RequestControlContext context) {
        if (exception.getStateId() != null) {
            State state = this.getActiveSessionInternal().getFlow().getStateInstance(exception.getStateId());
            return state.handleException(exception, context);
        }
        return false;
    }

    private boolean tryFlowHandlers(FlowExecutionException exception, RequestControlContext context) {
        return this.getActiveSessionInternal().getFlow().handleException(exception, context);
    }

    private boolean hasEmbeddedModeAttribute(AttributeMap input) {
        String mode;
        return input != null && (mode = (String)input.get("mode")) != null && mode.trim().toLowerCase().equals("embedded");
    }
}

