/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.util;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.slide.common.Domain;

public class Messages {
    public static final String ResourceName = "org.apache.slide.util.resources.messages";
    private static ResourceBundle _messages;
    private static Hashtable _formats;

    public static String format(String message, Object arg1) {
        return Messages.format(message, new Object[]{arg1});
    }

    public static String format(String message, Object arg1, Object arg2) {
        return Messages.format(message, new Object[]{arg1, arg2});
    }

    public static String format(String message, Object arg1, Object arg2, Object arg3) {
        return Messages.format(message, new Object[]{arg1, arg2, arg3});
    }

    public static String format(String message, Object[] args) {
        try {
            MessageFormat mf = (MessageFormat)_formats.get(message);
            if (mf == null) {
                String msg;
                try {
                    msg = _messages.getString(message);
                }
                catch (MissingResourceException except) {
                    return message;
                }
                mf = new MessageFormat(msg);
                _formats.put(message, mf);
            }
            return mf.format(args);
        }
        catch (Exception except) {
            return "An internal error occured while processing message " + message;
        }
    }

    public static String message(String message) {
        try {
            return _messages.getString(message);
        }
        catch (MissingResourceException except) {
            return message;
        }
    }

    public static void setLocale(Locale locale) {
        block3: {
            _formats = new Hashtable();
            try {
                if (locale == null) {
                    _messages = ResourceBundle.getBundle(ResourceName);
                    break block3;
                }
                _messages = ResourceBundle.getBundle(ResourceName, locale);
            }
            catch (Exception except) {
                _messages = new EmptyResourceBundle();
                Domain.error("Failed to locate messages resource org.apache.slide.util.resources.messages");
            }
        }
    }

    static {
        Messages.setLocale(Locale.getDefault());
    }

    static class EmptyResourceBundle
    extends ResourceBundle
    implements Enumeration {
        EmptyResourceBundle() {
        }

        public Enumeration getKeys() {
            return this;
        }

        protected Object handleGetObject(String name) {
            return "[Missing message " + name + "]";
        }

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    }
}

