/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.slide.common.Domain;
import org.apache.slide.store.Store;

public abstract class Configuration {
    private static Properties _default;
    private static boolean _debug;
    private static boolean _security;
    private static boolean _locking;
    private static boolean _versioncontrol;
    private static boolean _search;
    private static boolean _binding;
    private static String _urlEncoding;
    private static boolean _principalIdentifiedLocks;
    static /* synthetic */ Class class$org$apache$slide$util$Configuration;

    public static boolean debug() {
        return _debug;
    }

    public static boolean useIntegratedSecurity() {
        return _security;
    }

    public static boolean useIntegratedLocking() {
        return _locking;
    }

    public static boolean useVersionControl() {
        return _versioncontrol;
    }

    public static boolean useSearch() {
        return _search;
    }

    public static boolean useBinding(Store store) {
        return _binding && store.useBinding();
    }

    public static boolean useGlobalBinding() {
        return _binding;
    }

    public static String urlEncoding() {
        return _urlEncoding;
    }

    public static boolean usePrincipalIdentifiedLocks() {
        return _principalIdentifiedLocks;
    }

    public static synchronized Properties getDefault() {
        if (_default == null) {
            Configuration.load();
        }
        return _default;
    }

    protected static void load() {
        _default = new Properties();
        try {
            _default.load((class$org$apache$slide$util$Configuration == null ? (class$org$apache$slide$util$Configuration = Configuration.class$("org.apache.slide.util.Configuration")) : class$org$apache$slide$util$Configuration).getResourceAsStream("/org/apache/slide/slide.properties"));
        }
        catch (Exception except) {
            // empty catch block
        }
        File file = new File(System.getProperty("java.home"), "lib");
        file = new File(file, "slide.properties");
        if (file.exists()) {
            _default = new Properties(_default);
            try {
                _default.load(new FileInputStream(file));
                Domain.info("Configuration found in java.home");
            }
            catch (IOException except) {
                // empty catch block
            }
        }
        try {
            InputStream is = (class$org$apache$slide$util$Configuration == null ? (class$org$apache$slide$util$Configuration = Configuration.class$("org.apache.slide.util.Configuration")) : class$org$apache$slide$util$Configuration).getResourceAsStream("/slide.properties");
            if (is != null) {
                _default = new Properties(_default);
                _default.load(is);
                Domain.info("Configuration found in classpath");
            }
        }
        catch (Exception except) {
            // empty catch block
        }
        String prop = _default.getProperty("org.apache.slide.debug", "false");
        if (prop.equalsIgnoreCase("true") || prop.equalsIgnoreCase("on")) {
            _debug = true;
        }
        _security = (prop = _default.getProperty("org.apache.slide.security", "true")).equalsIgnoreCase("true") || prop.equalsIgnoreCase("on");
        prop = _default.getProperty("org.apache.slide.lock", "true");
        _locking = prop.equalsIgnoreCase("true") || prop.equalsIgnoreCase("on");
        prop = _default.getProperty("org.apache.slide.versioncontrol", "true");
        _versioncontrol = prop.equalsIgnoreCase("true") || prop.equalsIgnoreCase("on");
        prop = _default.getProperty("org.apache.slide.search", "true");
        _search = prop.equalsIgnoreCase("true") || prop.equalsIgnoreCase("on");
        prop = _default.getProperty("org.apache.slide.binding", "true");
        _binding = prop.equalsIgnoreCase("true") || prop.equalsIgnoreCase("on");
        prop = _default.getProperty("org.apache.slide.principalIdentifiedLocks", "false");
        _principalIdentifiedLocks = prop.equalsIgnoreCase("true") || prop.equalsIgnoreCase("on");
        String defaultEncoding = new InputStreamReader(System.in).getEncoding();
        _urlEncoding = _default.getProperty("org.apache.slide.urlEncoding", defaultEncoding);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Configuration.getDefault();
    }

    public static class Property {
        public static final String DomainInitFilename = "org.apache.slide.domain";
        public static final String IntegratedSecurity = "org.apache.slide.security";
        public static final String IntegratedLocking = "org.apache.slide.lock";
        public static final String VersionControl = "org.apache.slide.versioncontrol";
        public static final String Search = "org.apache.slide.search";
        public static final String Binding = "org.apache.slide.binding";
        public static final String UrlEncoding = "org.apache.slide.urlEncoding";
        public static final String PrincipalIdentifiedLocks = "org.apache.slide.principalIdentifiedLocks";
        public static final String Debug = "org.apache.slide.debug";
        public static final String FileName = "slide.properties";
        static final String ResourceName = "/org/apache/slide/slide.properties";
    }
}

