/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.txfile;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.security.NodePermission;
import org.apache.slide.store.LockStore;
import org.apache.slide.store.NodeStore;
import org.apache.slide.store.RevisionDescriptorStore;
import org.apache.slide.store.RevisionDescriptorsStore;
import org.apache.slide.store.SecurityStore;
import org.apache.slide.store.txfile.AbstractTxFileStoreService;
import org.apache.slide.store.txfile.XMLResourceDescriptor;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;

public class TxXMLFileDescriptorsStore
extends AbstractTxFileStoreService
implements NodeStore,
LockStore,
RevisionDescriptorsStore,
RevisionDescriptorStore,
SecurityStore {
    protected static final String LOG_CHANNEL = (class$org$apache$slide$store$txfile$TxFileContentStore == null ? (class$org$apache$slide$store$txfile$TxFileContentStore = TxXMLFileDescriptorsStore.class$("org.apache.slide.store.txfile.TxFileContentStore")) : class$org$apache$slide$store$txfile$TxFileContentStore).getName();
    protected static final String ENCODING_PARAMETER = "encoding";
    protected String characterEncoding = "UTF-8";
    static /* synthetic */ Class class$org$apache$slide$store$txfile$TxFileContentStore;

    public void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
        super.setParameters(parameters);
        String encoding = (String)parameters.get(ENCODING_PARAMETER);
        if (encoding != null) {
            this.characterEncoding = encoding;
        }
    }

    public ObjectNode retrieveObject(Uri uri) throws ServiceAccessException, ObjectNotFoundException {
        XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
        ObjectNode object = xfd.retrieveObject(uri);
        return object;
    }

    public void storeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
        xfd.storeObject(uri, object);
    }

    public void createObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectAlreadyExistsException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            xfd.create();
            xfd.storeObject(uri, object);
        }
        catch (ObjectNotFoundException e) {
            this.throwInternalError("Newly created file vanished");
        }
    }

    public void removeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
        xfd.delete();
    }

    public void grantPermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            xfd.grantPermission(uri, permission);
        }
        catch (ObjectNotFoundException e) {
            this.throwInternalError(e);
        }
    }

    public void revokePermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            xfd.revokePermission(uri, permission);
        }
        catch (ObjectNotFoundException e) {
            this.throwInternalError(e);
        }
    }

    public void revokePermissions(Uri uri) throws ServiceAccessException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            xfd.revokePermissions(uri);
        }
        catch (ObjectNotFoundException e) {
            this.throwInternalError(e);
        }
    }

    public Enumeration enumeratePermissions(Uri uri) throws ServiceAccessException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            return xfd.enumeratePermissions();
        }
        catch (ObjectNotFoundException e) {
            this.throwInternalError(e);
            return null;
        }
    }

    public void putLock(Uri uri, NodeLock lock) throws ServiceAccessException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            xfd.putLock(uri, lock);
        }
        catch (ObjectNotFoundException e) {
            this.throwInternalError(e);
        }
    }

    public void renewLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            xfd.renewLock(uri, lock);
        }
        catch (ObjectNotFoundException e) {
            this.throwInternalError(e);
        }
    }

    public void removeLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            xfd.removeLock(uri, lock);
        }
        catch (ObjectNotFoundException e) {
            throw new LockTokenNotFoundException(lock);
        }
    }

    public void killLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        this.removeLock(uri, lock);
    }

    public Enumeration enumerateLocks(Uri uri) throws ServiceAccessException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            return xfd.enumerateLocks();
        }
        catch (ObjectNotFoundException e) {
            this.throwInternalError(e);
            return null;
        }
    }

    public NodeRevisionDescriptors retrieveRevisionDescriptors(Uri uri) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            return xfd.retrieveRevisionDescriptors(uri);
        }
        catch (ObjectNotFoundException e) {
            throw new RevisionDescriptorNotFoundException(uri.toString());
        }
    }

    public void createRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            xfd.createRevisionDescriptors(uri, revisionDescriptors);
        }
        catch (ObjectNotFoundException e) {
            this.throwInternalError(e);
        }
    }

    public void storeRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            xfd.storeRevisionDescriptors(uri, revisionDescriptors);
        }
        catch (ObjectNotFoundException e) {
            throw new RevisionDescriptorNotFoundException(uri.toString());
        }
    }

    public void removeRevisionDescriptors(Uri uri) throws ServiceAccessException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            xfd.removeRevisionDescriptors(uri);
        }
        catch (ObjectNotFoundException e) {
            this.throwInternalError(e);
        }
    }

    public NodeRevisionDescriptor retrieveRevisionDescriptor(Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            return xfd.retrieveRevisionDescriptor(uri, revisionNumber);
        }
        catch (ObjectNotFoundException e) {
            throw new RevisionDescriptorNotFoundException(uri.toString());
        }
    }

    public void createRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            xfd.createRevisionDescriptor(uri, revisionDescriptor);
        }
        catch (ObjectNotFoundException e) {
            this.throwInternalError(e);
        }
    }

    public void storeRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            xfd.storeRevisionDescriptor(uri, revisionDescriptor);
        }
        catch (ObjectNotFoundException e) {
            throw new RevisionDescriptorNotFoundException(uri.toString());
        }
    }

    public void removeRevisionDescriptor(Uri uri, NodeRevisionNumber number) throws ServiceAccessException {
        try {
            XMLResourceDescriptor xfd = this.getFileDescriptor(uri);
            xfd.removeRevisionDescriptor(uri, number);
        }
        catch (ObjectNotFoundException e) {
            this.throwInternalError(e);
        }
    }

    protected XMLResourceDescriptor getFileDescriptor(Uri uri) throws ServiceAccessException, ObjectNotFoundException {
        Object txId = this.getActiveTxId();
        XMLResourceDescriptor xfd = new XMLResourceDescriptor(uri, this, this.rm, txId, this.characterEncoding);
        return xfd;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

