/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.impl.rdbms;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.macro.ConflictException;
import org.apache.slide.security.NodePermission;
import org.apache.slide.store.impl.rdbms.StandardRDBMSAdapter;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.util.logger.Logger;

public class PostgresRDBMSAdapter
extends StandardRDBMSAdapter {
    protected static final String LOG_CHANNEL = (class$org$apache$slide$store$impl$rdbms$PostgresRDBMSAdapter == null ? (class$org$apache$slide$store$impl$rdbms$PostgresRDBMSAdapter = PostgresRDBMSAdapter.class$("org.apache.slide.store.impl.rdbms.PostgresRDBMSAdapter")) : class$org$apache$slide$store$impl$rdbms$PostgresRDBMSAdapter).getName();
    static /* synthetic */ Class class$org$apache$slide$store$impl$rdbms$PostgresRDBMSAdapter;

    public PostgresRDBMSAdapter(Service service, Logger logger) {
        super(service, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObject(Connection connection, Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        PreparedStatement statement = null;
        try {
            this.clearBinding(connection, uri);
            try {
                statement = connection.prepareStatement("delete from LINKS where LINKS.URI_ID = URI.URI_ID and URI.URI_STRING = ?");
                statement.setString(1, uri.toString());
                statement.executeUpdate();
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.close(statement);
                throw throwable;
            }
            this.close(statement);
            try {
                statement = connection.prepareStatement("delete from VERSION_HISTORY  where VERSION_HISTORY.URI_ID = URI.URI_ID and URI.URI_STRING = ?");
                statement.setString(1, uri.toString());
                statement.executeUpdate();
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.close(statement);
                throw throwable;
            }
            this.close(statement);
            try {
                statement = connection.prepareStatement("delete from VERSION where VERSION.URI_ID = URI.URI_ID and URI.URI_STRING = ?");
                statement.setString(1, uri.toString());
                statement.executeUpdate();
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                this.close(statement);
                throw throwable;
            }
            this.close(statement);
            try {
                statement = connection.prepareStatement("delete from OBJECT  where OBJECT.URI_ID = URI.URI_ID and URI.URI_STRING = ?");
                statement.setString(1, uri.toString());
                statement.executeUpdate();
                Object var12_15 = null;
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                this.close(statement);
                throw throwable;
            }
            this.close(statement);
            try {
                statement = connection.prepareStatement("delete from URI where URI_STRING = ?");
                statement.setString(1, uri.toString());
                statement.executeUpdate();
                Object var14_18 = null;
            }
            catch (Throwable throwable) {
                Object var14_19 = null;
                this.close(statement);
                throw throwable;
            }
            this.close(statement);
            {
            }
        }
        catch (SQLException e) {
            this.getLogger().log(e, LOG_CHANNEL, 2);
            throw new ServiceAccessException(this.service, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRevisionContent(Connection connection, Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        try {
            PreparedStatement statement = null;
            try {
                statement = connection.prepareStatement("delete from VERSION_CONTENT where VERSION_CONTENT.VERSION_ID = VERSION_HISTORY.VERSION_ID and VERSION_HISTORY.REVISION_NO = ? and VERSION_HISTORY.URI_ID=URI.URI_ID AND URI.URI_STRING=?");
                statement.setString(1, revisionDescriptor.getRevisionNumber().toString());
                statement.setString(2, uri.toString());
                statement.executeUpdate();
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.close(statement);
                throw throwable;
            }
            this.close(statement);
            {
            }
        }
        catch (Exception e) {
            this.getLogger().log(e, LOG_CHANNEL, 2);
            throw new ServiceAccessException(this.service, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRevisionDescriptor(Connection connection, Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            try {
                statement = connection.prepareStatement("delete from VERSION_LABELS where VERSION_LABELS.VERSION_ID = VERSION_HISTORY.VERSION_ID and VERSION_HISTORY.REVISION_NO = ? and VERSION_HISTORY.URI_ID = URI.URI_ID AND URI.URI_STRING = ?");
                statement.setString(1, revisionNumber.toString());
                statement.setString(2, uri.toString());
                statement.executeUpdate();
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.close(statement);
                throw throwable;
            }
            this.close(statement);
            try {
                statement = connection.prepareStatement("delete from PROPERTIES where PROPERTIES.VERSION_ID = VERSION_HISTORY.VERSION_ID and VERSION_HISTORY.REVISION_NO = ? and VERSION_HISTORY.URI_ID = URI.URI_ID AND URI.URI_STRING = ?");
                statement.setString(1, revisionNumber.toString());
                statement.setString(2, uri.toString());
                statement.executeUpdate();
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.close(statement);
                throw throwable;
            }
            this.close(statement);
            {
            }
        }
        catch (SQLException e) {
            this.getLogger().log(e, LOG_CHANNEL, 2);
            throw new ServiceAccessException(this.service, (Throwable)e);
        }
    }

    public void removeRevisionDescriptors(Connection connection, Uri uri) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            try {
                statement = connection.prepareStatement("delete from VERSION_PREDS where VERSION_PREDS.VERSION_ID = VERSION_HISTORY.VERSION_ID and VERSION_HISTORY.URI_ID = URI.URI_ID and URI.URI_STRING = ?");
                statement.setString(1, uri.toString());
                statement.executeUpdate();
            }
            catch (SQLException e) {
                throw this.createException(e, uri.toString());
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.close(statement);
            throw throwable;
        }
        this.close(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLock(Connection connection, Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        PreparedStatement statement = null;
        try {
            try {
                statement = connection.prepareStatement("delete from LOCKS where LOCK_ID = URI.URI_ID and URI.URI_STRING=?");
                statement.setString(1, lock.getLockId());
                statement.executeUpdate();
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.close(statement);
                throw throwable;
            }
            this.close(statement);
            try {
                statement = connection.prepareStatement("delete from URI where URI_ID = LOCKS.LOCK_ID and URI_STRING=?");
                statement.setString(1, lock.getLockId());
                statement.executeUpdate();
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.close(statement);
                throw throwable;
            }
            this.close(statement);
            {
            }
        }
        catch (SQLException e) {
            this.getLogger().log(e, LOG_CHANNEL, 2);
            throw new ServiceAccessException(this.service, (Throwable)e);
        }
    }

    public void revokePermission(Connection connection, Uri uri, NodePermission permission) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            try {
                NodeRevisionNumber revisionNumber = permission.getRevisionNumber();
                statement = connection.prepareStatement("delete from PERMISSIONS, URI ou, URI su, URI au where OBJECT_ID = ou.URI_ID and ou.URI_STRING = ? and SUBJECT_ID = su.URI_ID and su.URI_STRING = ? and ACTION_ID = au.URI_ID and au.URI_STRING = ? and VERSION_NO" + this.getRevisionNumberAsWhereQueryFragement(revisionNumber));
                statement.setString(1, permission.getObjectUri());
                statement.setString(2, permission.getSubjectUri());
                statement.setString(3, permission.getActionUri());
                statement.executeUpdate();
            }
            catch (SQLException e) {
                this.getLogger().log(e, LOG_CHANNEL, 2);
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.close(statement);
            throw throwable;
        }
        this.close(statement);
    }

    public void revokePermissions(Connection connection, Uri uri) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            try {
                statement = connection.prepareStatement("delete from PERMISSIONS where PERMISSIONS.OBJECT_ID = URI.URI_ID and URI.URI_STRING = ?");
                statement.setString(1, uri.toString());
                statement.executeUpdate();
            }
            catch (SQLException e) {
                this.getLogger().log(e, LOG_CHANNEL, 2);
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.close(statement);
            throw throwable;
        }
        this.close(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearBinding(Connection connection, Uri uri) throws ServiceAccessException, ObjectNotFoundException, SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement("delete from BINDING where (BINDING.URI_ID = URI.URI_ID and URI.URI_STRING = ?) ");
            statement.setString(1, uri.toString());
            statement.executeUpdate();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.close(statement);
            throw throwable;
        }
        this.close(statement);
        try {
            statement = connection.prepareStatement("delete from PARENT_BINDING where PARENT_BINDING.URI_ID = URI.URI_ID and URI.URI_STRING = ?");
            statement.setString(1, uri.toString());
            statement.executeUpdate();
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.close(statement);
            throw throwable;
        }
        this.close(statement);
    }

    protected ServiceAccessException createException(SQLException e, String uri) {
        String sqlstate = e.getSQLState();
        if (sqlstate.startsWith("23")) {
            this.getLogger().log(e.getErrorCode() + ": Deadlock resolved on " + uri, LOG_CHANNEL, 4);
            return new ServiceAccessException(this.service, (Throwable)new ConflictException(uri));
        }
        if (sqlstate.startsWith("40")) {
            this.getLogger().log(e.getErrorCode() + ": Deadlock resolved on " + uri, LOG_CHANNEL, 4);
            return new ServiceAccessException(this.service, (Throwable)new ConflictException(uri));
        }
        this.getLogger().log("SQL error " + e.getErrorCode() + " on " + uri + ": " + e.getMessage(), LOG_CHANNEL, 2);
        return new ServiceAccessException(this.service, (Throwable)e);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

