/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.impl.rdbms;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceInitializationFailedException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.store.ContentStore;
import org.apache.slide.store.LockStore;
import org.apache.slide.store.NodeStore;
import org.apache.slide.store.RevisionDescriptorStore;
import org.apache.slide.store.RevisionDescriptorsStore;
import org.apache.slide.store.SecurityStore;
import org.apache.slide.store.impl.rdbms.AbstractRDBMSStore;

public class J2EEStore
extends AbstractRDBMSStore
implements LockStore,
NodeStore,
RevisionDescriptorsStore,
RevisionDescriptorStore,
SecurityStore,
ContentStore {
    protected String LOG_CHANNEL = this.getClass().getName();
    protected DataSource ds = null;
    protected String datasource;

    public void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
        String value = (String)parameters.get("datasource");
        if (value == null) {
            throw new ServiceParameterMissingException(this, "datasource");
        }
        this.datasource = value;
        value = (String)parameters.get("tm-commits");
        if (value != null) {
            this.tmCommits = "true".equals(value);
        }
        super.setParameters(parameters);
    }

    public synchronized void initialize(NamespaceAccessToken token) throws ServiceInitializationFailedException {
        if (!this.alreadyInitialized) {
            try {
                try {
                    this.getLogger().log("Retrieving datasource '" + this.datasource + "'", this.LOG_CHANNEL, 6);
                    InitialContext initCtx = new InitialContext();
                    Context envCtx = (Context)initCtx.lookup("java:comp/env");
                    this.ds = (DataSource)envCtx.lookup(this.datasource);
                }
                catch (ClassCastException e) {
                    this.getLogger().log("Loading and registering datasource " + this.datasource + " failed", this.LOG_CHANNEL, 2);
                    this.getLogger().log(e.toString(), this.LOG_CHANNEL, 2);
                    throw new ServiceInitializationFailedException((Service)this, e.getMessage());
                }
                catch (NamingException e) {
                    this.getLogger().log("Loading and registering datasource " + this.datasource + " failed", this.LOG_CHANNEL, 2);
                    this.getLogger().log(e.toString(), this.LOG_CHANNEL, 2);
                    throw new ServiceInitializationFailedException((Service)this, e.getMessage());
                }
                catch (Exception e) {
                    this.getLogger().log("Loading and registering datasource " + this.datasource + " failed", this.LOG_CHANNEL, 2);
                    this.getLogger().log(e.toString(), this.LOG_CHANNEL, 2);
                    throw new ServiceInitializationFailedException((Service)this, e.getMessage());
                }
                Object var6_6 = null;
                this.alreadyInitialized = true;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.alreadyInitialized = true;
                throw throwable;
            }
            if (this.ds == null) {
                this.getLogger().log("Datasource is null, can't initialize store");
                throw new ServiceInitializationFailedException((Service)this, "Null datasource from context");
            }
        }
    }

    protected Connection getNewConnection() throws SQLException {
        return this.ds.getConnection();
    }
}

