/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.impl.rdbms;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.slide.common.AbstractXAService;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceConnectionFailedException;
import org.apache.slide.common.ServiceDisconnectionFailedException;
import org.apache.slide.common.ServiceInitializationFailedException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.ServiceResetFailedException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.security.NodePermission;
import org.apache.slide.store.ContentStore;
import org.apache.slide.store.LockStore;
import org.apache.slide.store.NodeStore;
import org.apache.slide.store.RevisionDescriptorStore;
import org.apache.slide.store.RevisionDescriptorsStore;
import org.apache.slide.store.SecurityStore;
import org.apache.slide.store.impl.rdbms.RDBMSAdapter;
import org.apache.slide.store.impl.rdbms.StandardRDBMSAdapter;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;

public abstract class AbstractRDBMSStore
extends AbstractXAService
implements LockStore,
NodeStore,
RevisionDescriptorsStore,
RevisionDescriptorStore,
SecurityStore,
ContentStore {
    protected String LOG_CHANNEL = this.getClass().getName();
    protected static final int TX_IDLE = 0;
    protected static final int TX_PREPARED = 1;
    protected static final int TX_SUSPENDED = 2;
    protected ThreadLocal activeTransactionContext = new ThreadLocal();
    protected RDBMSAdapter adapter;
    protected boolean alreadyInitialized = false;
    protected boolean tmCommits = false;
    static /* synthetic */ Class class$org$apache$slide$common$Service;
    static /* synthetic */ Class class$org$apache$slide$util$logger$Logger;

    public void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
        String value = (String)parameters.get("adapter");
        if (value == null) {
            this.adapter = new StandardRDBMSAdapter(this, this.getLogger());
        } else {
            try {
                Class<?> adapterClass = Class.forName(value);
                Constructor<?> ctor = adapterClass.getConstructor(class$org$apache$slide$common$Service == null ? (class$org$apache$slide$common$Service = AbstractRDBMSStore.class$("org.apache.slide.common.Service")) : class$org$apache$slide$common$Service, class$org$apache$slide$util$logger$Logger == null ? (class$org$apache$slide$util$logger$Logger = AbstractRDBMSStore.class$("org.apache.slide.util.logger.Logger")) : class$org$apache$slide$util$logger$Logger);
                this.adapter = (RDBMSAdapter)ctor.newInstance(this, this.getLogger());
            }
            catch (Exception e) {
                this.getLogger().log("Error instantiating Adapter '" + value + "' (" + e.getMessage() + ")", this.LOG_CHANNEL, 2);
            }
        }
        if (this.adapter != null) {
            this.adapter.setParameters(parameters);
        }
        try {
            this.initialize(null);
        }
        catch (ServiceInitializationFailedException e) {
            throw new ServiceParameterErrorException(this, e.getMessage());
        }
    }

    public synchronized void connect() throws ServiceConnectionFailedException {
    }

    public boolean isConnected() {
        return true;
    }

    public void disconnect() throws ServiceDisconnectionFailedException {
    }

    public synchronized void reset() throws ServiceResetFailedException {
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean setTransactionTimeout(int timeout) throws XAException {
        return false;
    }

    public Xid[] recover(int flag) throws XAException {
        this.getLogger().log("recover() for thread: " + Thread.currentThread(), this.LOG_CHANNEL, 7);
        TransactionId id = this.getActiveTransactionContext();
        if (id != null && id.status == 1) {
            Xid[] xids = new Xid[]{id.xid};
            return xids;
        }
        return new Xid[0];
    }

    public int prepare(Xid xid) throws XAException {
        this.getLogger().log("prepare() for thread: " + Thread.currentThread(), this.LOG_CHANNEL, 7);
        TransactionId id = this.getActiveTransactionContext();
        if (id == null) {
            throw new XAException(-4);
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        if (id.status != 0 && id.status != 2) {
            throw new XAException(-6);
        }
        if (id.rollbackOnly) {
            throw new XAException(100);
        }
        id.status = 1;
        return 0;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        if (xares == null) {
            return false;
        }
        return this == xares;
    }

    public void forget(Xid xid) throws XAException {
        this.getLogger().log("forget() for thread: " + Thread.currentThread(), this.LOG_CHANNEL, 7);
        TransactionId id = this.getActiveTransactionContext();
        if (id == null || id.xid == null) {
            throw new XAException(-4);
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        try {
            id.connection.close();
        }
        catch (SQLException e) {
            this.getLogger().log("Couldn't close connection.", this.LOG_CHANNEL, 2);
        }
        this.getLogger().log("forget(): removing from map: " + Thread.currentThread(), this.LOG_CHANNEL, 7);
        this.activeTransactionContext.set(null);
    }

    public void end(Xid xid, int flags) throws XAException {
        this.getLogger().log("end() for thread: " + Thread.currentThread(), this.LOG_CHANNEL, 7);
        TransactionId id = this.getActiveTransactionContext();
        if (id == null || id.xid == null) {
            throw new XAException(-4);
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        if (flags == 0x2000000) {
            id.status = 2;
        }
        if (flags == 0x20000000) {
            id.rollbackOnly = true;
        }
    }

    /*
     * Loose catch block
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        block15: {
            this.getLogger().log("commit() for thread " + Thread.currentThread() + ", removing from map", this.LOG_CHANNEL, 7);
            TransactionId id = this.getActiveTransactionContext();
            if (id == null) {
                this.getLogger().log("Error committing: no transaction associated with current thread", this.LOG_CHANNEL, 2);
                throw new XAException(-4);
            }
            if (xid == null) {
                throw new XAException(-5);
            }
            if (!onePhase && id.status != 1) {
                throw new XAException(-6);
            }
            if (onePhase && id.status != 0 && id.status != 2) {
                throw new XAException(-6);
            }
            Connection conn = id.connection;
            if (conn == null) {
                this.getLogger().log("commit(): No connection in connectionMap for id \"" + id + "\"", this.LOG_CHANNEL, 2);
                throw new XAException(-4);
            }
            if (!this.tmCommits) {
                if (id.rollbackOnly) {
                    conn.rollback();
                } else {
                    conn.commit();
                }
            }
            this.activeTransactionContext.set(null);
            Object var7_5 = null;
            try {
                conn.close();
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
            }
            break block15;
            {
                catch (Exception e) {
                    throw new XAException(101);
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    this.getLogger().log(e, this.LOG_CHANNEL, 2);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void rollback(Xid xid) throws XAException {
        block10: {
            this.getLogger().log("rollback() for thread " + Thread.currentThread() + ", removing from map", this.LOG_CHANNEL, 7);
            TransactionId id = this.getActiveTransactionContext();
            if (id == null) {
                this.getLogger().log("No transaction associated with current thread, can't rollback", this.LOG_CHANNEL, 2);
                throw new XAException(-4);
            }
            Connection conn = id.connection;
            if (conn == null) {
                this.getLogger().log("rollback(): No connection in connectionMap for id \"" + id + "\"", this.LOG_CHANNEL, 2);
                throw new XAException(-4);
            }
            if (!this.tmCommits) {
                conn.rollback();
            }
            this.activeTransactionContext.set(null);
            Object var6_4 = null;
            try {
                conn.close();
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
            }
            break block10;
            {
                catch (Exception e) {
                    throw new XAException(7);
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    this.getLogger().log(e, this.LOG_CHANNEL, 2);
                }
                throw throwable;
            }
        }
    }

    public void start(Xid xid, int flags) throws XAException {
        this.getLogger().log("start(): beginning transaction with xid " + xid, this.LOG_CHANNEL, 7);
        TransactionId id = this.getActiveTransactionContext();
        switch (flags) {
            case 0: {
                if (id != null) {
                    throw new XAException(-5);
                }
                try {
                    id = new TransactionId(xid, 0);
                }
                catch (SQLException e) {
                    throw new XAException(-7);
                }
                this.getLogger().log("start(): adding to map for " + Thread.currentThread(), this.LOG_CHANNEL, 7);
                this.activeTransactionContext.set(id);
                break;
            }
            case 0x200000: {
                this.getLogger().log("TMJOIN for transaction in thread: " + Thread.currentThread(), this.LOG_CHANNEL, 7);
                if (id != null) break;
                throw new XAException(-4);
            }
            case 0x8000000: {
                this.getLogger().log("TMRESUME for transaction in thread: " + Thread.currentThread(), this.LOG_CHANNEL, 7);
                if (id == null) {
                    throw new XAException(-4);
                }
                if (id.status != 2) {
                    throw new XAException(-5);
                }
                id.status = 0;
            }
        }
    }

    public ObjectNode retrieveObject(Uri uri) throws ServiceAccessException, ObjectNotFoundException {
        if (this.getActiveTransactionContext() == null) {
            Connection connection = null;
            try {
                connection = this.getNewConnection();
                ObjectNode objectNode = this.adapter.retrieveObject(connection, uri);
                return objectNode;
            }
            catch (SQLException e) {
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        this.getLogger().log(e, this.LOG_CHANNEL, 4);
                    }
                }
            }
        }
        return this.adapter.retrieveObject(this.getCurrentConnection(), uri);
    }

    public void storeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        this.adapter.storeObject(this.getCurrentConnection(), uri, object);
    }

    public void createObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectAlreadyExistsException {
        this.adapter.createObject(this.getCurrentConnection(), uri, object);
    }

    public void removeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        this.adapter.removeObject(this.getCurrentConnection(), uri, object);
    }

    public void grantPermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        this.adapter.grantPermission(this.getCurrentConnection(), uri, permission);
    }

    public void revokePermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        this.adapter.revokePermission(this.getCurrentConnection(), uri, permission);
    }

    public void revokePermissions(Uri uri) throws ServiceAccessException {
        this.adapter.revokePermissions(this.getCurrentConnection(), uri);
    }

    public Enumeration enumeratePermissions(Uri uri) throws ServiceAccessException {
        if (this.getActiveTransactionContext() == null) {
            Connection connection = null;
            try {
                connection = this.getNewConnection();
                Enumeration enumeration = this.adapter.enumeratePermissions(connection, uri);
                return enumeration;
            }
            catch (SQLException e) {
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        this.getLogger().log(e, this.LOG_CHANNEL, 4);
                    }
                }
            }
        }
        return this.adapter.enumeratePermissions(this.getCurrentConnection(), uri);
    }

    public void putLock(Uri uri, NodeLock lock) throws ServiceAccessException {
        this.adapter.putLock(this.getCurrentConnection(), uri, lock);
    }

    public void renewLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        this.adapter.renewLock(this.getCurrentConnection(), uri, lock);
    }

    public void removeLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        this.adapter.removeLock(this.getCurrentConnection(), uri, lock);
    }

    public void killLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        this.adapter.killLock(this.getCurrentConnection(), uri, lock);
    }

    public Enumeration enumerateLocks(Uri uri) throws ServiceAccessException {
        if (this.getActiveTransactionContext() == null) {
            Connection connection = null;
            try {
                connection = this.getNewConnection();
                Enumeration enumeration = this.adapter.enumerateLocks(connection, uri);
                return enumeration;
            }
            catch (SQLException e) {
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        this.getLogger().log(e, this.LOG_CHANNEL, 4);
                    }
                }
            }
        }
        return this.adapter.enumerateLocks(this.getCurrentConnection(), uri);
    }

    public NodeRevisionDescriptors retrieveRevisionDescriptors(Uri uri) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        if (this.getActiveTransactionContext() == null) {
            Connection connection = null;
            try {
                connection = this.getNewConnection();
                NodeRevisionDescriptors nodeRevisionDescriptors = this.adapter.retrieveRevisionDescriptors(connection, uri);
                return nodeRevisionDescriptors;
            }
            catch (SQLException e) {
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        this.getLogger().log(e, this.LOG_CHANNEL, 4);
                    }
                }
            }
        }
        return this.adapter.retrieveRevisionDescriptors(this.getCurrentConnection(), uri);
    }

    public void createRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException {
        this.adapter.createRevisionDescriptors(this.getCurrentConnection(), uri, revisionDescriptors);
    }

    public void storeRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        this.adapter.storeRevisionDescriptors(this.getCurrentConnection(), uri, revisionDescriptors);
    }

    public void removeRevisionDescriptors(Uri uri) throws ServiceAccessException {
        this.adapter.removeRevisionDescriptors(this.getCurrentConnection(), uri);
    }

    public NodeRevisionDescriptor retrieveRevisionDescriptor(Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        if (this.getActiveTransactionContext() == null) {
            Connection connection = null;
            try {
                connection = this.getNewConnection();
                NodeRevisionDescriptor nodeRevisionDescriptor = this.adapter.retrieveRevisionDescriptor(connection, uri, revisionNumber);
                return nodeRevisionDescriptor;
            }
            catch (SQLException e) {
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        this.getLogger().log(e, this.LOG_CHANNEL, 4);
                    }
                }
            }
        }
        return this.adapter.retrieveRevisionDescriptor(this.getCurrentConnection(), uri, revisionNumber);
    }

    public void createRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        this.adapter.createRevisionDescriptor(this.getCurrentConnection(), uri, revisionDescriptor);
    }

    public void storeRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        this.adapter.storeRevisionDescriptor(this.getCurrentConnection(), uri, revisionDescriptor);
    }

    public void removeRevisionDescriptor(Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException {
        this.adapter.removeRevisionDescriptor(this.getCurrentConnection(), uri, revisionNumber);
    }

    public NodeRevisionContent retrieveRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionNotFoundException {
        if (this.getActiveTransactionContext() == null) {
            Connection connection = null;
            try {
                connection = this.getNewConnection();
                NodeRevisionContent nodeRevisionContent = this.adapter.retrieveRevisionContent(connection, uri, revisionDescriptor, true);
                Object var6_6 = null;
                return nodeRevisionContent;
            }
            catch (SQLException e) {
                try {
                    throw new ServiceAccessException((Service)this, (Throwable)e);
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    throw throwable;
                }
            }
        }
        return this.adapter.retrieveRevisionContent(this.getCurrentConnection(), uri, revisionDescriptor, false);
    }

    public void createRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionAlreadyExistException {
        this.adapter.createRevisionContent(this.getCurrentConnection(), uri, revisionDescriptor, revisionContent);
    }

    public void storeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionNotFoundException {
        this.adapter.storeRevisionContent(this.getCurrentConnection(), uri, revisionDescriptor, revisionContent);
    }

    public void removeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        this.adapter.removeRevisionContent(this.getCurrentConnection(), uri, revisionDescriptor);
    }

    protected Connection getCurrentConnection() throws ServiceAccessException {
        this.getLogger().log("Getting current connection for thread " + Thread.currentThread(), this.LOG_CHANNEL, 7);
        TransactionId id = this.getActiveTransactionContext();
        if (id == null) {
            this.getLogger().log("No id for current thread - called outside transaction?", this.LOG_CHANNEL, 7);
            return null;
        }
        return id.connection;
    }

    protected TransactionId getActiveTransactionContext() {
        Object txId = this.activeTransactionContext.get();
        return (TransactionId)txId;
    }

    protected abstract Connection getNewConnection() throws SQLException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TransactionId {
        Xid xid;
        int status;
        boolean rollbackOnly;
        Connection connection;

        TransactionId(Xid xid, int status) throws SQLException {
            this.xid = xid;
            this.status = status;
            this.rollbackOnly = false;
            this.connection = AbstractRDBMSStore.this.getNewConnection();
        }
    }
}

