/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceInitializationFailedException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.security.NodePermission;
import org.apache.slide.store.AbstractStore;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.util.HashMapObjectCache;
import org.apache.slide.util.ObjectCache;

public class StandardStore
extends AbstractStore {
    protected ObjectCache objectsCache = new HashMapObjectCache(1000, 10000, 0.95);
    protected ObjectCache permissionsCache = new HashMapObjectCache(1000, 10000, 0.95);
    protected ObjectCache locksCache = new HashMapObjectCache(1000, 10000, 0.95);
    protected ObjectCache descriptorsCache = new HashMapObjectCache(1000, 10000, 0.95);
    protected ObjectCache descriptorCache = new HashMapObjectCache(1000, 10000, 0.8);

    public void initialize(NamespaceAccessToken token) throws ServiceInitializationFailedException {
        super.initialize(token);
    }

    public ObjectNode retrieveObject(Uri uri) throws ServiceAccessException, ObjectNotFoundException {
        if (this.nodeStore.cacheResults()) {
            Object tempObject = this.objectsCache.get(uri.toString());
            if (tempObject != null) {
                return ((ObjectNode)tempObject).cloneObject();
            }
            ObjectNode objectNode = this.nodeStore.retrieveObject(uri);
            objectNode.validate(uri.toString());
            this.objectsCache.put(uri.toString(), objectNode.cloneObject());
            return objectNode;
        }
        return super.retrieveObject(uri);
    }

    public void storeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        super.storeObject(uri, object);
        if (this.nodeStore.cacheResults()) {
            this.objectsCache.put(uri.toString(), object.cloneObject());
        }
    }

    public void createObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectAlreadyExistsException {
        super.createObject(uri, object);
        if (this.nodeStore.cacheResults()) {
            this.objectsCache.put(uri.toString(), object.cloneObject());
        }
    }

    public void removeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        super.removeObject(uri, object);
        if (this.nodeStore.cacheResults()) {
            this.objectsCache.remove(uri.toString());
        }
    }

    public void grantPermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        super.grantPermission(uri, permission);
        if (this.securityStore.cacheResults()) {
            NodePermission tempPermission = permission.cloneObject();
            Object value = this.permissionsCache.get(uri.toString());
            if (value == null) {
                this.enumeratePermissions(uri);
                value = this.permissionsCache.get(uri.toString());
                if (value == null) {
                    Vector<NodePermission> permissionsVector = new Vector<NodePermission>();
                    permissionsVector.addElement(tempPermission);
                    this.permissionsCache.put(uri.toString(), permissionsVector);
                }
            } else {
                Vector permissionsVector = (Vector)value;
                permissionsVector.addElement(tempPermission);
            }
        }
    }

    public void revokePermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        super.revokePermission(uri, permission);
        if (this.securityStore.cacheResults()) {
            Object value = this.permissionsCache.get(uri.toString());
            Vector permissionsVector = null;
            if (value != null) {
                permissionsVector = (Vector)value;
                permissionsVector.removeElement(permission);
            }
        }
    }

    public void revokePermissions(Uri uri) throws ServiceAccessException {
        super.revokePermissions(uri);
        if (this.securityStore.cacheResults()) {
            Object value = this.permissionsCache.get(uri.toString());
            Vector permissionsVector = null;
            if (value != null) {
                permissionsVector = (Vector)value;
                permissionsVector.removeAllElements();
            }
        }
    }

    public Enumeration enumeratePermissions(Uri uri) throws ServiceAccessException {
        if (this.securityStore.cacheResults()) {
            Object value = this.permissionsCache.get(uri.toString());
            Vector<NodePermission> permissionsVector = null;
            if (value != null) {
                permissionsVector = (Vector<NodePermission>)value;
            } else {
                permissionsVector = new Vector<NodePermission>();
                Enumeration tempEnum = this.securityStore.enumeratePermissions(uri);
                while (tempEnum.hasMoreElements()) {
                    NodePermission tempPermission = (NodePermission)tempEnum.nextElement();
                    tempPermission.validate(uri.toString());
                    permissionsVector.addElement(tempPermission);
                }
                this.permissionsCache.put(uri.toString(), permissionsVector);
            }
            return ((Vector)permissionsVector.clone()).elements();
        }
        return super.enumeratePermissions(uri);
    }

    public void putLock(Uri uri, NodeLock lock) throws ServiceAccessException {
        super.putLock(uri, lock);
        if (this.lockStore.cacheResults()) {
            Object value = this.locksCache.get(uri.toString());
            Vector<NodeLock> locksVector = null;
            if (value == null) {
                locksVector = new Vector<NodeLock>();
                this.locksCache.put(uri.toString(), locksVector);
            } else {
                locksVector = (Vector<NodeLock>)value;
            }
            locksVector.addElement(lock.cloneObject());
        }
    }

    public void renewLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        super.renewLock(uri, lock);
        if (this.lockStore.cacheResults()) {
            Object value = this.locksCache.get(uri.toString());
            Vector locksVector = null;
            if (value != null) {
                locksVector = (Vector)value;
                boolean wasPresent = locksVector.removeElement(lock);
                if (!wasPresent) {
                    throw new LockTokenNotFoundException(lock);
                }
                locksVector.addElement(lock.cloneObject());
            }
        }
    }

    public void removeLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        super.removeLock(uri, lock);
        if (this.lockStore.cacheResults()) {
            boolean wasPresent;
            Object value = this.locksCache.get(uri.toString());
            Vector locksVector = null;
            if (value != null && !(wasPresent = (locksVector = (Vector)value).removeElement(lock))) {
                throw new LockTokenNotFoundException(lock);
            }
        }
    }

    public void killLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        super.killLock(uri, lock);
        if (this.lockStore.cacheResults()) {
            boolean wasPresent;
            Object value = this.locksCache.get(uri.toString());
            Vector locksVector = null;
            if (value != null && !(wasPresent = (locksVector = (Vector)value).removeElement(lock))) {
                throw new LockTokenNotFoundException(lock);
            }
        }
    }

    public Enumeration enumerateLocks(Uri uri) throws ServiceAccessException {
        if (this.lockStore.cacheResults()) {
            Object value = this.locksCache.get(uri.toString());
            Vector<NodeLock> locksVector = null;
            if (value == null) {
                locksVector = new Vector<NodeLock>();
                Enumeration lockList = this.lockStore.enumerateLocks(uri);
                while (lockList.hasMoreElements()) {
                    NodeLock tempLock = (NodeLock)lockList.nextElement();
                    tempLock.validate(uri.toString());
                    locksVector.addElement(tempLock);
                }
                this.locksCache.put(uri.toString(), locksVector);
            } else {
                locksVector = (Vector<NodeLock>)value;
            }
            return ((Vector)locksVector.clone()).elements();
        }
        return super.enumerateLocks(uri);
    }

    public NodeRevisionDescriptors retrieveRevisionDescriptors(Uri uri) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        if (this.revisionDescriptorsStore.cacheResults()) {
            Object tempObject = this.descriptorsCache.get(uri.toString());
            if (tempObject != null) {
                return ((NodeRevisionDescriptors)tempObject).cloneObject();
            }
            NodeRevisionDescriptors revisionDescriptors = this.revisionDescriptorsStore.retrieveRevisionDescriptors(uri);
            revisionDescriptors = revisionDescriptors.cloneObject();
            this.descriptorsCache.put(uri.toString(), revisionDescriptors);
            revisionDescriptors.validate(uri.toString());
            return revisionDescriptors;
        }
        return super.retrieveRevisionDescriptors(uri);
    }

    public void createRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException {
        super.createRevisionDescriptors(uri, revisionDescriptors);
        if (this.revisionDescriptorsStore.cacheResults()) {
            this.descriptorsCache.put(uri.toString(), revisionDescriptors.cloneObject());
        }
    }

    public void storeRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        super.storeRevisionDescriptors(uri, revisionDescriptors);
        if (this.revisionDescriptorsStore.cacheResults()) {
            this.descriptorsCache.put(uri.toString(), revisionDescriptors.cloneObject());
        }
    }

    public void removeRevisionDescriptors(Uri uri) throws ServiceAccessException {
        if (this.revisionDescriptorsStore.cacheResults()) {
            this.descriptorsCache.remove(uri.toString());
        }
        super.removeRevisionDescriptors(uri);
    }

    public NodeRevisionDescriptor retrieveRevisionDescriptor(Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        if (this.revisionDescriptorStore.cacheResults()) {
            Object result = this.descriptorCache.get(uri + "-" + revisionNumber);
            if (result != null) {
                return ((NodeRevisionDescriptor)result).cloneObject();
            }
            NodeRevisionDescriptor revisionDescriptor = this.revisionDescriptorStore.retrieveRevisionDescriptor(uri, revisionNumber).cloneObject();
            revisionDescriptor.validate();
            this.descriptorCache.put(uri + "-" + revisionNumber, revisionDescriptor);
            return revisionDescriptor;
        }
        return super.retrieveRevisionDescriptor(uri, revisionNumber);
    }

    public void createRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        super.createRevisionDescriptor(uri, revisionDescriptor);
        if (this.revisionDescriptorStore.cacheResults()) {
            this.descriptorCache.put(uri + "-" + revisionDescriptor.getRevisionNumber(), revisionDescriptor.cloneObject());
        }
    }

    public void storeRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        super.storeRevisionDescriptor(uri, revisionDescriptor);
        if (this.revisionDescriptorStore.cacheResults()) {
            String key = uri + "-" + revisionDescriptor.getRevisionNumber();
            this.descriptorCache.put(key, revisionDescriptor.cloneObject());
        }
    }

    public void removeRevisionDescriptor(Uri uri, NodeRevisionNumber number) throws ServiceAccessException {
        super.removeRevisionDescriptor(uri, number);
        if (this.revisionDescriptorStore.cacheResults()) {
            this.descriptorCache.remove(uri + "-" + number);
        }
    }

    public NodeRevisionContent retrieveRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionNotFoundException {
        return super.retrieveRevisionContent(uri, revisionDescriptor);
    }

    public void createRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionAlreadyExistException {
        super.createRevisionContent(uri, revisionDescriptor, revisionContent);
    }

    public void storeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionNotFoundException {
        super.storeRevisionContent(uri, revisionDescriptor, revisionContent);
    }

    public void removeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        super.removeRevisionContent(uri, revisionDescriptor);
    }

    public String toString() {
        return this.getName() + "(" + this.getClass().getName() + ")";
    }

    protected void delist(Service service, boolean success) throws ServiceAccessException {
        if (!success) {
            this.resetCaches();
        }
        super.delist(service, success);
    }

    protected void resetCaches() {
        this.objectsCache.clear();
        this.permissionsCache.clear();
        this.locksCache.clear();
        this.descriptorsCache.clear();
        this.descriptorCache.clear();
    }
}

