/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.security;

import java.io.Serializable;
import org.apache.slide.common.ObjectValidationFailedException;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.structure.ActionNode;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.util.Messages;

public final class NodePermission
implements Serializable,
Cloneable {
    protected String objectUri;
    protected NodeRevisionNumber revisionNumber;
    protected String subjectUri;
    protected String actionUri;
    protected boolean inheritable;
    protected transient String inheritedFrom;
    protected boolean negative;
    protected boolean invert;
    protected boolean protect = false;
    static /* synthetic */ Class class$org$apache$slide$security$NodePermission;

    public NodePermission(String objectUri, String subjectUri, String actionUri) {
        if (objectUri != null) {
            this.objectUri = objectUri;
        }
        if (subjectUri != null) {
            this.setSubject(subjectUri);
        }
        if (actionUri != null) {
            this.setAction(actionUri);
        }
        this.inheritable = true;
        this.negative = false;
    }

    public NodePermission(String objectUri, String subjectUri, String actionUri, boolean inheritable) {
        this(objectUri, subjectUri, actionUri);
        this.inheritable = inheritable;
    }

    public NodePermission(String objectUri, String subjectUri, String actionUri, boolean inheritable, boolean negative) {
        this(objectUri, subjectUri, actionUri);
        this.inheritable = inheritable;
        this.negative = negative;
    }

    public NodePermission(ObjectNode object, SubjectNode subject, ActionNode action) {
        this(object.getUri(), subject.getUri(), action.getUri());
    }

    public NodePermission(ObjectNode object, SubjectNode subject, ActionNode action, boolean inheritable) {
        this(object, subject, action);
        this.inheritable = inheritable;
    }

    public NodePermission(ObjectNode object, SubjectNode subject, ActionNode action, boolean inheritable, boolean negative) {
        this(object, subject, action);
        this.inheritable = inheritable;
        this.negative = negative;
    }

    public NodePermission(ObjectNode object, NodeRevisionNumber revisionNumber, SubjectNode subject, ActionNode action, boolean inheritable, boolean negative) {
        this(object, subject, action);
        this.inheritable = inheritable;
        if (revisionNumber != null) {
            this.inheritable = false;
        }
        this.negative = negative;
        this.revisionNumber = revisionNumber;
    }

    public NodePermission(String objectUri, String revisionNumber, String subjectUri, String actionUri, boolean inheritable, boolean negative) {
        this(objectUri, subjectUri, actionUri);
        this.inheritable = inheritable;
        if (revisionNumber != null) {
            this.revisionNumber = new NodeRevisionNumber(revisionNumber);
            this.inheritable = false;
        }
        this.negative = negative;
    }

    public void setInheritable(boolean inheritable) {
        this.inheritable = inheritable;
    }

    public boolean isInheritable() {
        return this.inheritable;
    }

    public void setInheritedFrom(String uri) {
        this.inheritedFrom = uri;
    }

    public String getInheritedFrom() {
        return this.inheritedFrom;
    }

    public void setNegative(boolean negative) {
        this.negative = negative;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public void setProtected(boolean protect) {
        this.protect = protect;
    }

    public boolean isProtected() {
        return this.protect;
    }

    public String getObjectUri() {
        return this.objectUri;
    }

    void setObject(ObjectNode object) {
        if (object != null) {
            this.objectUri = object.getUri();
        }
    }

    public void setObject(String objectUri) {
        this.objectUri = objectUri;
    }

    public String getSubjectUri() {
        return this.subjectUri;
    }

    void setSubject(SubjectNode subject) {
        if (subject != null) {
            this.setSubject(subject.getUri());
        }
    }

    void setSubject(String subjectUri) {
        this.subjectUri = SubjectNode.getSubjectUri(subjectUri);
    }

    SubjectNode getSubjectNode() {
        return SubjectNode.getSubjectNode(this.subjectUri);
    }

    public NodeRevisionNumber getRevisionNumber() {
        return this.revisionNumber;
    }

    void setRevisionNumber(NodeRevisionNumber revisionNumber) {
        this.revisionNumber = revisionNumber;
    }

    public String getActionUri() {
        return this.actionUri;
    }

    ActionNode getActionNode() {
        return ActionNode.getActionNode(this.actionUri);
    }

    void setAction(ActionNode action) {
        if (action != null) {
            this.setAction(action.getUri());
        }
    }

    void setAction(String actionUri) {
        this.actionUri = "all" != actionUri && "all".equals(actionUri) ? "all" : actionUri;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj instanceof NodePermission) {
            NodePermission permission = (NodePermission)obj;
            result = this.objectUri.equals(permission.getObjectUri()) && this.subjectUri.equals(permission.getSubjectUri()) && this.actionUri.equals(permission.getActionUri()) && this.isNegative() == permission.isNegative();
        }
        return result;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "[object=" + this.objectUri + ", subject=" + this.subjectUri + ", action=" + this.actionUri + ", ->" + (this.negative ? "DENY" : "GRANT") + "]";
    }

    public NodePermission cloneObject() {
        NodePermission result = null;
        try {
            result = (NodePermission)super.clone();
        }
        catch (CloneNotSupportedException e) {}
        return result;
    }

    public void validate(String expectedUri) {
        if (this.objectUri == null) {
            throw new ObjectValidationFailedException(expectedUri, Messages.message((class$org$apache$slide$security$NodePermission == null ? (class$org$apache$slide$security$NodePermission = NodePermission.class$("org.apache.slide.security.NodePermission")) : class$org$apache$slide$security$NodePermission).getName() + ".nullObjectUri"));
        }
        if (!this.objectUri.equals(expectedUri)) {
            String tmpExpectedUri;
            String tmpObjectUri = this.objectUri;
            if (tmpObjectUri.endsWith("/")) {
                tmpObjectUri = tmpObjectUri.substring(0, tmpObjectUri.length() - 1);
            }
            if ((tmpExpectedUri = expectedUri).endsWith("/")) {
                tmpExpectedUri = tmpExpectedUri.substring(0, tmpExpectedUri.length() - 1);
            }
            if (!tmpObjectUri.equals(tmpExpectedUri)) {
                throw new ObjectValidationFailedException(expectedUri, Messages.message((class$org$apache$slide$security$NodePermission == null ? (class$org$apache$slide$security$NodePermission = NodePermission.class$("org.apache.slide.security.NodePermission")) : class$org$apache$slide$security$NodePermission).getName() + ".incorrectObjectUri"));
            }
        }
        if (this.subjectUri == null) {
            throw new ObjectValidationFailedException(expectedUri, Messages.message((class$org$apache$slide$security$NodePermission == null ? (class$org$apache$slide$security$NodePermission = NodePermission.class$("org.apache.slide.security.NodePermission")) : class$org$apache$slide$security$NodePermission).getName() + ".nullSubjectUri"));
        }
        if (this.actionUri == null) {
            throw new ObjectValidationFailedException(expectedUri, Messages.message((class$org$apache$slide$security$NodePermission == null ? (class$org$apache$slide$security$NodePermission = NodePermission.class$("org.apache.slide.security.NodePermission")) : class$org$apache$slide$security$NodePermission).getName() + ".nullActionUri"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

