/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.search.basic.sample;

import java.util.Collection;
import org.apache.slide.search.BadQueryException;
import org.apache.slide.search.PropertyProvider;
import org.apache.slide.search.basic.IBasicExpression;
import org.apache.slide.search.basic.IBasicExpressionFactory;
import org.apache.slide.search.basic.IBasicQuery;
import org.apache.slide.search.basic.sample.BasicExpressionSample;
import org.apache.slide.search.basic.sample.BasicQuerySample;
import org.jdom.Element;

public class BasicExpressionFactorySample
implements IBasicExpressionFactory {
    private BasicQuerySample query;
    protected PropertyProvider propertyProvider;

    public IBasicExpression createMergeExpression(String mergeOperator, String namespace, Collection expressionsToMerge) throws BadQueryException {
        BasicExpressionSample result = null;
        try {
            result = new BasicExpressionSample(mergeOperator, expressionsToMerge, this);
        }
        catch (ClassCastException e) {
            System.out.println("one of the the expressions is not an ExpressionSample");
        }
        return result;
    }

    public IBasicExpression createExpression(Element element) throws BadQueryException {
        BasicExpressionSample result = null;
        if (element == null) {
            result = new BasicExpressionSample("(no WHERE specified)", this);
        } else {
            String namespace = element.getNamespace().getURI();
            if (namespace.equals("DAV:")) {
                result = this.createDAVExpression(element);
            }
        }
        return result;
    }

    private BasicExpressionSample createDAVExpression(Element e) {
        String name = e.getName();
        BasicExpressionSample result = null;
        if (name.equals("eq")) {
            String prop = this.propName(e);
            String literal = e.getChild("literal", e.getNamespace()).getText();
            result = new BasicExpressionSample("(" + prop + " equals " + literal + ")", this);
        } else if (name.equals("lt")) {
            String prop = this.propName(e);
            String literal = e.getChildText("literal", e.getNamespace());
            result = new BasicExpressionSample("(" + prop + " lower_than " + literal + ")", this);
        }
        return result;
    }

    public void init(IBasicQuery query, PropertyProvider propertyProvider) throws BadQueryException {
        this.query = (BasicQuerySample)query;
        this.propertyProvider = propertyProvider;
    }

    public PropertyProvider getPropertyProvider() {
        return this.propertyProvider;
    }

    public IBasicQuery getQuery() {
        return this.query;
    }

    private String propName(Element e) {
        Element propElem = e.getChild("prop", e.getNamespace());
        Element el = (Element)propElem.getChildren().get(0);
        return el.getName();
    }
}

