/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.search;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class SearchQueryResult {
    public static final int STATUS_OK = 0;
    public static final int STATUS_BAD_QUERY = 1;
    public static final int STATUS_INVALID_SCOPE = 2;
    public static final int STATUS_PARTIAL_RESULT = 3;
    public static final int STATUS_UNPROCESSABLE_ENTITY = 4;
    public static final int STATUS_BAD_GATEWAY = 5;
    public static final int STATUS_FORBIDDEN = 6;
    private int status;
    private String description;
    private String href;
    private Set result;

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getHref() {
        return this.href;
    }

    public void add(SearchQueryResult subResultSet) {
        this.result.addAll(subResultSet.getResultSet());
    }

    public SearchQueryResult() {
        this(null, null);
    }

    public SearchQueryResult(Set result) {
        this(result, null);
    }

    public SearchQueryResult(Comparator comparator) {
        this(null, comparator);
    }

    public SearchQueryResult(Set result, Comparator comparator) {
        if (comparator == null) {
            this.result = result == null ? new HashSet() : result;
        } else {
            this.result = new TreeSet(comparator);
            if (result != null) {
                this.result.addAll(result);
            }
        }
        this.status = 0;
        this.description = "";
    }

    public SearchQueryResult(Set result, Comparator comparator, int limit) {
        this(result, comparator);
        if (this.result.size() > limit) {
            TreeSet tmp = new TreeSet(comparator);
            Iterator it = this.result.iterator();
            int i = 0;
            while (i < limit) {
                tmp.add(it.next());
                ++i;
            }
            this.result = tmp;
        }
    }

    public Iterator iterator() {
        return this.result.iterator();
    }

    Set getResultSet() {
        return this.result;
    }
}

