/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.content;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.slide.common.Domain;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.NamespaceConfig;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.Uri;
import org.apache.slide.common.UriPath;
import org.apache.slide.content.BranchNotFoundException;
import org.apache.slide.content.Content;
import org.apache.slide.content.ContentInterceptor;
import org.apache.slide.content.NodeNotVersionedException;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionContentNotFoundException;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.lock.Lock;
import org.apache.slide.lock.ObjectLockedException;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.security.Security;
import org.apache.slide.structure.ActionNode;
import org.apache.slide.structure.LinkedObjectNotFoundException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.Structure;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.util.Configuration;

public final class ContentImpl
implements Content {
    protected static final String I_URIREDIRECTORCLASS = "uriRedirectorClass";
    protected static final String I_URIREDIRECTORCLASS_DEFAULT = "org.apache.slide.webdav.util.DeltavUriRedirector";
    protected static final int PRE_STORE = 0;
    protected static final int POST_STORE = 1;
    protected static final int POST_RETRIEVE = 2;
    protected static final int PRE_REMOVE = 3;
    protected static final int POST_REMOVE = 4;
    protected static Class uriRedirectorClass;
    private Namespace namespace;
    private NamespaceConfig namespaceConfig;
    private Security securityHelper;
    private Structure structureHelper;
    private Lock lockHelper;
    static /* synthetic */ Class class$java$lang$String;

    public ContentImpl(Namespace namespace, NamespaceConfig namespaceConfig, Security securityHelper, Structure structureHelper, Lock lockHelper) {
        this.namespace = namespace;
        this.namespaceConfig = namespaceConfig;
        this.securityHelper = securityHelper;
        this.structureHelper = structureHelper;
        this.lockHelper = lockHelper;
    }

    public NodeRevisionDescriptors retrieve(SlideToken token, String strUri) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, ObjectLockedException {
        String originalUri = strUri;
        strUri = this.redirectUri(originalUri);
        ObjectNode associatedObject = this.structureHelper.retrieve(token, strUri, false);
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getReadRevisionMetadataAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getReadRevisionMetadataAction());
        Uri objectUri = this.namespace.getUri(token, strUri);
        NodeRevisionDescriptors revisionDescriptors = null;
        try {
            revisionDescriptors = objectUri.getStore().retrieveRevisionDescriptors(objectUri);
        }
        catch (RevisionDescriptorNotFoundException e) {
            revisionDescriptors = new NodeRevisionDescriptors();
            revisionDescriptors.setUri(objectUri.toString());
            objectUri.getStore().createRevisionDescriptors(objectUri, revisionDescriptors);
        }
        revisionDescriptors.setOriginalUri(originalUri);
        return revisionDescriptors;
    }

    public NodeRevisionDescriptor retrieve(SlideToken token, NodeRevisionDescriptors revisionDescriptors, String branch) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, ObjectLockedException, BranchNotFoundException, NodeNotVersionedException {
        NodeRevisionDescriptor result;
        Uri objectUri = this.namespace.getUri(token, revisionDescriptors.getUri());
        NodeRevisionNumber latestNrn = this.redirectLatestRevisionNumber(revisionDescriptors.getOriginalUri());
        NodeRevisionDescriptors realRevisionDescriptors = objectUri.getStore().retrieveRevisionDescriptors(objectUri);
        if (!realRevisionDescriptors.isVersioned()) {
            throw new NodeNotVersionedException(realRevisionDescriptors.getUri().toString());
        }
        if (latestNrn == null) {
            NodeRevisionNumber branchLatestRevisionNumber = realRevisionDescriptors.getLatestRevision(branch);
            if (branchLatestRevisionNumber == null) {
                throw new BranchNotFoundException(realRevisionDescriptors.getUri().toString(), branch);
            }
            result = this.retrieve(token, realRevisionDescriptors, branchLatestRevisionNumber);
        } else {
            result = this.retrieve(token, revisionDescriptors, latestNrn);
        }
        return result;
    }

    public NodeRevisionDescriptor retrieve(SlideToken token, NodeRevisionDescriptors revisionDescriptors, NodeRevisionNumber revisionNumber) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, ObjectLockedException {
        ObjectNode associatedObject = this.structureHelper.retrieve(token, revisionDescriptors.getUri(), false);
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getReadRevisionMetadataAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getReadRevisionMetadataAction());
        Uri objectUri = this.namespace.getUri(token, revisionDescriptors.getUri());
        NodeRevisionDescriptor revisionDescriptor = objectUri.getStore().retrieveRevisionDescriptor(objectUri, revisionNumber);
        this.invokeInterceptors(token, revisionDescriptors, revisionDescriptor, null, 2);
        return revisionDescriptor;
    }

    public NodeRevisionDescriptor retrieve(SlideToken token, NodeRevisionDescriptors revisionDescriptors) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, ObjectLockedException {
        Uri objectUri = this.namespace.getUri(token, revisionDescriptors.getUri());
        NodeRevisionNumber latestNrn = this.redirectLatestRevisionNumber(revisionDescriptors.getOriginalUri());
        NodeRevisionDescriptors realRevisionDescriptors = objectUri.getStore().retrieveRevisionDescriptors(objectUri);
        NodeRevisionDescriptor result = latestNrn == null ? this.retrieve(token, revisionDescriptors, realRevisionDescriptors.getLatestRevision()) : this.retrieve(token, revisionDescriptors, latestNrn);
        return result;
    }

    public NodeRevisionContent retrieve(SlideToken token, NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, RevisionNotFoundException, RevisionContentNotFoundException, ObjectLockedException {
        return this.retrieve(token, revisionDescriptors.getUri(), revisionDescriptor);
    }

    public NodeRevisionContent retrieve(SlideToken token, String strUri, NodeRevisionDescriptor revisionDescriptor) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, RevisionNotFoundException, RevisionContentNotFoundException, ObjectLockedException {
        ObjectNode associatedObject = this.structureHelper.retrieve(token, strUri, false);
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getReadRevisionContentAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getReadRevisionContentAction());
        Uri objectUri = this.namespace.getUri(token, strUri);
        NodeRevisionContent revisionContent = objectUri.getStore().retrieveRevisionContent(objectUri, revisionDescriptor);
        this.invokeInterceptors(token, null, revisionDescriptor, revisionContent, 2);
        return revisionContent;
    }

    public void create(SlideToken token, String strUri, boolean isVersioned) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, ObjectLockedException {
        this.checkParentExists(strUri, token);
        ObjectNode associatedObject = this.structureHelper.retrieve(token, strUri, false);
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getCreateRevisionMetadataAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getCreateRevisionMetadataAction());
        if (this.namespaceConfig.getCreateRevisionMetadataAction() != this.namespaceConfig.getCreateRevisionContentAction()) {
            this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getCreateRevisionContentAction());
            this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getCreateRevisionContentAction());
        }
        Uri objectUri = this.namespace.getUri(token, strUri);
        NodeRevisionDescriptors revisionDescriptors = new NodeRevisionDescriptors(isVersioned);
        revisionDescriptors.setUri(strUri);
        objectUri.getStore().createRevisionDescriptors(objectUri, revisionDescriptors);
    }

    public void create(SlideToken token, String strUri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ObjectNotFoundException, AccessDeniedException, RevisionAlreadyExistException, LinkedObjectNotFoundException, ServiceAccessException, ObjectLockedException {
        this.checkParentExists(strUri, token);
        ObjectNode associatedObject = this.structureHelper.retrieve(token, strUri, false);
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getCreateRevisionMetadataAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getCreateRevisionMetadataAction());
        if (this.namespaceConfig.getCreateRevisionMetadataAction() != this.namespaceConfig.getCreateRevisionContentAction()) {
            this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getCreateRevisionContentAction());
            this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getCreateRevisionContentAction());
        }
        this.setDefaultProperties(associatedObject, revisionDescriptor);
        if (revisionDescriptor.getCreationDate() == null) {
            revisionDescriptor.setCreationDate(new Date());
            this.setCreationUser(token, revisionDescriptor);
        }
        if (!(Configuration.useBinding(this.namespace.getUri(token, strUri).getStore()) || revisionDescriptor.getName() != null && revisionDescriptor.getName().length() != 0)) {
            revisionDescriptor.setName(new UriPath(strUri).lastSegment());
        }
        Uri objectUri = this.namespace.getUri(token, strUri);
        NodeRevisionDescriptors revisionDescriptors = null;
        try {
            revisionDescriptors = objectUri.getStore().retrieveRevisionDescriptors(objectUri);
        }
        catch (RevisionDescriptorNotFoundException e) {
            revisionDescriptors = new NodeRevisionDescriptors();
            revisionDescriptors.setUri(objectUri.toString());
            objectUri.getStore().createRevisionDescriptors(objectUri, revisionDescriptors);
        }
        NodeRevisionNumber newRevisionNumber = null;
        if (revisionDescriptors.isVersioned()) {
            if (revisionDescriptors.hasRevisions()) {
                newRevisionNumber = new NodeRevisionNumber(revisionDescriptors.getLatestRevision());
                revisionDescriptors.addSuccessor(revisionDescriptors.getLatestRevision(), newRevisionNumber);
                revisionDescriptors.setSuccessors(newRevisionNumber, new Vector());
            } else {
                newRevisionNumber = new NodeRevisionNumber();
                revisionDescriptors.setSuccessors(newRevisionNumber, new Vector());
            }
            revisionDescriptors.setLatestRevision(newRevisionNumber);
            revisionDescriptor.setRevisionNumber(newRevisionNumber);
            this.invokeInterceptors(token, revisionDescriptors, revisionDescriptor, revisionContent, 0);
            if (revisionContent != null) {
                objectUri.getStore().createRevisionContent(objectUri, revisionDescriptor, revisionContent);
            }
            revisionDescriptor.setModificationDate(revisionDescriptor.getCreationDate());
            revisionDescriptor.setModificationUser(this.securityHelper.getPrincipal(token).getPath().lastSegment());
            objectUri.getStore().createRevisionDescriptor(objectUri, revisionDescriptor);
        } else {
            newRevisionNumber = new NodeRevisionNumber();
            revisionDescriptor.setRevisionNumber(newRevisionNumber);
            if (!revisionDescriptors.hasRevisions()) {
                this.invokeInterceptors(token, revisionDescriptors, revisionDescriptor, revisionContent, 0);
                if (revisionContent != null) {
                    objectUri.getStore().createRevisionContent(objectUri, revisionDescriptor, revisionContent);
                }
                revisionDescriptor.setModificationDate(revisionDescriptor.getCreationDate());
                revisionDescriptor.setModificationUser(this.securityHelper.getPrincipal(token).getPath().lastSegment());
                objectUri.getStore().createRevisionDescriptor(objectUri, revisionDescriptor);
            } else {
                try {
                    NodeRevisionDescriptor oldRevisionDescriptor = objectUri.getStore().retrieveRevisionDescriptor(objectUri, newRevisionNumber);
                    Enumeration newPropertiesList = revisionDescriptor.enumerateProperties();
                    while (newPropertiesList.hasMoreElements()) {
                        oldRevisionDescriptor.setProperty((NodeProperty)newPropertiesList.nextElement());
                    }
                    revisionDescriptor = oldRevisionDescriptor;
                    this.invokeInterceptors(token, revisionDescriptors, revisionDescriptor, revisionContent, 0);
                    if (revisionContent != null) {
                        try {
                            objectUri.getStore().storeRevisionContent(objectUri, revisionDescriptor, revisionContent);
                        }
                        catch (RevisionNotFoundException e) {
                            objectUri.getStore().createRevisionContent(objectUri, revisionDescriptor, revisionContent);
                        }
                    }
                    revisionDescriptor.setModificationDate(revisionDescriptor.getCreationDate());
                    revisionDescriptor.setModificationUser(this.securityHelper.getPrincipal(token).getPath().lastSegment());
                    objectUri.getStore().storeRevisionDescriptor(objectUri, revisionDescriptor);
                }
                catch (RevisionDescriptorNotFoundException e) {
                    this.invokeInterceptors(token, revisionDescriptors, revisionDescriptor, revisionContent, 0);
                    revisionDescriptor.setModificationDate(revisionDescriptor.getCreationDate());
                    revisionDescriptor.setModificationUser(this.securityHelper.getPrincipal(token).getPath().lastSegment());
                    objectUri.getStore().createRevisionDescriptor(objectUri, revisionDescriptor);
                }
            }
            revisionDescriptors.setSuccessors(newRevisionNumber, new Vector());
            revisionDescriptors.setLatestRevision(newRevisionNumber);
        }
        try {
            objectUri.getStore().storeRevisionDescriptors(objectUri, revisionDescriptors);
        }
        catch (RevisionDescriptorNotFoundException e) {
            e.printStackTrace();
        }
        this.invokeInterceptors(token, revisionDescriptors, revisionDescriptor, revisionContent, 1);
    }

    public void create(SlideToken token, String strUri, String branch, NodeRevisionDescriptor newRevisionDescriptor, NodeRevisionContent revisionContent) throws ObjectNotFoundException, AccessDeniedException, RevisionAlreadyExistException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, ObjectLockedException, NodeNotVersionedException, BranchNotFoundException {
        this.checkParentExists(strUri, token);
        Uri objectUri = this.namespace.getUri(token, strUri);
        NodeRevisionDescriptors revisionDescriptors = objectUri.getStore().retrieveRevisionDescriptors(objectUri);
        if (branch != null) {
            NodeRevisionNumber branchLatestRevisionNumber = revisionDescriptors.getLatestRevision(branch);
            if (branchLatestRevisionNumber == null) {
                throw new BranchNotFoundException(strUri, branch);
            }
            this.create(token, strUri, branchLatestRevisionNumber, newRevisionDescriptor, revisionContent);
        } else {
            this.create(token, strUri, newRevisionDescriptor);
        }
    }

    public NodeRevisionNumber fork(SlideToken token, String strUri, String branchName, NodeRevisionDescriptor basedOnRevisionDescriptor) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, ObjectLockedException, NodeNotVersionedException, RevisionAlreadyExistException {
        return this.fork(token, strUri, branchName, basedOnRevisionDescriptor.getRevisionNumber());
    }

    public NodeRevisionNumber fork(SlideToken token, String strUri, String branchName, NodeRevisionNumber basedOnRevisionNumber) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, ObjectLockedException, NodeNotVersionedException, RevisionAlreadyExistException {
        if (branchName.equals("main")) {
            return null;
        }
        ObjectNode associatedObject = this.structureHelper.retrieve(token, strUri, false);
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getCreateRevisionMetadataAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getCreateRevisionMetadataAction());
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getCreateRevisionContentAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getCreateRevisionContentAction());
        Uri objectUri = this.namespace.getUri(token, strUri);
        NodeRevisionDescriptors revisionDescriptors = objectUri.getStore().retrieveRevisionDescriptors(objectUri);
        if (!revisionDescriptors.isVersioned()) {
            throw new NodeNotVersionedException(strUri);
        }
        NodeRevisionDescriptor basedOnRevisionDescriptor = objectUri.getStore().retrieveRevisionDescriptor(objectUri, basedOnRevisionNumber);
        NodeRevisionContent basedOnRevisionContent = null;
        try {
            basedOnRevisionContent = objectUri.getStore().retrieveRevisionContent(objectUri, basedOnRevisionDescriptor);
        }
        catch (RevisionNotFoundException e) {
            // empty catch block
        }
        NodeRevisionNumber branchedRevisionNumber = new NodeRevisionNumber(basedOnRevisionNumber, true);
        basedOnRevisionDescriptor.setRevisionNumber(branchedRevisionNumber);
        basedOnRevisionDescriptor.setBranchName(branchName);
        revisionDescriptors.setUri(strUri);
        revisionDescriptors.setLatestRevision(branchName, branchedRevisionNumber);
        revisionDescriptors.addSuccessor(basedOnRevisionNumber, branchedRevisionNumber);
        this.invokeInterceptors(token, revisionDescriptors, basedOnRevisionDescriptor, basedOnRevisionContent, 0);
        if (basedOnRevisionContent != null) {
            objectUri.getStore().createRevisionContent(objectUri, basedOnRevisionDescriptor, basedOnRevisionContent);
        }
        objectUri.getStore().createRevisionDescriptor(objectUri, basedOnRevisionDescriptor);
        objectUri.getStore().storeRevisionDescriptors(objectUri, revisionDescriptors);
        this.invokeInterceptors(token, revisionDescriptors, basedOnRevisionDescriptor, basedOnRevisionContent, 1);
        return branchedRevisionNumber;
    }

    public void merge(SlideToken token, String strUri, NodeRevisionDescriptor mainBranch, NodeRevisionDescriptor branch, NodeRevisionDescriptor newRevisionDescriptor, NodeRevisionContent revisionContent) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, ObjectLockedException, NodeNotVersionedException, BranchNotFoundException, RevisionAlreadyExistException {
        this.merge(token, strUri, mainBranch.getBranchName(), branch.getBranchName(), newRevisionDescriptor, revisionContent);
    }

    public void merge(SlideToken token, String strUri, String mainBranch, String branch, NodeRevisionDescriptor newRevisionDescriptor, NodeRevisionContent revisionContent) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, ObjectLockedException, NodeNotVersionedException, BranchNotFoundException, RevisionAlreadyExistException {
        ObjectNode associatedObject = this.structureHelper.retrieve(token, strUri, false);
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getCreateRevisionMetadataAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getCreateRevisionMetadataAction());
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getCreateRevisionContentAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getCreateRevisionContentAction());
        this.setDefaultProperties(associatedObject, newRevisionDescriptor);
        Uri objectUri = this.namespace.getUri(token, strUri);
        NodeRevisionDescriptors revisionDescriptors = objectUri.getStore().retrieveRevisionDescriptors(objectUri);
        if (!revisionDescriptors.isVersioned()) {
            throw new NodeNotVersionedException(strUri);
        }
        NodeRevisionNumber mainBranchLatestRevisionNumber = revisionDescriptors.getLatestRevision(mainBranch);
        NodeRevisionNumber branchLatestRevisionNumber = revisionDescriptors.getLatestRevision(branch);
        if (mainBranchLatestRevisionNumber == null) {
            throw new BranchNotFoundException(strUri, mainBranch);
        }
        if (branchLatestRevisionNumber == null) {
            throw new BranchNotFoundException(strUri, branch);
        }
        NodeRevisionNumber newRevisionNumber = new NodeRevisionNumber(mainBranchLatestRevisionNumber);
        newRevisionDescriptor.setRevisionNumber(newRevisionNumber);
        newRevisionDescriptor.setBranchName(branch);
        revisionDescriptors.addSuccessor(mainBranchLatestRevisionNumber, newRevisionNumber);
        revisionDescriptors.addSuccessor(branchLatestRevisionNumber, newRevisionNumber);
        revisionDescriptors.setLatestRevision(mainBranch, newRevisionNumber);
        this.invokeInterceptors(token, revisionDescriptors, newRevisionDescriptor, revisionContent, 0);
        if (revisionContent != null) {
            objectUri.getStore().createRevisionContent(objectUri, newRevisionDescriptor, revisionContent);
        }
        newRevisionDescriptor.setModificationDate(newRevisionDescriptor.getCreationDate());
        newRevisionDescriptor.setModificationUser(this.securityHelper.getPrincipal(token).getPath().lastSegment());
        objectUri.getStore().createRevisionDescriptor(objectUri, newRevisionDescriptor);
        objectUri.getStore().storeRevisionDescriptors(objectUri, revisionDescriptors);
        this.invokeInterceptors(token, revisionDescriptors, newRevisionDescriptor, revisionContent, 1);
    }

    public void store(SlideToken token, String strUri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, ObjectLockedException, RevisionNotFoundException {
        ObjectNode associatedObject = this.structureHelper.retrieve(token, strUri, false);
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getModifyRevisionMetadataAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getModifyRevisionMetadataAction());
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getModifyRevisionContentAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getModifyRevisionContentAction());
        this.setDefaultProperties(associatedObject, revisionDescriptor);
        Uri objectUri = this.namespace.getUri(token, strUri);
        NodeRevisionDescriptors revisionDescriptors = objectUri.getStore().retrieveRevisionDescriptors(objectUri);
        NodeRevisionDescriptor oldRevisionDescriptor = objectUri.getStore().retrieveRevisionDescriptor(objectUri, revisionDescriptor.getRevisionNumber());
        this.invokeInterceptors(token, revisionDescriptors, revisionDescriptor, revisionContent, 0);
        if (revisionContent != null) {
            try {
                objectUri.getStore().storeRevisionContent(objectUri, revisionDescriptor, revisionContent);
            }
            catch (RevisionNotFoundException e) {
                try {
                    objectUri.getStore().createRevisionContent(objectUri, revisionDescriptor, revisionContent);
                }
                catch (RevisionAlreadyExistException ex) {
                    ex.printStackTrace();
                }
            }
        }
        revisionDescriptor.setModificationDate(new Date());
        revisionDescriptor.setModificationUser(this.securityHelper.getPrincipal(token).getPath().lastSegment());
        objectUri.getStore().storeRevisionDescriptor(objectUri, revisionDescriptor);
        this.invokeInterceptors(token, revisionDescriptors, revisionDescriptor, revisionContent, 1);
    }

    public void remove(SlideToken token, NodeRevisionDescriptors revisionDescriptors) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, ObjectLockedException {
        this.invokeInterceptors(token, revisionDescriptors, null, null, 3);
        ObjectNode associatedObject = this.structureHelper.retrieve(token, revisionDescriptors.getUri(), false);
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getRemoveRevisionMetadataAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getRemoveRevisionMetadataAction());
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getRemoveRevisionContentAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getRemoveRevisionContentAction());
        Uri objectUri = this.namespace.getUri(token, revisionDescriptors.getUri());
        objectUri.getStore().removeRevisionDescriptors(objectUri);
        this.invokeInterceptors(token, revisionDescriptors, null, null, 4);
    }

    public void remove(SlideToken token, String strUri, NodeRevisionDescriptor revisionDescriptor) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, ObjectLockedException {
        this.remove(token, strUri, revisionDescriptor.getRevisionNumber());
    }

    public void remove(SlideToken token, String strUri, NodeRevisionNumber revisionNumber) throws ObjectNotFoundException, AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, ObjectLockedException {
        ObjectNode associatedObject = this.structureHelper.retrieve(token, strUri, false);
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getRemoveRevisionMetadataAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getRemoveRevisionMetadataAction());
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getRemoveRevisionContentAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getRemoveRevisionContentAction());
        Uri objectUri = this.namespace.getUri(token, strUri);
        NodeRevisionDescriptor revisionDescriptor = objectUri.getStore().retrieveRevisionDescriptor(objectUri, revisionNumber);
        this.invokeInterceptors(token, null, revisionDescriptor, null, 3);
        objectUri.getStore().removeRevisionContent(objectUri, revisionDescriptor);
        objectUri.getStore().removeRevisionDescriptor(objectUri, revisionNumber);
        this.invokeInterceptors(token, null, revisionDescriptor, null, 4);
    }

    protected void create(SlideToken token, String strUri, NodeRevisionNumber basedOnRevisionNumber, NodeRevisionDescriptor newRevisionDescriptor, NodeRevisionContent revisionContent) throws ObjectNotFoundException, AccessDeniedException, RevisionAlreadyExistException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, ObjectLockedException, NodeNotVersionedException {
        ObjectNode associatedObject = this.structureHelper.retrieve(token, strUri, false);
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getCreateRevisionMetadataAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getCreateRevisionMetadataAction());
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getCreateRevisionContentAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getCreateRevisionContentAction());
        this.setDefaultProperties(associatedObject, newRevisionDescriptor);
        Uri objectUri = this.namespace.getUri(token, strUri);
        NodeRevisionDescriptors revisionDescriptors = objectUri.getStore().retrieveRevisionDescriptors(objectUri);
        if (!revisionDescriptors.isVersioned()) {
            throw new NodeNotVersionedException(strUri);
        }
        NodeRevisionDescriptor realOldRevisionDescriptor = objectUri.getStore().retrieveRevisionDescriptor(objectUri, basedOnRevisionNumber);
        NodeRevisionNumber latestNumberInBranch = revisionDescriptors.getLatestRevision(realOldRevisionDescriptor.getBranchName());
        if (!realOldRevisionDescriptor.getRevisionNumber().equals(latestNumberInBranch)) {
            throw new RevisionAlreadyExistException(objectUri.toString(), new NodeRevisionNumber(basedOnRevisionNumber));
        }
        newRevisionDescriptor.setRevisionNumber(new NodeRevisionNumber(basedOnRevisionNumber));
        newRevisionDescriptor.setCreationDate(new Date());
        this.setCreationUser(token, newRevisionDescriptor);
        newRevisionDescriptor.setBranchName(realOldRevisionDescriptor.getBranchName());
        this.invokeInterceptors(token, revisionDescriptors, newRevisionDescriptor, revisionContent, 0);
        revisionDescriptors.addSuccessor(revisionDescriptors.getLatestRevision(newRevisionDescriptor.getBranchName()), newRevisionDescriptor.getRevisionNumber());
        revisionDescriptors.setSuccessors(newRevisionDescriptor.getRevisionNumber(), new Vector());
        revisionDescriptors.setLatestRevision(newRevisionDescriptor.getBranchName(), newRevisionDescriptor.getRevisionNumber());
        if (revisionContent != null) {
            objectUri.getStore().createRevisionContent(objectUri, newRevisionDescriptor, revisionContent);
        }
        newRevisionDescriptor.setModificationDate(newRevisionDescriptor.getCreationDate());
        newRevisionDescriptor.setModificationUser(this.securityHelper.getPrincipal(token).getPath().lastSegment());
        objectUri.getStore().createRevisionDescriptor(objectUri, newRevisionDescriptor);
        try {
            objectUri.getStore().storeRevisionDescriptors(objectUri, revisionDescriptors);
        }
        catch (RevisionDescriptorNotFoundException e) {
            e.printStackTrace();
        }
        this.invokeInterceptors(token, revisionDescriptors, newRevisionDescriptor, revisionContent, 1);
    }

    protected void create(SlideToken token, String strUri, NodeRevisionDescriptor revisionDescriptor) throws ObjectNotFoundException, AccessDeniedException, RevisionAlreadyExistException, LinkedObjectNotFoundException, ServiceAccessException, RevisionDescriptorNotFoundException, ObjectLockedException, NodeNotVersionedException {
        ObjectNode associatedObject = this.structureHelper.retrieve(token, strUri, false);
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getCreateRevisionMetadataAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getCreateRevisionMetadataAction());
        this.securityHelper.checkCredentials(token, associatedObject, this.namespaceConfig.getCreateRevisionContentAction());
        this.lockHelper.checkLock(token, associatedObject, this.namespaceConfig.getCreateRevisionContentAction());
        this.setDefaultProperties(associatedObject, revisionDescriptor);
        Uri objectUri = this.namespace.getUri(token, strUri);
        NodeRevisionDescriptors revisionDescriptors = objectUri.getStore().retrieveRevisionDescriptors(objectUri);
        revisionDescriptor.setCreationDate(new Date());
        this.setCreationUser(token, revisionDescriptor);
        String branchName = "backup";
        NodeProperty rootVersionProperty = revisionDescriptor.getProperty("version-set");
        if (rootVersionProperty != null) {
            branchName = "version-history";
        }
        revisionDescriptor.setBranchName(branchName);
        this.invokeInterceptors(token, revisionDescriptors, revisionDescriptor, null, 0);
        revisionDescriptor.setModificationDate(revisionDescriptor.getCreationDate());
        revisionDescriptor.setModificationUser(this.securityHelper.getPrincipal(token).getPath().lastSegment());
        objectUri.getStore().createRevisionDescriptor(objectUri, revisionDescriptor);
        try {
            objectUri.getStore().storeRevisionDescriptors(objectUri, revisionDescriptors);
        }
        catch (RevisionDescriptorNotFoundException e) {
            e.printStackTrace();
        }
        this.invokeInterceptors(token, revisionDescriptors, revisionDescriptor, null, 1);
    }

    private void setCreationUser(SlideToken token, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, ObjectNotFoundException {
        String creationUser = ((SubjectNode)this.securityHelper.getPrincipal(token)).getPath().lastSegment();
        revisionDescriptor.setCreationUser(creationUser);
        revisionDescriptor.setOwner(creationUser);
    }

    protected void setDefaultProperties(ObjectNode associatedObject, NodeRevisionDescriptor revisionDescriptor) {
        Enumeration roles = this.securityHelper.getRoles(associatedObject);
        while (roles.hasMoreElements()) {
            String role = (String)roles.nextElement();
            Enumeration defaultProperties = this.namespaceConfig.getDefaultProperties(role);
            revisionDescriptor.setDefaultProperties(defaultProperties);
        }
        if (this.namespaceConfig.isPrincipal(associatedObject.getUri())) {
            String rt;
            if (revisionDescriptor.getName() == null || revisionDescriptor.getName().length() == 0) {
                UriPath uripath = new UriPath(associatedObject.getUri());
                revisionDescriptor.setName(uripath.lastSegment());
            }
            if ((rt = revisionDescriptor.getResourceType()).indexOf("principal") < 0) {
                revisionDescriptor.setResourceType(rt + "<principal/>");
            }
        }
    }

    protected void invokeInterceptors(SlideToken token, NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent, int type) throws AccessDeniedException, ObjectNotFoundException, LinkedObjectNotFoundException, ObjectLockedException, ServiceAccessException {
        ContentInterceptor[] contentInterceptors = this.namespace.getContentInterceptors();
        int i = 0;
        while (i < contentInterceptors.length) {
            switch (type) {
                case 0: {
                    contentInterceptors[i].preStoreContent(token, revisionDescriptors, revisionDescriptor, revisionContent);
                    break;
                }
                case 1: {
                    contentInterceptors[i].postStoreContent(token, revisionDescriptors, revisionDescriptor, revisionContent);
                    break;
                }
                case 2: {
                    contentInterceptors[i].postRetrieveContent(token, revisionDescriptors, revisionDescriptor, revisionContent);
                    break;
                }
                case 3: {
                    contentInterceptors[i].preRemoveContent(token, revisionDescriptors, revisionDescriptor);
                    break;
                }
                case 4: {
                    contentInterceptors[i].postRemoveContent(token, revisionDescriptors, revisionDescriptor);
                }
            }
            ++i;
        }
    }

    protected String redirectUri(String uri) {
        String result;
        block2: {
            result = uri;
            if (uriRedirectorClass == null) break block2;
            try {
                Method ru = uriRedirectorClass.getMethod("redirectUri", class$java$lang$String == null ? (class$java$lang$String = ContentImpl.class$("java.lang.String")) : class$java$lang$String);
                result = (String)ru.invoke(null, uri);
            }
            catch (Exception x) {
                Domain.warn("Redirecting of URI " + uri + " failed: " + x.getMessage());
            }
        }
        return result;
    }

    protected NodeRevisionNumber redirectLatestRevisionNumber(String uri) {
        NodeRevisionNumber result;
        block2: {
            result = null;
            if (uriRedirectorClass == null) break block2;
            try {
                Method ru = uriRedirectorClass.getMethod("redirectLatestRevisionNumber", class$java$lang$String == null ? (class$java$lang$String = ContentImpl.class$("java.lang.String")) : class$java$lang$String);
                result = (NodeRevisionNumber)ru.invoke(null, uri);
            }
            catch (Exception x) {
                Domain.warn("Redirecting of latest revision number for " + uri + " failed: " + x.getMessage());
            }
        }
        return result;
    }

    private boolean isLockNull(NodeRevisionDescriptor nrd) {
        return nrd.propertyValueContains("resourcetype", "lock-null");
    }

    private void checkParentExists(String strUri, SlideToken token) throws ServiceAccessException, ObjectLockedException, AccessDeniedException, LinkedObjectNotFoundException, ObjectNotFoundException {
        if (this.namespaceConfig.getCreateObjectAction() == ActionNode.DEFAULT) {
            return;
        }
        String parentUri = String.valueOf(new UriPath(strUri).parent());
        try {
            NodeRevisionDescriptor parentNrd = this.retrieve(token, this.retrieve(token, parentUri));
            if (this.isLockNull(parentNrd)) {
                throw new ObjectNotFoundException(parentUri);
            }
        }
        catch (RevisionDescriptorNotFoundException e) {
            throw new ObjectNotFoundException(parentUri);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            String uriRedirectorClassName = Domain.getParameter(I_URIREDIRECTORCLASS, I_URIREDIRECTORCLASS_DEFAULT);
            uriRedirectorClass = Class.forName(uriRedirectorClassName);
        }
        catch (Exception x) {
            Domain.warn("Loading of redirector class failed: " + x.getMessage());
        }
    }
}

