/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import org.apache.slide.common.Domain;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.Scope;
import org.apache.slide.common.ScopeTokenizer;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceConnectionFailedException;
import org.apache.slide.common.ServiceMissingOnRootNodeException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.UriPath;
import org.apache.slide.store.Store;

public class Uri
implements Cloneable,
Serializable {
    protected transient Namespace namespace;
    protected transient String uri;
    protected transient ScopeTokenizer scopes;
    protected transient Scope scope;
    protected transient int pk;
    protected transient Store store;
    protected transient SlideToken token;

    public Uri(Namespace namespace, String uri) {
        this(null, namespace, uri);
    }

    public Uri(SlideToken token, Namespace namespace, String uri) {
        this.token = token;
        this.namespace = namespace;
        this.parseUri(uri);
    }

    public void setUri(String uri) {
        this.parseUri(uri);
    }

    public static Uri getRoot(Uri uri) {
        return new Uri(uri.getToken(), uri.getNamespace(), uri.getScope().toString());
    }

    public Scope getScope() {
        return this.scope;
    }

    public Enumeration getScopes() {
        return this.scopes.elements();
    }

    public Store getStore() {
        return this.store;
    }

    public SlideToken getToken() {
        return this.token;
    }

    public void setToken(SlideToken token) {
        this.token = token;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public Uri getParentUri() {
        Uri result = this.scopes.getParentUri();
        if (result != null) {
            result.setToken(this.token);
        }
        return result;
    }

    public void invalidateServices() {
        this.store = null;
        this.pk = 0;
        this.parseUri(this.uri);
    }

    public void reconnectServices() {
        block4: {
            try {
                if (this.token == null) {
                    this.store.connectIfNeeded(null);
                    break block4;
                }
                this.store.connectIfNeeded(this.token.getCredentialsToken());
            }
            catch (ServiceConnectionFailedException e) {
                this.parseUri(this.uri);
            }
            catch (ServiceAccessException e) {
                this.parseUri(this.uri);
            }
        }
    }

    public String getRelative() {
        return this.uri.substring(this.scope.toString().length());
    }

    public boolean isStoreRoot() {
        UriPath thisPath = new UriPath(this.uri);
        UriPath scopePath = new UriPath(this.scope.toString());
        return thisPath.equals(scopePath);
    }

    public String toString() {
        return this.uri;
    }

    public int hashCode() {
        return this.pk;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Uri) {
            return this.uri.equals(obj.toString());
        }
        return false;
    }

    public Uri cloneObject() {
        Uri result = null;
        try {
            result = (Uri)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean isParent(Uri uri) {
        return this.uri.startsWith(uri.toString());
    }

    private void parseUri(String uri) {
        this.scopes = new ScopeTokenizer(this.token, this.namespace, uri);
        this.uri = this.scopes.getUri();
        this.store = null;
        while (this.store == null && this.scopes.hasMoreElements()) {
            Scope courScope = this.scopes.nextScope();
            try {
                if (this.store != null) continue;
                this.store = this.token == null ? this.namespace.retrieveStore(courScope, null) : this.namespace.retrieveStore(courScope, this.token.getCredentialsToken());
                if (this.store == null) continue;
                this.scope = courScope;
                this.pk = this.uri.substring(this.scope.toString().length()).hashCode();
            }
            catch (ServiceConnectionFailedException e) {
            }
            catch (ServiceAccessException e) {
                // empty catch block
            }
        }
        if (this.store == null) {
            throw new ServiceMissingOnRootNodeException();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String namespaceName = (String)in.readObject();
        this.namespace = Domain.getNamespace(namespaceName);
        this.parseUri((String)in.readObject());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.namespace.getName());
        out.writeObject(this.uri);
    }
}

