/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.common;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.slide.authenticate.SecurityToken;
import org.apache.slide.common.DomainAccessToken;
import org.apache.slide.common.DomainInitializationFailedError;
import org.apache.slide.common.EmbeddedDomain;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.NamespaceAccessTokenImpl;
import org.apache.slide.util.Configuration;
import org.apache.slide.util.conf.ConfigurationElement;
import org.apache.slide.util.conf.ConfigurationException;
import org.apache.slide.util.conf.Populate;
import org.apache.slide.util.logger.Logger;
import org.apache.slide.util.logger.SimpleLogger;
import org.xml.sax.InputSource;

public final class Domain {
    private static final String LOG_CHANNEL = (class$org$apache$slide$common$Domain == null ? (class$org$apache$slide$common$Domain = Domain.class$("org.apache.slide.common.Domain")) : class$org$apache$slide$common$Domain).getName();
    private static EmbeddedDomain domain;
    private static Hashtable namespaces;
    private static boolean namespacesInitialized;
    private static Hashtable activeNamespaces;
    private static Logger logger;
    private static String defaultNamespace;
    private static Hashtable parameters;
    private static String domainFileName;
    static /* synthetic */ Class class$org$apache$slide$common$Domain;

    public static boolean isInitialized() {
        return domain != null || namespaces != null;
    }

    public static boolean namespacesAreInitialized() {
        return namespacesInitialized;
    }

    public static void setInitialized(boolean initialized) {
        if (initialized) {
            if (namespaces == null) {
                namespaces = new Hashtable();
            }
            if (activeNamespaces == null) {
                activeNamespaces = new Hashtable();
            }
            if (parameters == null) {
                parameters = new Hashtable();
            }
            if (logger == null) {
                logger = new SimpleLogger();
                logger.setLoggerLevel(6);
            }
            namespacesInitialized = true;
        }
    }

    public static String getDefaultNamespace() {
        if (!Domain.isInitialized()) {
            Domain.selfInit();
        }
        if (domain != null) {
            return domain.getDefaultNamespace();
        }
        return defaultNamespace;
    }

    public static NamespaceAccessToken accessNamespace(SecurityToken token, String namespaceName) {
        if (!Domain.isInitialized()) {
            Domain.selfInit();
        }
        if (domain != null) {
            return domain.getNamespaceToken(namespaceName);
        }
        Namespace namespace = (Namespace)namespaces.get(namespaceName);
        if (namespace == null) {
            return null;
        }
        return new NamespaceAccessTokenImpl(namespace);
    }

    public static Enumeration enumerateNamespaces() {
        if (!Domain.isInitialized()) {
            return new Vector().elements();
        }
        if (domain != null) {
            return domain.enumerateNamespaces();
        }
        return namespaces.keys();
    }

    public static void closeNamespace(NamespaceAccessToken token) {
        token.disconnect();
        activeNamespaces.remove(token.getName());
    }

    public static void closeNamespace(SecurityToken token, String namespaceName) {
        try {
            Namespace namespace = (Namespace)namespaces.get(namespaceName);
            namespace.disconnectServices();
            activeNamespaces.remove(namespaceName);
        }
        catch (Exception e) {}
    }

    public static DomainAccessToken accessDomain(SecurityToken token) {
        return null;
    }

    public static String getDomainFileName() {
        return domainFileName;
    }

    public static void init(URL configurationURL) throws Exception {
        if (Domain.isInitialized()) {
            return;
        }
        domainFileName = configurationURL.getFile();
        Domain.init(configurationURL.openStream());
    }

    public static void init(String configurationFileName) throws Exception {
        if (Domain.isInitialized()) {
            return;
        }
        domainFileName = configurationFileName;
        Domain.init(new FileInputStream(configurationFileName));
    }

    public static void init(InputStream configurationInputStream) throws Exception {
        if (Domain.isInitialized()) {
            return;
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        SAXParser parser = factory.newSAXParser();
        Populate pop = new Populate();
        ConfigurationElement slideConfiguration = new ConfigurationElement(pop.load(new InputSource(configurationInputStream), parser.getXMLReader()));
        Domain.init(slideConfiguration);
    }

    public static void init(org.apache.slide.util.conf.Configuration configuration) {
        if (Domain.isInitialized()) {
            return;
        }
        parameters = new Hashtable();
        defaultNamespace = configuration.getAttribute("default", "slide");
        parameters.put("default", defaultNamespace);
        String loggerClass = configuration.getAttribute("logger", "org.apache.slide.util.logger.SimpleLogger");
        parameters.put("logger", loggerClass);
        try {
            logger = (Logger)Class.forName(loggerClass).newInstance();
            int loggerLevel = configuration.getAttributeAsInt("logger-level", 6);
            logger.setLoggerLevel(loggerLevel);
            parameters.put("logger-level", "" + loggerLevel);
        }
        catch (Exception e) {
            if (logger == null) {
                System.err.println("Slide domain: initialization of logger failed.");
                e.printStackTrace();
            } else {
                Domain.error(e);
            }
            throw new DomainInitializationFailedError("Logger Problem: " + e.toString());
        }
        Domain.info("Initializing Domain");
        namespaces = new Hashtable();
        activeNamespaces = new Hashtable();
        Properties properties = Configuration.getDefault();
        Domain.info("Domain configuration : " + properties.toString());
        Enumeration parametersEnum = configuration.getConfigurations("parameter");
        while (parametersEnum.hasMoreElements()) {
            org.apache.slide.util.conf.Configuration p = (org.apache.slide.util.conf.Configuration)parametersEnum.nextElement();
            parameters.put(p.getAttribute("name"), p.getValue());
        }
        Domain.info("Domain parameters: " + String.valueOf(parameters));
        Enumeration namespaceDefinitions = configuration.getConfigurations("namespace");
        while (namespaceDefinitions.hasMoreElements()) {
            Domain.initNamespace((org.apache.slide.util.conf.Configuration)namespaceDefinitions.nextElement());
        }
        if (namespaces.isEmpty()) {
            throw new DomainInitializationFailedError();
        }
        namespacesInitialized = true;
    }

    public static void log(Object data, String channel, int level) {
        logger.log(data, channel, level);
    }

    public static void log(Object data, int level) {
        logger.log(data, LOG_CHANNEL, level);
    }

    public static void log(Object data) {
        logger.log(data, LOG_CHANNEL, 7);
    }

    public static void debug(Object data) {
        Domain.log(data, LOG_CHANNEL, 7);
    }

    public static void error(Object data) {
        Domain.log(data, LOG_CHANNEL, 2);
    }

    public static void error(Object data, Throwable t) {
        Domain.log(data + " - " + t.getMessage(), LOG_CHANNEL, 2);
        Domain.log(t, LOG_CHANNEL, 2);
    }

    public static void info(Object data) {
        Domain.log(data, LOG_CHANNEL, 6);
    }

    public static void warn(Object data) {
        Domain.log(data, LOG_CHANNEL, 4);
    }

    public static boolean isEnabled(String channel, int level) {
        return logger.isEnabled(channel, level);
    }

    public static boolean isEnabled(int level) {
        return logger.isEnabled(LOG_CHANNEL, level);
    }

    public static boolean isDebugEnabled() {
        return Domain.isEnabled(LOG_CHANNEL, 7);
    }

    public static boolean isWarningEnabled() {
        return Domain.isEnabled(LOG_CHANNEL, 4);
    }

    public static boolean isInfoEnabled() {
        return Domain.isEnabled(LOG_CHANNEL, 6);
    }

    public static boolean isErrorEnabled() {
        return Domain.isEnabled(LOG_CHANNEL, 2);
    }

    static void setDomain(EmbeddedDomain domain) {
        Domain.domain = domain;
    }

    static void start() throws Exception {
    }

    static void stop() throws Exception {
        Enumeration active = activeNamespaces.elements();
        while (active.hasMoreElements()) {
            ((Namespace)active.nextElement()).disconnectServices();
        }
    }

    static void addNamespace(Namespace namespace) {
        namespaces.put(namespace.getName(), namespace);
        activeNamespaces.put(namespace.getName(), namespace);
    }

    static Namespace getNamespace(String namespaceName) {
        return (Namespace)namespaces.get(namespaceName);
    }

    public static String getParameter(String name) {
        return (String)parameters.get(name);
    }

    public static String getParameter(String name, String defaultValue) {
        String result = (String)parameters.get(name);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    static void setParameters(Hashtable parameters) {
        Domain.parameters = parameters;
    }

    static void setLogger(Logger logger) {
        Domain.logger = logger;
    }

    static Logger getLogger() {
        return logger;
    }

    static void selfInit() {
        String loggerClass = "org.apache.slide.util.logger.SimpleLogger";
        if (logger == null) {
            try {
                logger = (Logger)Class.forName(loggerClass).newInstance();
                logger.setLoggerLevel(6);
            }
            catch (Exception e) {
                Domain.error(e);
                throw new DomainInitializationFailedError("Logger Problem: " + e.toString());
            }
        }
        Domain.info("Auto-Initializing Domain");
        Properties configuration = Configuration.getDefault();
        Domain.info("Domain configuration : " + configuration.toString());
        String fileName = Configuration.getDefault().getProperty("org.apache.slide.domain", "Domain.xml");
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            SAXParser parser = factory.newSAXParser();
            FileInputStream is = new FileInputStream(fileName);
            Populate pop = new Populate();
            ConfigurationElement slideConfiguration = new ConfigurationElement(pop.load(new InputSource(is), parser.getXMLReader()));
            Domain.init(slideConfiguration);
        }
        catch (FactoryConfigurationError e) {
            throw new DomainInitializationFailedError(e.getMessage());
        }
        catch (Exception e) {
            throw new DomainInitializationFailedError(e.getMessage());
        }
        Domain.info("Domain initialization complete");
    }

    private static void initNamespace(org.apache.slide.util.conf.Configuration configuration) {
        try {
            try {
                Domain.info("Initializing namespace : " + configuration.getAttribute("name"));
            }
            catch (ConfigurationException e) {
                Domain.error(e);
            }
            String loggerClass = configuration.getAttribute("logger", null);
            Logger namespaceLogger = null;
            if (loggerClass == null) {
                namespaceLogger = logger;
            } else {
                try {
                    namespaceLogger = (Logger)Class.forName(loggerClass).newInstance();
                    namespaceLogger.setLoggerLevel(configuration.getAttributeAsInt("logger-level", 6));
                }
                catch (Exception e) {
                    Domain.error(e);
                }
            }
            Namespace namespace = new Namespace();
            namespace.setName(configuration.getAttribute("name"));
            namespace.setLogger(namespaceLogger);
            org.apache.slide.util.conf.Configuration namespaceConfigurationDefinition = configuration.getConfiguration("configuration");
            namespace.loadParameters(namespaceConfigurationDefinition);
            org.apache.slide.util.conf.Configuration namespaceDefinition = configuration.getConfiguration("definition");
            namespace.loadDefinition(namespaceDefinition);
            Domain.addNamespace(namespace);
            try {
                org.apache.slide.util.conf.Configuration namespaceBaseDataDefinition = configuration.getConfiguration("data");
                namespace.loadBaseData(namespaceBaseDataDefinition);
            }
            catch (ConfigurationException e) {
                Domain.info("No basedata found for the namespace");
            }
            namespace.loadConfiguration(namespaceConfigurationDefinition);
            try {
                org.apache.slide.util.conf.Configuration services = configuration.getConfiguration("services");
                Enumeration s = services.getConfigurations("service");
                while (s.hasMoreElements()) {
                    org.apache.slide.util.conf.Configuration service = (org.apache.slide.util.conf.Configuration)s.nextElement();
                    System.out.println("&&&&&&Name       = " + service.getName());
                    System.out.println("&&&&&&className = " + service.getAttribute("classname"));
                    System.out.println("&&&&&&serviceName  = " + service.getAttribute("name"));
                    Enumeration s_pars = service.getConfigurations("parameter");
                    while (s_pars.hasMoreElements()) {
                        org.apache.slide.util.conf.Configuration s_par = (org.apache.slide.util.conf.Configuration)s_pars.nextElement();
                        System.out.println("&&&&&&PAR Name       = " + s_par.getName());
                        System.out.println("&&&&&&PAR Name       = " + s_par.getAttribute("name"));
                        System.out.println("&&&&&&Par Val        = " + s_par.getValue());
                    }
                }
            }
            catch (ConfigurationException e) {
            }
            catch (Exception e) {
                Domain.error(e);
            }
            Domain.info("Namespace configuration complete");
        }
        catch (Throwable t) {
            Domain.error(t);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        namespacesInitialized = false;
        domainFileName = "Domain.xml";
    }
}

