/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.client.v1.api.service;

import java.util.Collection;
import pl.grizzlysoftware.dotykacka.client.v1.api.dto.Ingredient;
import pl.grizzlysoftware.dotykacka.client.v1.api.dto.ProductIngredient;
import pl.grizzlysoftware.dotykacka.client.v1.api.dto.product.Product;
import pl.grizzlysoftware.dotykacka.client.v1.api.dto.product.ProductWithStockStatus;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface ProductService {
    @GET(value="{cloudId}/{warehouseId}/list")
    public Call<Collection<ProductWithStockStatus>> getProductsWithStockStatus(@Path(value="cloudId") Long var1, @Path(value="warehouseId") long var2, @Query(value="limit") int var4, @Query(value="offset") int var5, @Query(value="sort") String var6);

    @GET(value="{cloudId}/{productId}")
    public Call<Product> getProduct(@Path(value="cloudId") Long var1, @Path(value="productId") Long var2);

    @GET(value="withstockstatus/{cloudId}/{warehouseId}/{productId}")
    public Call<ProductWithStockStatus> getProductWithStockStatus(@Path(value="cloudId") Long var1, @Path(value="warehouseId") Long var2, @Path(value="productId") Long var3);

    @GET(value="stockstatus/{cloudId}/{warehouseId}/{productId}")
    public Call<ProductWithStockStatus> getProductStockStatus(@Path(value="cloudId") Long var1, @Path(value="warehouseId") Long var2, @Path(value="productId") Long var3);

    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    @POST(value="{cloudId}/create")
    public Call<Product> createProduct(@Path(value="cloudId") Long var1, @Body Product var2);

    @GET(value="{cloudId}/{id}/delete")
    public Call<Product> deleteProduct(@Path(value="cloudId") Long var1, @Path(value="id") Long var2);

    @POST(value="{cloudId}/{id}/update")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Call<Product> updateProduct(@Path(value="cloudId") Long var1, @Path(value="id") Long var2, @Body Product var3);

    @GET(value="{cloudId}")
    public Call<Collection<Product>> getProducts(@Path(value="cloudId") Long var1, @Query(value="limit") int var2, @Query(value="offset") int var3, @Query(value="sort") String var4);

    @GET(value="{cloudId}/{productId}/ingredients")
    public Call<Collection<ProductWithStockStatus>> getProductsIngredients(@Path(value="cloudId") Long var1, @Path(value="productId") Long var2, @Query(value="limit") int var3, @Query(value="offset") int var4, @Query(value="sort") String var5);

    @POST(value="{cloudId}/{productId}/ingredients/edit")
    public Call<Ingredient> createProductIngredient(@Path(value="cloudId") Long var1, @Body ProductIngredient var2);

    @POST(value="{cloudId}/{productId}/ingredients/{ingredientId}/delete")
    public Call<Ingredient> deleteProductIngredient(@Path(value="cloudId") Long var1, @Path(value="ingredientId") Long var2, @Body ProductIngredient var3);

    @GET(value="{cloudId}/ingredients")
    public Call<Collection<Ingredient>> getIngredients(@Path(value="cloudId") Long var1, @Query(value="limit") int var2, @Query(value="offset") int var3, @Query(value="sort") String var4);
}

