/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.client.v1.facade;

import java.util.Collection;
import pl.grizzlysoftware.dotykacka.client.v1.api.dto.Ingredient;
import pl.grizzlysoftware.dotykacka.client.v1.api.dto.ProductIngredient;
import pl.grizzlysoftware.dotykacka.client.v1.api.dto.product.Product;
import pl.grizzlysoftware.dotykacka.client.v1.api.dto.product.ProductWithStockStatus;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.ProductService;
import pl.grizzlysoftware.dotykacka.client.v1.facade.DotykackaApiServiceFacade;
import pl.grizzlysoftware.dotykacka.util.BatchLoader;

public class ProductServiceFacade
extends DotykackaApiServiceFacade<ProductService> {
    protected BatchLoader batchLoader = new BatchLoader(100);

    public ProductServiceFacade(Integer cloudId, ProductService service) {
        super(cloudId, service);
    }

    public Product getProduct(Long id) {
        Product out = this.execute(((ProductService)this.service).getProduct(this.cloudId, id));
        return out;
    }

    public Collection<Product> getProducts(int limit, int offset, String sortBy) {
        Collection<Product> out = this.execute(((ProductService)this.service).getProducts(this.cloudId, limit, offset, sortBy));
        return out;
    }

    public Collection<Product> getProducts(String sortBy) {
        Collection out = this.batchLoader.load(page -> this.getProducts(page.limit, page.offset, sortBy));
        return out;
    }

    public Collection<Product> getProducts() {
        Collection<Product> out = this.getProducts(null);
        return out;
    }

    public ProductWithStockStatus getProductWithStockStatus(Long warehouseId, Long productId) {
        ProductWithStockStatus out = this.execute(((ProductService)this.service).getProductWithStockStatus(this.cloudId, warehouseId, productId));
        return out;
    }

    public ProductWithStockStatus getProductStockStatus(Long warehouseId, Long productId) {
        ProductWithStockStatus out = this.execute(((ProductService)this.service).getProductStockStatus(this.cloudId, warehouseId, productId));
        return out;
    }

    public Collection<ProductWithStockStatus> getProductsWithStockStatus(long warehouseId, int limit, int offset, String sortBy) {
        return this.execute(((ProductService)this.service).getProductsWithStockStatus(this.cloudId, warehouseId, limit, offset, sortBy));
    }

    public Collection<ProductWithStockStatus> getProductsWithStockStatus(long warehouseId, String sortBy) {
        Collection out = this.batchLoader.load(page -> this.getProductsWithStockStatus(warehouseId, page.limit, page.offset, sortBy));
        return out;
    }

    public Collection<ProductWithStockStatus> getProductsWithStockStatus(long warehouseId) {
        Collection<ProductWithStockStatus> out = this.getProductsWithStockStatus(warehouseId, null);
        return out;
    }

    public Product updateProduct(Product product) {
        return this.execute(((ProductService)this.service).updateProduct(this.cloudId, product.id, product));
    }

    public Product createProduct(Product product) {
        return this.execute(((ProductService)this.service).createProduct(this.cloudId, product));
    }

    public Product deleteProduct(Long id) {
        return this.execute(((ProductService)this.service).deleteProduct(this.cloudId, id));
    }

    public Collection<ProductWithStockStatus> getProductIngredients(Long productId, int limit, int offset, String sortBy) {
        Collection<ProductWithStockStatus> out = this.execute(((ProductService)this.service).getProductsIngredients(this.cloudId, productId, limit, offset, sortBy));
        return out;
    }

    public Collection<ProductWithStockStatus> getProductIngredients(Long productId, String sortBy) {
        Collection out = this.batchLoader.load(page -> this.getProductIngredients(productId, page.limit, page.offset, sortBy));
        return out;
    }

    public Collection<ProductWithStockStatus> getProductIngredients(Long productId) {
        Collection<ProductWithStockStatus> out = this.getProductIngredients(productId, null);
        return out;
    }

    public Collection<Ingredient> getIngredients(int limit, int offset, String sortBy) {
        Collection<Ingredient> out = this.execute(((ProductService)this.service).getIngredients(this.cloudId, limit, offset, sortBy));
        return out;
    }

    public Collection<Ingredient> getIngredients(String sortBy) {
        Collection out = this.batchLoader.load(page -> this.getIngredients(page.limit, page.offset, sortBy));
        return out;
    }

    public Collection<Ingredient> getIngredients() {
        Collection<Ingredient> out = this.getIngredients(null);
        return out;
    }

    public Ingredient createProductIngredient(ProductIngredient productIngredient) {
        Ingredient out = this.execute(((ProductService)this.service).createProductIngredient(this.cloudId, productIngredient));
        return out;
    }

    public Ingredient deleteProductIngredient(ProductIngredient productIngredient) {
        Ingredient out = this.execute(((ProductService)this.service).deleteProductIngredient(this.cloudId, productIngredient.ingredientId, productIngredient));
        return out;
    }
}

