/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.client.v1.facade;

import java.util.Collection;
import pl.grizzlysoftware.dotykacka.client.v1.api.dto.Employee;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.EmployeeService;
import pl.grizzlysoftware.dotykacka.client.v1.facade.DotykackaApiServiceFacade;
import pl.grizzlysoftware.dotykacka.util.BatchLoader;

public class EmployeeServiceFacade
extends DotykackaApiServiceFacade<EmployeeService> {
    protected BatchLoader batchLoader = new BatchLoader(100);

    public EmployeeServiceFacade(Integer cloudId, EmployeeService service) {
        super(cloudId, service);
    }

    public Employee getEmployee(Long id) {
        Employee out = this.execute(((EmployeeService)this.service).getEmployee(this.cloudId, id));
        return out;
    }

    public Collection<Employee> getAllEmployees(int limit, int offset, String sortBy) {
        Collection<Employee> out = this.execute(((EmployeeService)this.service).getEmployees(this.cloudId, limit, offset, sortBy));
        return out;
    }

    public Collection<Employee> getAllEmployees(String sortBy) {
        Collection out = this.batchLoader.load(page -> this.getAllEmployees(page.limit, page.offset, sortBy));
        return out;
    }

    public Collection<Employee> getAllEmployees() {
        Collection<Employee> out = this.getAllEmployees(null);
        return out;
    }

    public Collection<Employee> getEmployees(int limit, int offset, String sortBy) {
        Collection<Employee> out = this.execute(((EmployeeService)this.service).getEmployees(this.cloudId, limit, offset, sortBy));
        return out;
    }

    public Collection<Employee> getEmployees(int limit, int offset) {
        Collection<Employee> out = this.getEmployees(limit, offset, null);
        return out;
    }

    public Employee updateEmployee(Long id, Employee customer) {
        return this.execute(((EmployeeService)this.service).updateEmployee(this.cloudId, id, customer));
    }

    public Employee createEmployee(Employee customer) {
        return this.execute(((EmployeeService)this.service).createEmployee(this.cloudId, customer));
    }

    public Employee deleteEmployee(Long id, boolean anonymize) {
        return this.execute(((EmployeeService)this.service).deleteEmployee(this.cloudId, id, anonymize));
    }

    public Employee deleteEmployee(Long id) {
        return this.execute(((EmployeeService)this.service).deleteEmployee(this.cloudId, id, null));
    }
}

