/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.util;

import java.util.Objects;
import pl.grizzlysoftware.dotykacka.client.v1.api.dto.oauth.OAuthApiToken;
import pl.grizzlysoftware.dotykacka.client.v1.facade.OAuthServiceFacade;
import pl.grizzlysoftware.dotykacka.model.Credentials;
import pl.grizzlysoftware.util.TokenProvider;

public class ApiTokenProvider
implements TokenProvider<OAuthApiToken> {
    protected final OAuthServiceFacade oauthService;
    protected Credentials credentials;
    protected OAuthApiToken apiToken;

    public ApiTokenProvider(OAuthServiceFacade oauthService, Credentials credentials) {
        this.oauthService = Objects.requireNonNull(oauthService);
        this.credentials = Objects.requireNonNull(credentials);
    }

    public ApiTokenProvider(OAuthServiceFacade oauthService, OAuthApiToken apiToken) {
        this.oauthService = Objects.requireNonNull(oauthService);
        this.apiToken = Objects.requireNonNull(apiToken);
    }

    void setApiToken(String token) {
        this.apiToken = token == null ? null : new OAuthApiToken(token);
    }

    @Override
    public OAuthApiToken acquireToken() {
        if (this.apiToken == null || this.apiToken.token == null) {
            this.apiToken = this.oauthService.apiToken(this.credentials.username, this.credentials.password);
        }
        return this.apiToken;
    }
}

