/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.client.v1;

import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import pl.grizzlysoftware.dotykacka.client.v1.api.dto.oauth.OAuthApiToken;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.CustomerService;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.OAuthService;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.ProductService;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.sales.MoneylogService;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.sales.OrderOpenService;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.sales.OrderService;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.sales.ReceiptService;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.sales.SalesService;
import pl.grizzlysoftware.dotykacka.client.v1.facade.CustomerServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v1.facade.OAuthServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v1.facade.ProductServiceFacade;
import pl.grizzlysoftware.dotykacka.client.v1.facade.SalesServiceFacade;
import pl.grizzlysoftware.dotykacka.model.Configuration;
import pl.grizzlysoftware.dotykacka.util.AccessTokenProvider;
import pl.grizzlysoftware.dotykacka.util.ApiTokenProvider;
import pl.grizzlysoftware.dotykacka.util.OAuthRequestInterceptor;
import pl.grizzlysoftware.util.OkHttpClientUtils;
import pl.grizzlysoftware.util.OkHttpLoggingInterceptor;
import pl.grizzlysoftware.util.RetrofitUtils;

public class DotykackaApiClient {
    public final OAuthServiceFacade oauthService;
    public final ProductServiceFacade productService;
    public final CustomerServiceFacade customerService;
    public final SalesServiceFacade salesService;
    protected Configuration configuration;
    protected AccessTokenProvider accessTokenProvider;
    protected ApiTokenProvider apiTokenProvider;

    public DotykackaApiClient(Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration).clone();
        OkHttpClient oAuthHttpClient = OkHttpClientUtils.builder().addInterceptor((Interceptor)new OkHttpLoggingInterceptor()).build();
        this.oauthService = new OAuthServiceFacade(RetrofitUtils.service(oAuthHttpClient, configuration.url + "/oauth", OAuthService.class));
        this.apiTokenProvider = configuration.apiTokenAuthCredentials == null ? new ApiTokenProvider(this.oauthService, new OAuthApiToken(configuration.apiToken)) : new ApiTokenProvider(this.oauthService, configuration.apiTokenAuthCredentials);
        this.accessTokenProvider = new AccessTokenProvider(this.oauthService, this.apiTokenProvider, configuration.accessTokenAuthCredentials, configuration.apiToken);
        OkHttpClient secureServiceHttpClient = OkHttpClientUtils.builder().addInterceptor((Interceptor)new OAuthRequestInterceptor(this.accessTokenProvider)).addInterceptor((Interceptor)new OkHttpLoggingInterceptor()).build();
        this.productService = new ProductServiceFacade(configuration.cloudId, RetrofitUtils.service(secureServiceHttpClient, configuration.url + "/api/product", ProductService.class));
        this.customerService = new CustomerServiceFacade(configuration.cloudId, RetrofitUtils.service(secureServiceHttpClient, configuration.url + "/api/customer", CustomerService.class));
        this.salesService = new SalesServiceFacade(configuration.cloudId, RetrofitUtils.service(secureServiceHttpClient, configuration.url + "/api/receipt", ReceiptService.class), RetrofitUtils.service(secureServiceHttpClient, configuration.url + "/api/order", OrderService.class), RetrofitUtils.service(secureServiceHttpClient, configuration.url + "/api/order-open", OrderOpenService.class), RetrofitUtils.service(secureServiceHttpClient, configuration.url + "/api/moneylog", MoneylogService.class), RetrofitUtils.service(secureServiceHttpClient, configuration.url + "/api/sales", SalesService.class));
    }
}

