/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.app.config.repository;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.util.Streamable;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class FhAnnotationRepositoryConfigurationSource
extends AnnotationRepositoryConfigurationSource {
    private AnnotationMetadata metadata;
    private Environment environment;

    public FhAnnotationRepositoryConfigurationSource(AnnotationMetadata metadata, Class<? extends Annotation> annotation, ResourceLoader resourceLoader, Environment environment, BeanDefinitionRegistry registry) {
        super(metadata, annotation, resourceLoader, environment, registry);
        this.metadata = metadata;
        this.environment = environment;
    }

    public Streamable<String> getBasePackages() {
        HashSet<String> packages = new HashSet<String>();
        this.extractValues(this.getAttributes().getStringArray("value"), packages);
        this.extractValues(this.getAttributes().getStringArray("basePackages"), packages);
        for (Class typeName : this.getAttributes().getClassArray("basePackageClasses")) {
            packages.add(ClassUtils.getPackageName((Class)typeName));
        }
        if (packages.size() == 0) {
            String className = this.metadata.getClassName();
            return Streamable.of(Collections.singleton(ClassUtils.getPackageName((String)className)));
        }
        HashSet<String> subPackages = new HashSet<String>();
        for (String currPackage : packages) {
            for (String subPackage : packages) {
                if (!subPackage.startsWith(currPackage + ".")) continue;
                subPackages.add(subPackage);
            }
        }
        packages.removeAll(subPackages);
        return Streamable.of(packages);
    }

    protected void extractValues(String[] basePackagesArray, Set<String> basePackages) {
        for (String pkg : basePackagesArray) {
            String[] tokenized = StringUtils.tokenizeToStringArray((String)this.environment.resolvePlaceholders(pkg), (String)",; \t\n");
            basePackages.addAll(Arrays.asList(tokenized));
        }
    }
}

